/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Applier;
import androidx.compose.runtime.ComposerKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Applier.kt\nandroidx/compose/runtime/OffsetApplier\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,289:1\n4644#2,4:290\n*S KotlinDebug\n*F\n+ 1 Applier.kt\nandroidx/compose/runtime/OffsetApplier\n*L\n263#1:290,4\n*E\n"})
public final class OffsetApplier<N>
implements Applier<N> {
    @NotNull
    private final Applier<N> applier;
    private final int offset;
    private int nesting;
    public static final int $stable = 8;

    public OffsetApplier(@NotNull Applier<N> applier, int offset) {
        Intrinsics.checkNotNullParameter(applier, (String)"applier");
        this.applier = applier;
        this.offset = offset;
    }

    @Override
    public N getCurrent() {
        return this.applier.getCurrent();
    }

    @Override
    public void down(N node2) {
        int n = this.nesting;
        this.nesting = n + 1;
        this.applier.down(node2);
    }

    @Override
    public void up() {
        boolean value$iv = this.nesting > 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("OffsetApplier up called with no corresponding down");
        }
        int n = this.nesting;
        this.nesting = n + -1;
        this.applier.up();
    }

    @Override
    public void insertTopDown(int index, N instance2) {
        this.applier.insertTopDown(index + (this.nesting == 0 ? this.offset : 0), instance2);
    }

    @Override
    public void insertBottomUp(int index, N instance2) {
        this.applier.insertBottomUp(index + (this.nesting == 0 ? this.offset : 0), instance2);
    }

    @Override
    public void remove(int index, int count) {
        this.applier.remove(index + (this.nesting == 0 ? this.offset : 0), count);
    }

    @Override
    public void move(int from, int to, int count) {
        int effectiveOffset = this.nesting == 0 ? this.offset : 0;
        this.applier.move(from + effectiveOffset, to + effectiveOffset, count);
    }

    @Override
    public void clear() {
        ComposerKt.composeImmediateRuntimeError("Clear is not valid on OffsetApplier");
    }
}

