/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import java.util.Arrays;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class IntStack {
    @JvmField
    @NotNull
    public int[] slots = new int[10];
    @JvmField
    public int tos;
    public static final int $stable = 8;

    private final int[] resize() {
        int[] nArray = Arrays.copyOf(this.slots, this.slots.length * 2);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        int[] copy2 = nArray;
        this.slots = copy2;
        return copy2;
    }

    public final void push(int value2) {
        int[] slots = this.slots;
        if (this.tos >= slots.length) {
            slots = this.resize();
        }
        int n = this.tos;
        this.tos = n + 1;
        slots[n] = value2;
    }

    public final int pop() {
        this.tos += -1;
        return this.slots[this.tos];
    }

    public final int peekOr(int n) {
        int index = this.tos - 1;
        return index >= 0 ? this.slots[index] : n;
    }

    public final int peek() {
        return this.slots[this.tos - 1];
    }

    public final int peek2() {
        return this.slots[this.tos - 2];
    }

    public final int peek(int index) {
        return this.slots[index];
    }

    public final void clear() {
        this.tos = 0;
    }

    public final int indexOf(int value2) {
        int[] slots = this.slots;
        int end = Math.min(slots.length, this.tos);
        for (int i2 = 0; i2 < end; ++i2) {
            if (slots[i2] != value2) continue;
            return i2;
        }
        return -1;
    }
}

