/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.runtime.DataSourceKt;
import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.SynchronizedObject;
import androidx.compose.runtime.collection.ExtensionsKt;
import androidx.compose.runtime.snapshots.ObserverHandle;
import androidx.compose.runtime.snapshots.Snapshot;
import androidx.compose.runtime.snapshots.SnapshotKt;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataSource<T, U> {
    @NotNull
    public static final Companion Companion = androidx.compose.runtime.DataSource$Companion.$$INSTANCE;

    public T startObservation(@NotNull Function1<Object, Boolean> var1);

    public void endObservation(T var1);

    public T pauseCurrentObservation();

    public void resumeCurrentObservation(T var1);

    public U startIsolation(@Nullable Function1<Object, Unit> var1);

    public void endIsolation(@Nullable Throwable var1, U var2);

    @SourceDebugExtension(value={"SMAP\nDataSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSource.kt\nandroidx/compose/runtime/DataSource$Companion\n+ 2 Preconditions.kt\nandroidx/compose/runtime/PreconditionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ObjectList.kt\nandroidx/collection/MutableObjectList\n+ 5 ObjectList.kt\nandroidx/collection/ObjectList\n+ 6 Snapshot.kt\nandroidx/compose/runtime/snapshots/SnapshotKt\n+ 7 Synchronization.desktop.kt\nandroidx/compose/runtime/platform/Synchronization_desktopKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,344:1\n34#2,4:345\n1#3:349\n903#4,5:350\n903#4,5:367\n903#4,5:384\n287#5,6:355\n329#5,6:361\n287#5,6:372\n329#5,6:378\n287#5,6:389\n329#5,6:395\n329#5,6:401\n287#5,6:407\n329#5,6:413\n329#5,6:419\n2031#6:425\n26#7:426\n1863#8,2:427\n*S KotlinDebug\n*F\n+ 1 DataSource.kt\nandroidx/compose/runtime/DataSource$Companion\n*L\n154#1:345,4\n187#1:350,5\n211#1:367,5\n245#1:384,5\n188#1:355,6\n194#1:361,6\n212#1:372,6\n218#1:378,6\n246#1:389,6\n251#1:395,6\n259#1:401,6\n246#1:407,6\n251#1:413,6\n259#1:419,6\n276#1:425\n276#1:426\n276#1:427,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <T, U> androidx.compose.runtime.ObserverHandle register(@NotNull DataSource<T, U> dataSource) {
            Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
            boolean value$iv = !DataSourceKt.getRegisteredDataSources().contains(dataSource);
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                PreconditionsKt.throwIllegalArgumentException("DataSource is already registered: " + dataSource);
            }
            boolean addingSucceeded = false;
            while (!addingSucceeded) {
                void $this$register_u24lambda_u241;
                MutableObjectList<DataSource<?, ?>> mutableObjectList;
                ObjectList<DataSource<?, ?>> currentDataSources = DataSourceKt.getRegisteredDataSources();
                MutableObjectList<DataSource<?, ?>> mutableObjectList2 = mutableObjectList = ExtensionsKt.toMutableObjectList(currentDataSources);
                ObjectList<DataSource<?, ?>> objectList = currentDataSources;
                AtomicReference atomicReference = DataSourceKt.access$getRegisteredDataSourcesReference$p();
                boolean bl = false;
                $this$register_u24lambda_u241.add(dataSource);
                Unit unit = Unit.INSTANCE;
                addingSucceeded = atomicReference.compareAndSet(objectList, mutableObjectList);
            }
            return () -> Companion.register$lambda$3(dataSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void invalidateDependants(@NotNull Set<? extends Object> identifiers) {
            List<Function2<Set<? extends Object>, Snapshot, Unit>> $i$a$-sync-DataSource$Companion$invalidateDependants$22;
            Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
            boolean $i$f$sync = false;
            SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv$iv;
            synchronized (synchronizedObject) {
                boolean $i$a$-sync-DataSource$Companion$invalidateDependants$22 = false;
                $i$a$-sync-DataSource$Companion$invalidateDependants$22 = SnapshotKt.getApplyObservers();
            }
            Iterable $this$forEach$iv = $i$a$-sync-DataSource$Companion$invalidateDependants$22;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function2 it = (Function2)element$iv;
                boolean bl = false;
                it.invoke(identifiers, (Object)Snapshot.Companion.getCurrent());
            }
        }

        @JvmStatic
        @NotNull
        public final androidx.compose.runtime.ObserverHandle registerInvalidator(@NotNull Function1<? super Set<? extends Object>, Unit> invalidator) {
            Intrinsics.checkNotNullParameter(invalidator, (String)"invalidator");
            ObserverHandle snapshotApplyObserver = Snapshot.Companion.registerApplyObserver((Function2<? super Set<? extends Object>, ? super Snapshot, Unit>)((Function2)(arg_0, arg_1) -> Companion.registerInvalidator$lambda$16(invalidator, arg_0, arg_1)));
            return () -> Companion.registerInvalidator$lambda$17(snapshotApplyObserver);
        }

        /*
         * WARNING - void declaration
         */
        private static final void register$lambda$3(DataSource $dataSource) {
            boolean removingSucceeded = false;
            while (!removingSucceeded) {
                void $this$register_u24lambda_u243_u24lambda_u242;
                MutableObjectList<DataSource<?, ?>> mutableObjectList;
                ObjectList<DataSource<?, ?>> currentDataSources = DataSourceKt.getRegisteredDataSources();
                MutableObjectList<DataSource<?, ?>> mutableObjectList2 = mutableObjectList = ExtensionsKt.toMutableObjectList(currentDataSources);
                ObjectList<DataSource<?, ?>> objectList = currentDataSources;
                AtomicReference atomicReference = DataSourceKt.access$getRegisteredDataSourcesReference$p();
                boolean bl = false;
                $this$register_u24lambda_u243_u24lambda_u242.remove((Object)$dataSource);
                Unit unit = Unit.INSTANCE;
                removingSucceeded = atomicReference.compareAndSet(objectList, mutableObjectList);
            }
        }

        private static final Unit registerInvalidator$lambda$16(Function1 $invalidator, Set identifiers, Snapshot snapshot2) {
            Intrinsics.checkNotNullParameter((Object)identifiers, (String)"identifiers");
            Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"<unused var>");
            $invalidator.invoke((Object)identifiers);
            return Unit.INSTANCE;
        }

        private static final void registerInvalidator$lambda$17(ObserverHandle $snapshotApplyObserver) {
            $snapshotApplyObserver.dispose();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

