/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.v2;

import androidx.compose.foundation.ScrollState;
import androidx.compose.foundation.v2.ScrollbarAdapter;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScrollableScrollbarAdapter
implements ScrollbarAdapter {
    @NotNull
    private final ScrollState scrollState;

    public ScrollableScrollbarAdapter(@NotNull ScrollState scrollState) {
        Intrinsics.checkNotNullParameter((Object)scrollState, (String)"scrollState");
        this.scrollState = scrollState;
    }

    @Override
    public double getScrollOffset() {
        return this.scrollState.getValue();
    }

    @Override
    @Nullable
    public Object scrollTo(double scrollOffset, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.scrollState.scrollTo(MathKt.roundToInt((double)scrollOffset), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public double getContentSize() {
        return (double)this.scrollState.getMaxValue() + this.getViewportSize();
    }

    @Override
    public double getViewportSize() {
        return this.scrollState.getViewportSize();
    }
}

