/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.platform.SynchronizedObject;
import androidx.compose.foundation.text.TextLayoutHelperKt;
import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegateKt;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayoutBuilder;
import androidx.compose.foundation.text.selection.TextSelectionDelegateKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nMultiWidgetSelectionDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiWidgetSelectionDelegate.kt\nandroidx/compose/foundation/text/selection/MultiWidgetSelectionDelegate\n+ 2 Synchronization.skiko.kt\nandroidx/compose/foundation/platform/SynchronizationKt\n+ 3 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n*L\n1#1,366:1\n27#2:367\n33#2:368\n59#3:369\n59#3:371\n90#4:370\n90#4:372\n278#5:373\n*S KotlinDebug\n*F\n+ 1 MultiWidgetSelectionDelegate.kt\nandroidx/compose/foundation/text/selection/MultiWidgetSelectionDelegate\n*L\n36#1:367\n52#1:368\n59#1:369\n68#1:371\n59#1:370\n68#1:372\n87#1:373\n*E\n"})
public final class MultiWidgetSelectionDelegate
implements Selectable {
    private final long selectableId;
    @NotNull
    private final Function0<LayoutCoordinates> coordinatesCallback;
    @NotNull
    private final Function0<TextLayoutResult> layoutResultCallback;
    @NotNull
    private final SynchronizedObject lock;
    @Nullable
    private TextLayoutResult _previousTextLayoutResult;
    private int _previousLastVisibleOffset;
    public static final int $stable = 8;

    public MultiWidgetSelectionDelegate(long selectableId, @NotNull Function0<? extends LayoutCoordinates> coordinatesCallback, @NotNull Function0<TextLayoutResult> layoutResultCallback) {
        Intrinsics.checkNotNullParameter(coordinatesCallback, (String)"coordinatesCallback");
        Intrinsics.checkNotNullParameter(layoutResultCallback, (String)"layoutResultCallback");
        this.selectableId = selectableId;
        this.coordinatesCallback = coordinatesCallback;
        this.layoutResultCallback = layoutResultCallback;
        boolean $i$f$makeSynchronizedObject = false;
        this.lock = new SynchronizedObject();
        this._previousLastVisibleOffset = -1;
    }

    @Override
    public long getSelectableId() {
        return this.selectableId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getLastVisibleOffset(TextLayoutResult $this$lastVisibleOffset) {
        int n;
        SynchronizedObject lock$iv = this.lock;
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            if (this._previousTextLayoutResult != $this$lastVisibleOffset) {
                int n2;
                if (!$this$lastVisibleOffset.getDidOverflowHeight() || $this$lastVisibleOffset.getMultiParagraph().getDidExceedMaxLines()) {
                    n2 = $this$lastVisibleOffset.getLineCount() - 1;
                } else {
                    int finalVisibleLine;
                    long arg0$iv = $this$lastVisibleOffset.getSize-YbymL2g();
                    boolean bl2 = false;
                    long value$iv$iv = arg0$iv;
                    boolean $i$f$unpackInt2 = false;
                    for (finalVisibleLine = RangesKt.coerceAtMost((int)$this$lastVisibleOffset.getLineForVerticalPosition((int)(value$iv$iv & 0xFFFFFFFFL)), (int)($this$lastVisibleOffset.getLineCount() - 1)); finalVisibleLine >= 0; --finalVisibleLine) {
                        arg0$iv = $this$lastVisibleOffset.getSize-YbymL2g();
                        bl2 = false;
                        value$iv$iv = arg0$iv;
                        $i$f$unpackInt2 = false;
                        if (!($this$lastVisibleOffset.getLineTop(finalVisibleLine) >= (float)((int)(value$iv$iv & 0xFFFFFFFFL)))) break;
                    }
                    n2 = RangesKt.coerceAtLeast((int)finalVisibleLine, (int)0);
                }
                int lastVisibleLine = n2;
                this._previousLastVisibleOffset = $this$lastVisibleOffset.getLineEnd(lastVisibleLine, true);
                this._previousTextLayoutResult = $this$lastVisibleOffset;
            }
            n = this._previousLastVisibleOffset;
        }
        return n;
    }

    @Override
    public void appendSelectableInfoToBuilder(@NotNull SelectionLayoutBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        LayoutCoordinates layoutCoordinates = this.getLayoutCoordinates();
        if (layoutCoordinates == null) {
            return;
        }
        LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        long relativePosition = builder.getContainerCoordinates().localPositionOf-R5De75A(layoutCoordinates2, Offset.Companion.getZero-F1C5BW0());
        long localPosition = Offset.minus-MK-Hz9U(builder.getCurrentPosition-F1C5BW0(), relativePosition);
        long $this$isUnspecified$iv = builder.getPreviousHandlePosition-F1C5BW0();
        boolean bl = false;
        long localPreviousHandlePosition = ($this$isUnspecified$iv & 0x7FFFFFFF7FFFFFFFL) == 9205357640488583168L ? Offset.Companion.getUnspecified-F1C5BW0() : Offset.minus-MK-Hz9U(builder.getPreviousHandlePosition-F1C5BW0(), relativePosition);
        MultiWidgetSelectionDelegateKt.appendSelectableInfo-Parwq6A(builder, textLayoutResult2, localPosition, localPreviousHandlePosition, this.getSelectableId());
    }

    @Override
    @Nullable
    public Selection getSelectAllSelection() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int start2 = 0;
        int end = textLayoutResult2.getLayoutInput().getText().length();
        return new Selection(new Selection.AnchorInfo(textLayoutResult2.getBidiRunDirection(start2), start2, this.getSelectableId()), new Selection.AnchorInfo(textLayoutResult2.getBidiRunDirection(Math.max(end - 1, 0)), end, this.getSelectableId()), false);
    }

    @Override
    public long getHandlePosition-dBAh8RU(@NotNull Selection selection, boolean isStartHandle) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (isStartHandle && selection.getStart().getSelectableId() != this.getSelectableId() || !isStartHandle && selection.getEnd().getSelectableId() != this.getSelectableId()) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        if (this.getLayoutCoordinates() == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int offset = isStartHandle ? selection.getStart().getOffset() : selection.getEnd().getOffset();
        int coercedOffset = RangesKt.coerceIn((int)offset, (int)0, (int)this.getLastVisibleOffset(textLayoutResult2));
        return TextSelectionDelegateKt.getSelectionHandleCoordinates(textLayoutResult2, coercedOffset, isStartHandle, selection.getHandlesCrossed());
    }

    @Override
    @Nullable
    public LayoutCoordinates getLayoutCoordinates() {
        LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.coordinatesCallback.invoke();
        if (layoutCoordinates == null || !layoutCoordinates.isAttached()) {
            return null;
        }
        return layoutCoordinates;
    }

    @Override
    @Nullable
    public TextLayoutResult textLayoutResult() {
        return (TextLayoutResult)this.layoutResultCallback.invoke();
    }

    @Override
    @NotNull
    public AnnotatedString getText() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return new AnnotatedString("", null, 2, null);
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult2.getLayoutInput().getText();
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Rect.Companion.getZero();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int textLength = textLayoutResult2.getLayoutInput().getText().length();
        if (textLength < 1) {
            return Rect.Companion.getZero();
        }
        return textLayoutResult2.getBoundingBox(RangesKt.coerceIn((int)offset, (int)0, (int)(textLength - 1)));
    }

    @Override
    public int getLastVisibleOffset() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return 0;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return this.getLastVisibleOffset(textLayoutResult2);
    }

    @Override
    public float getLineHeight(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        return textLayoutResult != null ? TextLayoutHelperKt.getLineHeight(textLayoutResult, offset) : 0.0f;
    }
}

