/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.modifiers.ParagraphLayoutCache;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorProducer;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Fill;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.AlignmentLineKt;
import androidx.compose.ui.layout.HorizontalAlignmentLine;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.DrawModifierNodeKt;
import androidx.compose.ui.node.LayoutModifierNode;
import androidx.compose.ui.node.LayoutModifierNodeKt;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.node.SemanticsModifierNodeKt;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nTextStringSimpleNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextStringSimpleNode.kt\nandroidx/compose/foundation/text/modifiers/TextStringSimpleNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 4 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 6 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 7 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 8 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n*L\n1#1,473:1\n1#2:474\n26#3:475\n26#3:476\n54#4:477\n54#4:479\n59#4:481\n59#4:483\n54#4:485\n59#4:487\n54#4:495\n59#4:497\n85#5:478\n85#5:480\n90#5:482\n90#5:484\n85#5:486\n90#5:488\n85#5:496\n90#5:498\n109#6,5:489\n233#7:494\n635#8:499\n635#8:500\n*S KotlinDebug\n*F\n+ 1 TextStringSimpleNode.kt\nandroidx/compose/foundation/text/modifiers/TextStringSimpleNode\n*L\n369#1:475\n370#1:476\n377#1:477\n378#1:479\n379#1:481\n380#1:483\n384#1:485\n384#1:487\n427#1:495\n428#1:497\n377#1:478\n378#1:480\n379#1:482\n380#1:484\n384#1:486\n384#1:488\n427#1:496\n428#1:498\n420#1:489,5\n424#1:494\n450#1:499\n452#1:500\n*E\n"})
public final class TextStringSimpleNode
extends Modifier.Node
implements DrawModifierNode,
LayoutModifierNode,
SemanticsModifierNode {
    @NotNull
    private String text;
    @NotNull
    private TextStyle style;
    @NotNull
    private FontFamily.Resolver fontFamilyResolver;
    private int overflow;
    private boolean softWrap;
    private int maxLines;
    private int minLines;
    @Nullable
    private ColorProducer overrideColor;
    @Nullable
    private Map<AlignmentLine, Integer> baselineCache;
    @Nullable
    private ParagraphLayoutCache _layoutCache;
    @Nullable
    private Function1<? super List<TextLayoutResult>, Boolean> semanticsTextLayoutResult;
    @Nullable
    private TextSubstitutionValue textSubstitution;
    public static final int $stable = 8;

    private TextStringSimpleNode(String text2, TextStyle style, FontFamily.Resolver fontFamilyResolver, int overflow, boolean softWrap, int maxLines, int minLines, ColorProducer overrideColor) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text2;
        this.style = style;
        this.fontFamilyResolver = fontFamilyResolver;
        this.overflow = overflow;
        this.softWrap = softWrap;
        this.maxLines = maxLines;
        this.minLines = minLines;
        this.overrideColor = overrideColor;
    }

    @Override
    public boolean getShouldAutoInvalidate() {
        return false;
    }

    private final ParagraphLayoutCache getLayoutCache() {
        if (this._layoutCache == null) {
            this._layoutCache = new ParagraphLayoutCache(this.text, this.style, this.fontFamilyResolver, this.overflow, this.softWrap, this.maxLines, this.minLines, null);
        }
        ParagraphLayoutCache paragraphLayoutCache = this._layoutCache;
        Intrinsics.checkNotNull((Object)paragraphLayoutCache);
        return paragraphLayoutCache;
    }

    private final ParagraphLayoutCache getLayoutCacheForMeasure(IntrinsicMeasureScope $this$getLayoutCacheForMeasure) {
        ParagraphLayoutCache activeCache = this.getLayoutCacheOrSubstitute();
        activeCache.setDensity$foundation($this$getLayoutCacheForMeasure);
        return activeCache;
    }

    @JvmName(name="getLayoutCacheOrSubstitute")
    private final ParagraphLayoutCache getLayoutCacheOrSubstitute() {
        Object object;
        block3: {
            block2: {
                TextSubstitutionValue textSubstitutionValue;
                object = this.textSubstitution;
                if (object == null) break block2;
                TextSubstitutionValue it = textSubstitutionValue = object;
                boolean bl = false;
                object = it.isShowingSubstitution() ? textSubstitutionValue : null;
                if (object != null && (object = ((TextSubstitutionValue)object).getLayoutCache()) != null) break block3;
            }
            object = this.getLayoutCache();
        }
        return object;
    }

    public final boolean updateDraw(@Nullable ColorProducer color, @NotNull TextStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        boolean changed = false;
        if (!Intrinsics.areEqual((Object)color, (Object)this.overrideColor)) {
            changed = true;
        }
        this.overrideColor = color;
        changed = changed || !style.hasSameDrawAffectingAttributes(this.style);
        return changed;
    }

    public final boolean updateText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (Intrinsics.areEqual((Object)this.text, (Object)text2)) {
            return false;
        }
        this.text = text2;
        this.clearSubstitution();
        return true;
    }

    public final boolean updateLayoutRelatedArgs-HuAbxIM(@NotNull TextStyle style, int minLines, int maxLines, boolean softWrap, @NotNull FontFamily.Resolver fontFamilyResolver, int overflow) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        boolean changed = false;
        changed = !this.style.hasSameLayoutAffectingAttributes(style);
        this.style = style;
        if (this.minLines != minLines) {
            this.minLines = minLines;
            changed = true;
        }
        if (this.maxLines != maxLines) {
            this.maxLines = maxLines;
            changed = true;
        }
        if (this.softWrap != softWrap) {
            this.softWrap = softWrap;
            changed = true;
        }
        if (!Intrinsics.areEqual((Object)this.fontFamilyResolver, (Object)fontFamilyResolver)) {
            this.fontFamilyResolver = fontFamilyResolver;
            changed = true;
        }
        if (!TextOverflow.equals-impl0(this.overflow, overflow)) {
            this.overflow = overflow;
            changed = true;
        }
        return changed;
    }

    public final void doInvalidations(boolean drawChanged, boolean textChanged, boolean layoutChanged) {
        if (textChanged || layoutChanged) {
            this.getLayoutCache().update-L6sJoHM(this.text, this.style, this.fontFamilyResolver, this.overflow, this.softWrap, this.maxLines, this.minLines);
        }
        if (!this.isAttached()) {
            return;
        }
        if (textChanged || drawChanged && this.semanticsTextLayoutResult != null) {
            SemanticsModifierNodeKt.invalidateSemantics(this);
        }
        if (textChanged || layoutChanged) {
            LayoutModifierNodeKt.invalidateMeasurement(this);
            DrawModifierNodeKt.invalidateDraw(this);
        }
        if (drawChanged) {
            DrawModifierNodeKt.invalidateDraw(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean setSubstitution(String updatedText) {
        TextSubstitutionValue currentTextSubstitution = this.textSubstitution;
        if (currentTextSubstitution != null) {
            if (Intrinsics.areEqual((Object)updatedText, (Object)currentTextSubstitution.getSubstitution())) {
                return false;
            }
            currentTextSubstitution.setSubstitution(updatedText);
            ParagraphLayoutCache paragraphLayoutCache = currentTextSubstitution.getLayoutCache();
            if (paragraphLayoutCache == null) return false;
            paragraphLayoutCache.update-L6sJoHM(updatedText, this.style, this.fontFamilyResolver, this.overflow, this.softWrap, this.maxLines, this.minLines);
            return true;
        } else {
            TextSubstitutionValue newTextSubstitution = new TextSubstitutionValue(this.text, updatedText, false, null, 12, null);
            ParagraphLayoutCache substitutionLayoutCache = new ParagraphLayoutCache(updatedText, this.style, this.fontFamilyResolver, this.overflow, this.softWrap, this.maxLines, this.minLines, null);
            substitutionLayoutCache.setDensity$foundation(this.getLayoutCache().getDensity$foundation());
            newTextSubstitution.setLayoutCache(substitutionLayoutCache);
            this.textSubstitution = newTextSubstitution;
        }
        return true;
    }

    private final void clearSubstitution() {
        this.textSubstitution = null;
    }

    @Override
    public void applySemantics(@NotNull SemanticsPropertyReceiver $this$applySemantics) {
        Intrinsics.checkNotNullParameter((Object)$this$applySemantics, (String)"<this>");
        Function1 localSemanticsTextLayoutResult = this.semanticsTextLayoutResult;
        if (localSemanticsTextLayoutResult == null) {
            this.semanticsTextLayoutResult = localSemanticsTextLayoutResult = arg_0 -> TextStringSimpleNode.applySemantics$lambda$2(this, arg_0);
        }
        SemanticsPropertiesKt.setText($this$applySemantics, new AnnotatedString(this.text, null, 2, null));
        TextSubstitutionValue currentTextSubstitution = this.textSubstitution;
        if (currentTextSubstitution != null) {
            SemanticsPropertiesKt.setShowingTextSubstitution($this$applySemantics, currentTextSubstitution.isShowingSubstitution());
            SemanticsPropertiesKt.setTextSubstitution($this$applySemantics, new AnnotatedString(currentTextSubstitution.getSubstitution(), null, 2, null));
        }
        SemanticsPropertiesKt.setTextSubstitution$default($this$applySemantics, null, arg_0 -> TextStringSimpleNode.applySemantics$lambda$3(this, arg_0), 1, null);
        SemanticsPropertiesKt.showTextSubstitution$default($this$applySemantics, null, arg_0 -> TextStringSimpleNode.applySemantics$lambda$4(this, arg_0), 1, null);
        SemanticsPropertiesKt.clearTextSubstitution$default($this$applySemantics, null, () -> TextStringSimpleNode.applySemantics$lambda$5(this), 1, null);
        SemanticsPropertiesKt.getTextLayoutResult$default($this$applySemantics, null, localSemanticsTextLayoutResult, 1, null);
    }

    private final void invalidateForTranslate() {
        SemanticsModifierNodeKt.invalidateSemantics(this);
        LayoutModifierNodeKt.invalidateMeasurement(this);
        DrawModifierNodeKt.invalidateDraw(this);
    }

    @Override
    @NotNull
    public MeasureResult measure-3p2s80s(@NotNull MeasureScope $this$measure_u2d3p2s80s, @NotNull Measurable measurable, long constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$measure_u2d3p2s80s, (String)"$this$measure");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        ParagraphLayoutCache layoutCache = this.getLayoutCacheForMeasure($this$measure_u2d3p2s80s);
        boolean didChangeLayout = layoutCache.layoutWithConstraints-K40F9xA(constraints, $this$measure_u2d3p2s80s.getLayoutDirection());
        layoutCache.getObserveFontChanges$foundation();
        Paragraph paragraph = layoutCache.getParagraph$foundation();
        Intrinsics.checkNotNull((Object)paragraph);
        Paragraph paragraph2 = paragraph;
        long layoutSize = layoutCache.getLayoutSize-YbymL2g$foundation();
        if (didChangeLayout) {
            LayoutModifierNodeKt.invalidateLayer(this);
            Map cache2 = this.baselineCache;
            if (cache2 == null) {
                this.baselineCache = cache2 = (Map)new HashMap(2);
            }
            Map map2 = cache2;
            HorizontalAlignmentLine horizontalAlignmentLine = AlignmentLineKt.getFirstBaseline();
            float $this$fastRoundToInt$iv22 = paragraph2.getFirstBaseline();
            boolean $i$f$fastRoundToInt = false;
            Integer $this$fastRoundToInt$iv22 = Math.round($this$fastRoundToInt$iv22);
            map2.put(horizontalAlignmentLine, $this$fastRoundToInt$iv22);
            map2 = cache2;
            horizontalAlignmentLine = AlignmentLineKt.getLastBaseline();
            float $this$fastRoundToInt$iv = paragraph2.getLastBaseline();
            $i$f$fastRoundToInt = false;
            Integer n = Math.round($this$fastRoundToInt$iv);
            map2.put(horizontalAlignmentLine, n);
        }
        boolean bl = false;
        long value$iv$iv = layoutSize;
        boolean $i$f$unpackInt1 = false;
        int n = (int)(value$iv$iv >> 32);
        bl = false;
        value$iv$iv = layoutSize;
        $i$f$unpackInt1 = false;
        int n2 = (int)(value$iv$iv >> 32);
        boolean bl2 = false;
        value$iv$iv = layoutSize;
        boolean $i$f$unpackInt2 = false;
        int n3 = (int)(value$iv$iv & 0xFFFFFFFFL);
        bl2 = false;
        value$iv$iv = layoutSize;
        $i$f$unpackInt2 = false;
        Placeable placeable = measurable.measure-BRTryo0(Constraints.Companion.fitPrioritizingWidth-Zbe2FdA(n, n2, n3, (int)(value$iv$iv & 0xFFFFFFFFL)));
        bl = false;
        value$iv$iv = layoutSize;
        $i$f$unpackInt1 = false;
        int n4 = (int)(value$iv$iv >> 32);
        bl2 = false;
        value$iv$iv = layoutSize;
        $i$f$unpackInt2 = false;
        int n5 = (int)(value$iv$iv & 0xFFFFFFFFL);
        Map<AlignmentLine, Integer> map3 = this.baselineCache;
        Intrinsics.checkNotNull(map3);
        return $this$measure_u2d3p2s80s.layout(n4, n5, map3, (Function1<? super Placeable.PlacementScope, Unit>)((Function1)arg_0 -> TextStringSimpleNode.measure_3p2s80s$lambda$6(placeable, arg_0)));
    }

    @Override
    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.getLayoutCacheForMeasure($this$minIntrinsicWidth).minIntrinsicWidth($this$minIntrinsicWidth.getLayoutDirection());
    }

    @Override
    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width) {
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.getLayoutCacheForMeasure($this$minIntrinsicHeight).intrinsicHeight(width, $this$minIntrinsicHeight.getLayoutDirection());
    }

    @Override
    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.getLayoutCacheForMeasure($this$maxIntrinsicWidth).maxIntrinsicWidth($this$maxIntrinsicWidth.getLayoutDirection());
    }

    @Override
    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width) {
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.getLayoutCacheForMeasure($this$maxIntrinsicHeight).intrinsicHeight(width, $this$maxIntrinsicHeight.getLayoutDirection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull ContentDrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (!this.isAttached()) {
            return;
        }
        ParagraphLayoutCache layoutCache = this.getLayoutCacheOrSubstitute();
        Paragraph value$iv = layoutCache.getParagraph$foundation();
        boolean $i$f$requirePreconditionNotNull = false;
        if (value$iv == null) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentExceptionForNullCheck("no paragraph (layoutCache=" + this._layoutCache + ", textSubstitution=" + this.textSubstitution + ")");
            throw new KotlinNothingValueException();
        }
        Paragraph localParagraph = value$iv;
        DrawScope $this$drawIntoCanvas$iv = $this$draw;
        boolean $i$f$drawIntoCanvas = false;
        Canvas canvas = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
        boolean bl = false;
        boolean willClip = layoutCache.getDidOverflow$foundation();
        if (willClip) {
            long arg0$iv = layoutCache.getLayoutSize-YbymL2g$foundation();
            boolean bl2 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt1 = false;
            float width = (int)(value$iv$iv >> 32);
            long arg0$iv2 = layoutCache.getLayoutSize-YbymL2g$foundation();
            boolean bl3 = false;
            long value$iv$iv2 = arg0$iv2;
            boolean $i$f$unpackInt2 = false;
            float height = (int)(value$iv$iv2 & 0xFFFFFFFFL);
            canvas.save();
            Canvas.clipRect-N_I0leg$default(canvas, 0.0f, 0.0f, width, height, 0, 16, null);
        }
        try {
            Brush brush;
            DrawStyle drawStyle;
            DrawStyle drawStyle2;
            Shadow shadow;
            Shadow shadow2;
            TextDecoration textDecoration;
            TextDecoration textDecoration2 = this.style.getTextDecoration();
            if (textDecoration2 == null) {
                textDecoration2 = textDecoration = TextDecoration.Companion.getNone();
            }
            if ((shadow2 = this.style.getShadow()) == null) {
                shadow2 = shadow = Shadow.Companion.getNone();
            }
            if ((drawStyle2 = this.style.getDrawStyle()) == null) {
                drawStyle2 = drawStyle = (DrawStyle)Fill.INSTANCE;
            }
            if ((brush = this.style.getBrush()) != null) {
                float alpha2 = this.style.getAlpha();
                Paragraph.paint-hn5TExg$default(localParagraph, canvas, brush, alpha2, shadow, textDecoration, drawStyle, 0, 64, null);
            } else {
                long l;
                long overrideColorVal;
                ColorProducer colorProducer2 = this.overrideColor;
                long $this$isSpecified$iv = overrideColorVal = colorProducer2 != null ? colorProducer2.invoke-0d7_KjU() : Color.Companion.getUnspecified-0d7_KjU();
                boolean bl4 = false;
                if ($this$isSpecified$iv != 16L) {
                    l = overrideColorVal;
                } else {
                    $this$isSpecified$iv = this.style.getColor-0d7_KjU();
                    bl4 = false;
                    l = $this$isSpecified$iv != 16L ? this.style.getColor-0d7_KjU() : Color.Companion.getBlack-0d7_KjU();
                }
                long color = l;
                Paragraph.paint-LG529CI$default(localParagraph, canvas, color, shadow, textDecoration, drawStyle, 0, 32, null);
            }
        }
        finally {
            if (willClip) {
                canvas.restore();
            }
        }
    }

    private static final boolean applySemantics$lambda$2(TextStringSimpleNode this$0, List textLayoutResult) {
        TextLayoutResult textLayoutResult2;
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        ColorProducer colorProducer2 = this$0.overrideColor;
        TextLayoutResult textLayoutResult3 = this$0.getLayoutCache().slowCreateTextLayoutResultOrNull(TextStyle.merge-dA7vx0o$default(this$0.style, colorProducer2 != null ? colorProducer2.invoke-0d7_KjU() : Color.Companion.getUnspecified-0d7_KjU(), 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, 0, 0, null, null, 0xFFFFFE, null));
        if (textLayoutResult3 != null) {
            TextLayoutResult textLayoutResult4;
            TextLayoutResult it = textLayoutResult4 = textLayoutResult3;
            boolean bl = false;
            textLayoutResult.add(it);
            textLayoutResult2 = textLayoutResult4;
        } else {
            textLayoutResult2 = null;
        }
        TextLayoutResult layout2 = textLayoutResult2;
        return layout2 != null;
    }

    private static final boolean applySemantics$lambda$3(TextStringSimpleNode this$0, AnnotatedString updatedText) {
        Intrinsics.checkNotNullParameter((Object)updatedText, (String)"updatedText");
        this$0.setSubstitution(updatedText.getText());
        this$0.invalidateForTranslate();
        return true;
    }

    private static final boolean applySemantics$lambda$4(TextStringSimpleNode this$0, boolean it) {
        if (this$0.textSubstitution == null) {
            return false;
        }
        TextSubstitutionValue textSubstitutionValue = this$0.textSubstitution;
        if (textSubstitutionValue != null) {
            textSubstitutionValue.setShowingSubstitution(it);
        }
        this$0.invalidateForTranslate();
        return true;
    }

    private static final boolean applySemantics$lambda$5(TextStringSimpleNode this$0) {
        this$0.clearSubstitution();
        this$0.invalidateForTranslate();
        return true;
    }

    private static final Unit measure_3p2s80s$lambda$6(Placeable $placeable, Placeable.PlacementScope $this$layout) {
        Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
        Placeable.PlacementScope.place$default($this$layout, $placeable, 0, 0, 0.0f, 4, null);
        return Unit.INSTANCE;
    }

    public /* synthetic */ TextStringSimpleNode(String text2, TextStyle style, FontFamily.Resolver fontFamilyResolver, int overflow, boolean softWrap, int maxLines, int minLines, ColorProducer overrideColor, DefaultConstructorMarker $constructor_marker) {
        this(text2, style, fontFamilyResolver, overflow, softWrap, maxLines, minLines, overrideColor);
    }

    public static final class TextSubstitutionValue {
        @NotNull
        private final String original;
        @NotNull
        private String substitution;
        private boolean isShowingSubstitution;
        @Nullable
        private ParagraphLayoutCache layoutCache;
        public static final int $stable = 8;

        public TextSubstitutionValue(@NotNull String original, @NotNull String substitution, boolean isShowingSubstitution, @Nullable ParagraphLayoutCache layoutCache) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)substitution, (String)"substitution");
            this.original = original;
            this.substitution = substitution;
            this.isShowingSubstitution = isShowingSubstitution;
            this.layoutCache = layoutCache;
        }

        public /* synthetic */ TextSubstitutionValue(String string, String string2, boolean bl, ParagraphLayoutCache paragraphLayoutCache, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                paragraphLayoutCache = null;
            }
            this(string, string2, bl, paragraphLayoutCache);
        }

        @NotNull
        public final String getSubstitution() {
            return this.substitution;
        }

        public final void setSubstitution(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.substitution = string;
        }

        public final boolean isShowingSubstitution() {
            return this.isShowingSubstitution;
        }

        public final void setShowingSubstitution(boolean bl) {
            this.isShowingSubstitution = bl;
        }

        @Nullable
        public final ParagraphLayoutCache getLayoutCache() {
            return this.layoutCache;
        }

        public final void setLayoutCache(@Nullable ParagraphLayoutCache paragraphLayoutCache) {
            this.layoutCache = paragraphLayoutCache;
        }

        @NotNull
        public String toString() {
            return "TextSubstitution(layoutCache=" + this.layoutCache + ", isShowingSubstitution=" + this.isShowingSubstitution + ")";
        }

        public int hashCode() {
            int result2 = this.original.hashCode();
            result2 = result2 * 31 + this.substitution.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isShowingSubstitution);
            result2 = result2 * 31 + (this.layoutCache == null ? 0 : this.layoutCache.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextSubstitutionValue)) {
                return false;
            }
            TextSubstitutionValue textSubstitutionValue = (TextSubstitutionValue)other;
            if (!Intrinsics.areEqual((Object)this.original, (Object)textSubstitutionValue.original)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.substitution, (Object)textSubstitutionValue.substitution)) {
                return false;
            }
            if (this.isShowingSubstitution != textSubstitutionValue.isShowingSubstitution) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.layoutCache, (Object)textSubstitutionValue.layoutCache);
        }
    }
}

