/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.text.UndoManagerKt;
import androidx.compose.foundation.text.UndoManager_jvmKt;
import androidx.compose.ui.text.input.TextFieldValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UndoManager {
    private final int maxStoredCharacters;
    @Nullable
    private Entry undoStack;
    @Nullable
    private Entry redoStack;
    private int storedCharacters;
    @Nullable
    private Long lastSnapshot;
    private boolean forceNextSnapshot;
    public static final int $stable = 8;

    public UndoManager(int maxStoredCharacters) {
        this.maxStoredCharacters = maxStoredCharacters;
    }

    public /* synthetic */ UndoManager(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100000;
        }
        this(n);
    }

    public final void snapshotIfNeeded(@NotNull TextFieldValue value2, long now2) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                if (this.forceNextSnapshot) break block2;
                Long l = this.lastSnapshot;
                if (now2 <= (l != null ? l : 0L) + (long)UndoManagerKt.getSNAPSHOTS_INTERVAL_MILLIS()) break block3;
            }
            this.lastSnapshot = now2;
            this.makeSnapshot(value2);
        }
    }

    public static /* synthetic */ void snapshotIfNeeded$default(UndoManager undoManager, TextFieldValue textFieldValue, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = UndoManager_jvmKt.timeNowMillis();
        }
        undoManager.snapshotIfNeeded(textFieldValue, l);
    }

    public final void forceNextSnapshot() {
        this.forceNextSnapshot = true;
    }

    public final void makeSnapshot(@NotNull TextFieldValue value2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.forceNextSnapshot = false;
        Entry entry = this.undoStack;
        if (Intrinsics.areEqual((Object)value2, (Object)(entry != null ? entry.getValue() : null))) {
            return;
        }
        if (Intrinsics.areEqual((Object)value2.getText(), (object = this.undoStack) != null && (object = ((Entry)object).getValue()) != null ? ((TextFieldValue)object).getText() : null)) {
            Entry entry2 = this.undoStack;
            if (entry2 != null) {
                entry2.setValue(value2);
            }
            return;
        }
        Entry entry3 = this.undoStack;
        this.undoStack = new Entry(entry3, value2);
        this.redoStack = null;
        this.storedCharacters += value2.getText().length();
        if (this.storedCharacters > this.maxStoredCharacters) {
            this.removeLastUndo();
        }
    }

    private final void removeLastUndo() {
        block2: {
            Entry entry;
            Entry entry2;
            Entry entry3 = entry2 = this.undoStack;
            if ((entry3 != null ? entry3.getNext() : null) == null) {
                return;
            }
            while (((entry = entry2) != null && (entry = entry.getNext()) != null ? entry.getNext() : null) != null) {
                entry2 = entry2.getNext();
            }
            Entry entry4 = entry2;
            if (entry4 == null) break block2;
            entry4.setNext(null);
        }
    }

    @Nullable
    public final TextFieldValue undo() {
        TextFieldValue textFieldValue;
        Entry entry = this.undoStack;
        if (entry != null) {
            Entry undoEntry = entry;
            boolean bl = false;
            Entry entry2 = undoEntry.getNext();
            if (entry2 != null) {
                Entry nextEntry = entry2;
                boolean bl2 = false;
                this.undoStack = nextEntry;
                this.storedCharacters -= undoEntry.getValue().getText().length();
                TextFieldValue textFieldValue2 = undoEntry.getValue();
                Entry entry3 = this.redoStack;
                this.redoStack = new Entry(entry3, textFieldValue2);
                textFieldValue = nextEntry.getValue();
            } else {
                textFieldValue = null;
            }
        } else {
            textFieldValue = null;
        }
        return textFieldValue;
    }

    @Nullable
    public final TextFieldValue redo() {
        TextFieldValue textFieldValue;
        Entry entry = this.redoStack;
        if (entry != null) {
            Entry redoEntry = entry;
            boolean bl = false;
            this.redoStack = redoEntry.getNext();
            TextFieldValue textFieldValue2 = redoEntry.getValue();
            Entry entry2 = this.undoStack;
            this.undoStack = new Entry(entry2, textFieldValue2);
            this.storedCharacters += redoEntry.getValue().getText().length();
            textFieldValue = redoEntry.getValue();
        } else {
            textFieldValue = null;
        }
        return textFieldValue;
    }

    public UndoManager() {
        this(0, 1, null);
    }

    private static final class Entry {
        @Nullable
        private Entry next;
        @NotNull
        private TextFieldValue value;

        public Entry(@Nullable Entry next2, @NotNull TextFieldValue value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.next = next2;
            this.value = value2;
        }

        @Nullable
        public final Entry getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Entry entry) {
            this.next = entry;
        }

        @NotNull
        public final TextFieldValue getValue() {
            return this.value;
        }

        public final void setValue(@NotNull TextFieldValue textFieldValue) {
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"<set-?>");
            this.value = textFieldValue;
        }
    }
}

