/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.foundation.interaction.FocusInteraction;
import androidx.compose.foundation.interaction.HoverInteraction;
import androidx.compose.foundation.interaction.Interaction;
import androidx.compose.foundation.interaction.InteractionSource;
import androidx.compose.foundation.interaction.PressInteraction;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.SnapshotIntStateKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nLinkStateInteractionSourceObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkStateInteractionSourceObserver.kt\nandroidx/compose/foundation/text/LinkStateInteractionSourceObserver\n+ 2 ObjectList.kt\nandroidx/collection/ObjectListKt\n*L\n1#1,70:1\n1516#2:71\n*S KotlinDebug\n*F\n+ 1 LinkStateInteractionSourceObserver.kt\nandroidx/compose/foundation/text/LinkStateInteractionSourceObserver\n*L\n36#1:71\n*E\n"})
public final class LinkStateInteractionSourceObserver {
    @NotNull
    private final InteractionSource interactionSource;
    private final int Focused;
    private final int Hovered;
    private final int Pressed;
    @NotNull
    private final MutableIntState interactionState;

    public LinkStateInteractionSourceObserver(@NotNull InteractionSource interactionSource) {
        Intrinsics.checkNotNullParameter((Object)interactionSource, (String)"interactionSource");
        this.interactionSource = interactionSource;
        this.Focused = 1;
        this.Hovered = 2;
        this.Pressed = 4;
        this.interactionState = SnapshotIntStateKt.mutableIntStateOf(0);
    }

    @Nullable
    public final Object collectInteractionsForLinks(@NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$mutableObjectListOf = false;
        MutableObjectList interactions2 = new MutableObjectList(0, 1, null);
        Object object = this.interactionSource.getInteractions().collect(new FlowCollector((MutableObjectList<Interaction>)interactions2, this){
            final /* synthetic */ MutableObjectList<Interaction> $interactions;
            final /* synthetic */ LinkStateInteractionSourceObserver this$0;
            {
                this.$interactions = $interactions;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final Object emit(Interaction interaction, Continuation<? super Unit> $completion) {
                void this_$iv;
                int state2 = 0;
                Interaction interaction2 = interaction;
                if (interaction2 instanceof HoverInteraction.Enter || interaction2 instanceof FocusInteraction.Focus || interaction2 instanceof PressInteraction.Press) {
                    this.$interactions.add((Object)interaction);
                } else if (interaction2 instanceof HoverInteraction.Exit) {
                    this.$interactions.remove((Object)((HoverInteraction.Exit)interaction).getEnter());
                } else if (interaction2 instanceof FocusInteraction.Unfocus) {
                    this.$interactions.remove((Object)((FocusInteraction.Unfocus)interaction).getFocus());
                } else if (interaction2 instanceof PressInteraction.Release) {
                    this.$interactions.remove((Object)((PressInteraction.Release)interaction).getPress());
                } else if (interaction2 instanceof PressInteraction.Cancel) {
                    this.$interactions.remove((Object)((PressInteraction.Cancel)interaction).getPress());
                }
                interaction2 = (ObjectList)this.$interactions;
                LinkStateInteractionSourceObserver linkStateInteractionSourceObserver = this.this$0;
                boolean $i$f$forEach = false;
                Object[] content$iv = this_$iv.content;
                int n = this_$iv._size;
                for (int i$iv = 0; i$iv < n; ++i$iv) {
                    Interaction it = (Interaction)content$iv[i$iv];
                    boolean bl = false;
                    Interaction interaction3 = it;
                    if (interaction3 instanceof HoverInteraction.Enter) {
                        state2 |= LinkStateInteractionSourceObserver.access$getHovered$p(linkStateInteractionSourceObserver);
                        continue;
                    }
                    if (interaction3 instanceof FocusInteraction.Focus) {
                        state2 |= LinkStateInteractionSourceObserver.access$getFocused$p(linkStateInteractionSourceObserver);
                        continue;
                    }
                    if (!(interaction3 instanceof PressInteraction.Press)) continue;
                    state2 |= LinkStateInteractionSourceObserver.access$getPressed$p(linkStateInteractionSourceObserver);
                }
                LinkStateInteractionSourceObserver.access$getInteractionState$p(this.this$0).setIntValue(state2);
                return Unit.INSTANCE;
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean isFocused() {
        return (this.interactionState.getIntValue() & this.Focused) != 0;
    }

    public final boolean isHovered() {
        return (this.interactionState.getIntValue() & this.Hovered) != 0;
    }

    public final boolean isPressed() {
        return (this.interactionState.getIntValue() & this.Pressed) != 0;
    }

    public static final /* synthetic */ MutableIntState access$getInteractionState$p(LinkStateInteractionSourceObserver $this) {
        return $this.interactionState;
    }

    public static final /* synthetic */ int access$getHovered$p(LinkStateInteractionSourceObserver $this) {
        return $this.Hovered;
    }

    public static final /* synthetic */ int access$getFocused$p(LinkStateInteractionSourceObserver $this) {
        return $this.Focused;
    }

    public static final /* synthetic */ int access$getPressed$p(LinkStateInteractionSourceObserver $this) {
        return $this.Pressed;
    }
}

