/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.IntrinsicHeightNode;
import androidx.compose.foundation.layout.IntrinsicSize;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.platform.InspectorInfo;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IntrinsicHeightElement
extends ModifierNodeElement<IntrinsicHeightNode> {
    @NotNull
    private final IntrinsicSize height;
    private final boolean enforceIncoming;
    @NotNull
    private final Function1<InspectorInfo, Unit> inspectorInfo;

    public IntrinsicHeightElement(@NotNull IntrinsicSize height, boolean enforceIncoming, @NotNull Function1<? super InspectorInfo, Unit> inspectorInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)height), (String)"height");
        Intrinsics.checkNotNullParameter(inspectorInfo, (String)"inspectorInfo");
        this.height = height;
        this.enforceIncoming = enforceIncoming;
        this.inspectorInfo = inspectorInfo;
    }

    @Override
    @NotNull
    public IntrinsicHeightNode create() {
        return new IntrinsicHeightNode(this.height, this.enforceIncoming);
    }

    @Override
    public void update(@NotNull IntrinsicHeightNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.setHeight(this.height);
        node2.setEnforceIncoming(this.enforceIncoming);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        IntrinsicHeightElement intrinsicHeightElement = other instanceof IntrinsicHeightElement ? (IntrinsicHeightElement)other : null;
        if (intrinsicHeightElement == null) {
            return false;
        }
        IntrinsicHeightElement otherModifierElement = intrinsicHeightElement;
        return this.height == otherModifierElement.height && this.enforceIncoming == otherModifierElement.enforceIncoming;
    }

    public int hashCode() {
        return 31 * this.height.hashCode() + Boolean.hashCode(this.enforceIncoming);
    }
}

