/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.RepeatMode;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class VectorizedInfiniteRepeatableSpec<V extends AnimationVector>
implements VectorizedAnimationSpec<V> {
    @NotNull
    private final VectorizedDurationBasedAnimationSpec<V> animation;
    @NotNull
    private final RepeatMode repeatMode;
    private final long durationNanos;
    private final long initialOffsetNanos;
    public static final int $stable = 8;

    private VectorizedInfiniteRepeatableSpec(VectorizedDurationBasedAnimationSpec<V> animation, RepeatMode repeatMode, long initialStartOffset) {
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)((Object)repeatMode), (String)"repeatMode");
        this.animation = animation;
        this.repeatMode = repeatMode;
        this.durationNanos = (long)(this.animation.getDelayMillis() + this.animation.getDurationMillis()) * 1000000L;
        this.initialOffsetNanos = initialStartOffset * 1000000L;
    }

    @Override
    public boolean isInfinite() {
        return true;
    }

    private final long repetitionPlayTimeNanos(long playTimeNanos) {
        if (playTimeNanos + this.initialOffsetNanos <= 0L) {
            return 0L;
        }
        long postOffsetPlayTimeNanos = playTimeNanos + this.initialOffsetNanos;
        long repeatsCount = postOffsetPlayTimeNanos / this.durationNanos;
        if (this.repeatMode == RepeatMode.Restart || repeatsCount % (long)2 == 0L) {
            return postOffsetPlayTimeNanos - repeatsCount * this.durationNanos;
        }
        return (repeatsCount + 1L) * this.durationNanos - postOffsetPlayTimeNanos;
    }

    private final V repetitionStartVelocity(long playTimeNanos, V start2, V startVelocity, V end) {
        return playTimeNanos + this.initialOffsetNanos > this.durationNanos ? this.animation.getVelocityFromNanos(this.durationNanos - this.initialOffsetNanos, start2, end, startVelocity) : startVelocity;
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return this.animation.getValueFromNanos(this.repetitionPlayTimeNanos(playTimeNanos), initialValue, targetValue, this.repetitionStartVelocity(playTimeNanos, initialValue, initialVelocity, targetValue));
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return this.animation.getVelocityFromNanos(this.repetitionPlayTimeNanos(playTimeNanos), initialValue, targetValue, this.repetitionStartVelocity(playTimeNanos, initialValue, initialVelocity, targetValue));
    }

    @Override
    public long getDurationNanos(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return Long.MAX_VALUE;
    }

    public /* synthetic */ VectorizedInfiniteRepeatableSpec(VectorizedDurationBasedAnimationSpec animation, RepeatMode repeatMode, long initialStartOffset, DefaultConstructorMarker $constructor_marker) {
        this(animation, repeatMode, initialStartOffset);
    }
}

