/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.Animations;
import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.animation.core.VectorizedFiniteAnimationSpec;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class VectorizedFloatAnimationSpec<V extends AnimationVector>
implements VectorizedFiniteAnimationSpec<V> {
    @NotNull
    private final Animations anims;
    private V valueVector;
    private V velocityVector;
    private V endVelocityVector;
    public static final int $stable = 8;

    public VectorizedFloatAnimationSpec(@NotNull Animations anims) {
        Intrinsics.checkNotNullParameter((Object)anims, (String)"anims");
        this.anims = anims;
    }

    public VectorizedFloatAnimationSpec(final @NotNull FloatAnimationSpec anim) {
        Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
        this(new Animations(){

            @Override
            public FloatAnimationSpec get(int index) {
                return anim;
            }
        });
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i2 = 0;
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i2 < n) {
            V v2 = this.valueVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$animation_core(i2, this.anims.get(i2).getValueFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$animation_core(i2), ((AnimationVector)targetValue).get$animation_core(i2), ((AnimationVector)initialVelocity).get$animation_core(i2)));
            ++i2;
        }
        V v3 = this.valueVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v3 = null;
        }
        return v3;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(initialVelocity);
        }
        int i2 = 0;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i2 < n) {
            V v2 = this.velocityVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$animation_core(i2, this.anims.get(i2).getVelocityFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$animation_core(i2), ((AnimationVector)targetValue).get$animation_core(i2), ((AnimationVector)initialVelocity).get$animation_core(i2)));
            ++i2;
        }
        V v3 = this.velocityVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v3 = null;
        }
        return v3;
    }

    @Override
    @NotNull
    public V getEndVelocity(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.endVelocityVector == null) {
            this.endVelocityVector = AnimationVectorsKt.newInstance(initialVelocity);
        }
        int i2 = 0;
        V v = this.endVelocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i2 < n) {
            V v2 = this.endVelocityVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$animation_core(i2, this.anims.get(i2).getEndVelocity(((AnimationVector)initialValue).get$animation_core(i2), ((AnimationVector)targetValue).get$animation_core(i2), ((AnimationVector)initialVelocity).get$animation_core(i2)));
            ++i2;
        }
        V v3 = this.endVelocityVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
            v3 = null;
        }
        return v3;
    }

    @Override
    public long getDurationNanos(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long maxDuration = 0L;
        int n = ((AnimationVector)initialValue).getSize$animation_core();
        for (int i2 = 0; i2 < n; ++i2) {
            maxDuration = Math.max(maxDuration, this.anims.get(i2).getDurationNanos(((AnimationVector)initialValue).get$animation_core(i2), ((AnimationVector)targetValue).get$animation_core(i2), ((AnimationVector)initialVelocity).get$animation_core(i2)));
        }
        return maxDuration;
    }
}

