/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.Animations;
import androidx.compose.animation.core.ArcSpline;
import androidx.compose.animation.core.FloatSpringSpec;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nVectorizedAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedAnimationSpecKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,1038:1\n119#2,10:1039\n*S KotlinDebug\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedAnimationSpecKt\n*L\n187#1:1039,10\n*E\n"})
public final class VectorizedAnimationSpecKt {
    @NotNull
    private static final int[] EmptyIntArray = new int[0];
    @NotNull
    private static final float[] EmptyFloatArray = new float[0];
    @NotNull
    private static final ArcSpline EmptyArcSpline;

    @NotNull
    public static final <V extends AnimationVector> V getValueFromMillis(@NotNull VectorizedAnimationSpec<V> $this$getValueFromMillis, long playTimeMillis, @NotNull V start2, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter($this$getValueFromMillis, (String)"<this>");
        Intrinsics.checkNotNullParameter(start2, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return $this$getValueFromMillis.getValueFromNanos(playTimeMillis * 1000000L, start2, end, startVelocity);
    }

    /*
     * WARNING - void declaration
     */
    public static final long clampPlayTime(@NotNull VectorizedDurationBasedAnimationSpec<?> $this$clampPlayTime, long playTime) {
        void $this$fastCoerceAtMost$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        Intrinsics.checkNotNullParameter($this$clampPlayTime, (String)"<this>");
        long l = playTime - (long)$this$clampPlayTime.getDelayMillis();
        long l2 = 0L;
        long maximumValue$iv = $this$clampPlayTime.getDurationMillis();
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        return $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
    }

    private static final <V extends AnimationVector> Animations createSpringAnimations(V visibilityThreshold, float dampingRatio, float stiffness) {
        return visibilityThreshold != null ? (Animations)new Animations(visibilityThreshold, dampingRatio, stiffness){
            private final FloatSpringSpec[] anims;
            {
                int n = 0;
                int n2 = ((AnimationVector)$visibilityThreshold).getSize$animation_core();
                FloatSpringSpec[] floatSpringSpecArray = new FloatSpringSpec[n2];
                createSpringAnimations.1 var8_7 = this;
                while (n < n2) {
                    int n3 = n++;
                    floatSpringSpecArray[n3] = new FloatSpringSpec($dampingRatio, $stiffness, ((AnimationVector)$visibilityThreshold).get$animation_core(n3));
                }
                var8_7.anims = floatSpringSpecArray;
            }

            public FloatSpringSpec get(int index) {
                return this.anims[index];
            }
        } : (Animations)new Animations(dampingRatio, stiffness){
            private final FloatSpringSpec anim;
            {
                this.anim = new FloatSpringSpec($dampingRatio, $stiffness, 0.0f, 4, null);
            }

            public FloatSpringSpec get(int index) {
                return this.anim;
            }
        };
    }

    public static final /* synthetic */ int[] access$getEmptyIntArray$p() {
        return EmptyIntArray;
    }

    public static final /* synthetic */ float[] access$getEmptyFloatArray$p() {
        return EmptyFloatArray;
    }

    public static final /* synthetic */ ArcSpline access$getEmptyArcSpline$p() {
        return EmptyArcSpline;
    }

    public static final /* synthetic */ Animations access$createSpringAnimations(AnimationVector visibilityThreshold, float dampingRatio, float stiffness) {
        return VectorizedAnimationSpecKt.createSpringAnimations(visibilityThreshold, dampingRatio, stiffness);
    }

    static {
        float[][] fArrayArray = new float[][]{new float[2], new float[2]};
        EmptyArcSpline = new ArcSpline(new int[2], new float[2], fArrayArray);
    }
}

