/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.StartDelayVectorizedAnimationSpec;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StartDelayAnimationSpec<T>
implements AnimationSpec<T> {
    @NotNull
    private final AnimationSpec<T> animationSpec;
    private final long startDelayNanos;

    public StartDelayAnimationSpec(@NotNull AnimationSpec<T> animationSpec, long startDelayNanos) {
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        this.animationSpec = animationSpec;
        this.startDelayNanos = startDelayNanos;
    }

    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedAnimationSpec<V> vectorize(@NotNull TwoWayConverter<T, V> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        VectorizedAnimationSpec<V> vecSpec = this.animationSpec.vectorize(converter);
        return new StartDelayVectorizedAnimationSpec<V>(vecSpec, this.startDelayNanos);
    }

    public int hashCode() {
        return 31 * this.animationSpec.hashCode() + Long.hashCode(this.startDelayNanos);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof StartDelayAnimationSpec)) {
            return false;
        }
        return ((StartDelayAnimationSpec)other).startDelayNanos == this.startDelayNanos && Intrinsics.areEqual(((StartDelayAnimationSpec)other).animationSpec, this.animationSpec);
    }
}

