/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.PreconditionsKt;
import androidx.compose.ui.graphics.BezierKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nEasing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Easing.kt\nandroidx/compose/animation/core/CubicBezierEasing\n+ 2 Preconditions.kt\nandroidx/compose/animation/core/PreconditionsKt\n+ 3 FloatFloatPair.kt\nandroidx/collection/FloatFloatPair\n+ 4 PackingHelpers.jvm.kt\nandroidx/collection/internal/PackingHelpers_jvmKt\n+ 5 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,179:1\n34#2,4:180\n51#3:184\n55#3:186\n22#4:185\n22#4:187\n65#5,10:188\n*S KotlinDebug\n*F\n+ 1 Easing.kt\nandroidx/compose/animation/core/CubicBezierEasing\n*L\n114#1:180,4\n119#1:184\n120#1:186\n119#1:185\n120#1:187\n153#1:188,10\n*E\n"})
public final class CubicBezierEasing
implements Easing {
    private final float a;
    private final float b;
    private final float c;
    private final float d;
    private final float min;
    private final float max;

    public CubicBezierEasing(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        boolean value$iv = !Float.isNaN(this.a) && !Float.isNaN(this.b) && !Float.isNaN(this.c) && !Float.isNaN(this.d);
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalArgumentException("Parameters to CubicBezierEasing cannot be NaN. Actual parameters are: " + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ".");
        }
        float[] roots = new float[5];
        long extrema = BezierKt.computeCubicVerticalBounds(0.0f, this.b, this.d, 1.0f, roots, 0);
        boolean bl = false;
        int bits$iv$iv = (int)(extrema >> 32);
        boolean $i$f$floatFromBits = false;
        this.min = Float.intBitsToFloat(bits$iv$iv);
        boolean bl2 = false;
        bits$iv$iv = (int)(extrema & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        this.max = Float.intBitsToFloat(bits$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float transform(float fraction) {
        float f;
        if (fraction > 0.0f && fraction < 1.0f) {
            void $this$fastCoerceAtMost$iv$iv;
            void minimumValue$iv;
            void $this$fastCoerceIn$iv;
            float f2 = Math.max(fraction, 1.1920929E-7f);
            float t2 = BezierKt.findFirstCubicRoot(0.0f - f2, this.a - f2, this.c - f2, 1.0f - f2);
            if (Float.isNaN(t2)) {
                this.throwNoSolution(fraction);
            }
            float f3 = BezierKt.evaluateCubic(this.b, this.d, t2);
            float f4 = this.min;
            float maximumValue$iv = this.max;
            boolean $i$f$fastCoerceIn = false;
            void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
            boolean $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
            boolean $i$f$fastCoerceAtMost = false;
            f = $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
        } else {
            f = fraction;
        }
        return f;
    }

    private final void throwNoSolution(float fraction) {
        throw new IllegalArgumentException("The cubic curve with parameters (" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ") has no solution at " + fraction);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CubicBezierEasing && this.a == ((CubicBezierEasing)other).a && this.b == ((CubicBezierEasing)other).b && this.c == ((CubicBezierEasing)other).c && this.d == ((CubicBezierEasing)other).d;
    }

    public int hashCode() {
        return ((Float.hashCode(this.a) * 31 + Float.hashCode(this.b)) * 31 + Float.hashCode(this.c)) * 31 + Float.hashCode(this.d);
    }

    @NotNull
    public String toString() {
        return "CubicBezierEasing(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ")";
    }
}

