/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationStateKt;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAnimationState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationState.kt\nandroidx/compose/animation/core/AnimationState\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,329:1\n85#2:330\n113#2,2:331\n*S KotlinDebug\n*F\n+ 1 AnimationState.kt\nandroidx/compose/animation/core/AnimationState\n*L\n49#1:330\n49#1:331,2\n*E\n"})
public final class AnimationState<T, V extends AnimationVector>
implements State<T> {
    @NotNull
    private final TwoWayConverter<T, V> typeConverter;
    @NotNull
    private final MutableState value$delegate;
    @NotNull
    private V velocityVector;
    private long lastFrameTimeNanos;
    private long finishedTimeNanos;
    private boolean isRunning;

    public AnimationState(@NotNull TwoWayConverter<T, V> typeConverter, T initialValue, @Nullable V initialVelocityVector, long lastFrameTimeNanos, long finishedTimeNanos, boolean isRunning) {
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        this.typeConverter = typeConverter;
        this.value$delegate = SnapshotStateKt.mutableStateOf$default(initialValue, null, 2, null);
        V v = initialVelocityVector;
        if (v == null || (v = AnimationVectorsKt.copy(v)) == null) {
            v = AnimationStateKt.createZeroVectorFrom(this.typeConverter, initialValue);
        }
        this.velocityVector = v;
        this.lastFrameTimeNanos = lastFrameTimeNanos;
        this.finishedTimeNanos = finishedTimeNanos;
        this.isRunning = isRunning;
    }

    public /* synthetic */ AnimationState(TwoWayConverter twoWayConverter, Object object, AnimationVector animationVector, long l, long l2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            animationVector = null;
        }
        if ((n & 8) != 0) {
            l = Long.MIN_VALUE;
        }
        if ((n & 0x10) != 0) {
            l2 = Long.MIN_VALUE;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(twoWayConverter, object, animationVector, l, l2, bl);
    }

    @NotNull
    public final TwoWayConverter<T, V> getTypeConverter() {
        return this.typeConverter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T getValue() {
        void $this$getValue$iv;
        State state2 = this.value$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setValue$animation_core(T t2) {
        void $this$setValue$iv;
        MutableState mutableState = this.value$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(t2);
    }

    @NotNull
    public final V getVelocityVector() {
        return this.velocityVector;
    }

    public final void setVelocityVector$animation_core(@NotNull V v) {
        Intrinsics.checkNotNullParameter(v, (String)"<set-?>");
        this.velocityVector = v;
    }

    public final long getLastFrameTimeNanos() {
        return this.lastFrameTimeNanos;
    }

    public final void setLastFrameTimeNanos$animation_core(long l) {
        this.lastFrameTimeNanos = l;
    }

    public final long getFinishedTimeNanos() {
        return this.finishedTimeNanos;
    }

    public final void setFinishedTimeNanos$animation_core(long l) {
        this.finishedTimeNanos = l;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final void setRunning$animation_core(boolean bl) {
        this.isRunning = bl;
    }

    public final T getVelocity() {
        return (T)this.typeConverter.getConvertFromVector().invoke(this.velocityVector);
    }

    @NotNull
    public String toString() {
        return "AnimationState(value=" + this.getValue() + ", velocity=" + this.getVelocity() + ", isRunning=" + this.isRunning + ", lastFrameTimeNanos=" + this.lastFrameTimeNanos + ", finishedTimeNanos=" + this.finishedTimeNanos + ")";
    }
}

