/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.core.FiniteAnimationSpec;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Slide {
    @NotNull
    private final Function1<IntSize, IntOffset> slideOffset;
    @NotNull
    private final FiniteAnimationSpec<IntOffset> animationSpec;

    public Slide(@NotNull Function1<? super IntSize, IntOffset> slideOffset, @NotNull FiniteAnimationSpec<IntOffset> animationSpec) {
        Intrinsics.checkNotNullParameter(slideOffset, (String)"slideOffset");
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        this.slideOffset = slideOffset;
        this.animationSpec = animationSpec;
    }

    @NotNull
    public final Function1<IntSize, IntOffset> getSlideOffset() {
        return this.slideOffset;
    }

    @NotNull
    public final FiniteAnimationSpec<IntOffset> getAnimationSpec() {
        return this.animationSpec;
    }

    @NotNull
    public String toString() {
        return "Slide(slideOffset=" + this.slideOffset + ", animationSpec=" + this.animationSpec + ")";
    }

    public int hashCode() {
        int result2 = this.slideOffset.hashCode();
        result2 = result2 * 31 + this.animationSpec.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Slide)) {
            return false;
        }
        Slide slide = (Slide)other;
        if (!Intrinsics.areEqual(this.slideOffset, slide.slideOffset)) {
            return false;
        }
        return Intrinsics.areEqual(this.animationSpec, slide.animationSpec);
    }
}

