/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.desktop.win;

import com.github.markusbernhardt.proxy.jna.win.WinHttp;
import com.github.markusbernhardt.proxy.jna.win.WinHttpCurrentUserIEProxyConfig;
import com.github.markusbernhardt.proxy.jna.win.WinHttpHelpers;
import com.github.markusbernhardt.proxy.jna.win.WinHttpProxyInfo;
import com.github.markusbernhardt.proxy.search.browser.ie.IEProxyConfig;
import com.github.markusbernhardt.proxy.search.desktop.win.WinHttpProxyConfig;
import com.github.markusbernhardt.proxy.selector.misc.ListProxySelector;
import com.github.markusbernhardt.proxy.selector.misc.ProtocolDispatchSelector;
import com.github.markusbernhardt.proxy.util.Logger;
import com.github.markusbernhardt.proxy.util.ProxyUtil;
import com.sun.jna.platform.win32.WinDef;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class WinProxySelector
extends ProxySelector {
    private ProxySelector impl;

    @Override
    public List<Proxy> select(URI uri) {
        if (this.impl == null) {
            this.impl = this.createImpl();
        }
        return this.impl.select(uri);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (this.impl == null) {
            return;
        }
        this.impl.connectFailed(uri, sa, ioe);
    }

    private ProxySelector createImpl() {
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Detecting Windows proxy settings", new Object[0]);
        ArrayList<ProxySelector> selectors = new ArrayList<ProxySelector>();
        IEProxyConfig ieProxyConfig = this.readIEProxyConfig();
        if (ieProxyConfig == null) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "ieProxyConfig is null.", new Object[0]);
        } else {
            this.addIfNotNull(selectors, this.createAutoDetectableProxySelectors(ieProxyConfig));
            this.addIfNotNull(selectors, this.createAutoConfigProxySelectors(ieProxyConfig));
            this.addIfNotNull(selectors, this.createFixedProxySelector(ieProxyConfig));
        }
        WinHttpProxyConfig winHttpProxyConfig = this.readWinHttpProxyConfig();
        if (winHttpProxyConfig == null) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "winHttpProxyConfig is null.", new Object[0]);
        } else {
            this.addIfNotNull(selectors, this.createWinHttpProxySelector(winHttpProxyConfig));
        }
        return new ListProxySelector(selectors, null);
    }

    private void addIfNotNull(List<ProxySelector> l, ProxySelector selector) {
        if (selector == null) {
            return;
        }
        l.add(selector);
    }

    private IEProxyConfig readIEProxyConfig() {
        WinHttpCurrentUserIEProxyConfig winHttpCurrentUserIeProxyConfig = new WinHttpCurrentUserIEProxyConfig();
        boolean successful = WinHttp.INSTANCE.WinHttpGetIEProxyConfigForCurrentUser(winHttpCurrentUserIeProxyConfig);
        if (!successful) {
            return null;
        }
        return new IEProxyConfig(winHttpCurrentUserIeProxyConfig.fAutoDetect, winHttpCurrentUserIeProxyConfig.lpszAutoConfigUrl != null ? winHttpCurrentUserIeProxyConfig.lpszAutoConfigUrl.getValue() : null, winHttpCurrentUserIeProxyConfig.lpszProxy != null ? winHttpCurrentUserIeProxyConfig.lpszProxy.getValue() : null, winHttpCurrentUserIeProxyConfig.lpszProxyBypass != null ? winHttpCurrentUserIeProxyConfig.lpszProxyBypass.getValue() : null);
    }

    private WinHttpProxyConfig readWinHttpProxyConfig() {
        WinHttpProxyInfo winHttpProxyInfo = new WinHttpProxyInfo();
        boolean successful = WinHttp.INSTANCE.WinHttpGetDefaultProxyConfiguration(winHttpProxyInfo);
        if (!successful) {
            return null;
        }
        return new WinHttpProxyConfig(winHttpProxyInfo.dwAccessType != null ? Integer.valueOf(winHttpProxyInfo.dwAccessType.intValue()) : null, winHttpProxyInfo.lpszProxy != null ? winHttpProxyInfo.lpszProxy.getValue() : null, winHttpProxyInfo.lpszProxyBypass != null ? winHttpProxyInfo.lpszProxyBypass.getValue() : null);
    }

    private ProxySelector createAutoDetectableProxySelectors(IEProxyConfig ieProxyConfig) {
        if (!ieProxyConfig.isAutoDetect()) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Auto-detecting not requested.", new Object[0]);
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Auto-detecting script URL.", new Object[0]);
        WinDef.DWORD dwAutoDetectFlags = new WinDef.DWORD(3L);
        String pacUrl = WinHttpHelpers.detectAutoProxyConfigUrl(dwAutoDetectFlags);
        if (pacUrl == null) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "PAC url not auto-detectable.", new Object[0]);
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.INFO, "IE uses script: " + pacUrl, new Object[0]);
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Created Auto-detecting proxy selector.", new Object[0]);
        return ProxyUtil.buildPacSelectorForUrl(pacUrl);
    }

    private ProxySelector createAutoConfigProxySelectors(IEProxyConfig ieProxyConfig) {
        String pacUrl = ieProxyConfig.getAutoConfigUrl();
        if (pacUrl == null || pacUrl.trim().length() == 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Auto-config not requested.", new Object[0]);
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.INFO, "IE uses script: " + pacUrl, new Object[0]);
        if (pacUrl.startsWith("file://") && !pacUrl.startsWith("file:///")) {
            pacUrl = pacUrl.replace("file://", "file:///");
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "PAC URL modified to " + pacUrl, new Object[0]);
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Created Auto-config proxy selector.", new Object[0]);
        return ProxyUtil.buildPacSelectorForUrl(pacUrl);
    }

    private ProxySelector createFixedProxySelector(IEProxyConfig ieProxyConfig) {
        String proxyString = ieProxyConfig.getProxy();
        String bypassList = ieProxyConfig.getProxyBypass();
        if (proxyString == null) {
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.INFO, "IE uses manual settings: {0} with bypass list: {1}", proxyString, bypassList);
        Properties p = ProxyUtil.parseProxyList(proxyString);
        ProtocolDispatchSelector ps = ProxyUtil.buildProtocolDispatchSelector(p);
        return ProxyUtil.setByPassListOnSelector(bypassList, ps);
    }

    private ProxySelector createWinHttpProxySelector(WinHttpProxyConfig proxyInfo) {
        if (proxyInfo.getAccessType() != 3) {
            return null;
        }
        String proxyString = proxyInfo.getProxy();
        String bypassList = proxyInfo.getProxyBypass();
        if (proxyString == null) {
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.INFO, "WinHttp uses manual settings: {0} with bypass list: {1}", proxyString, bypassList);
        Properties p = ProxyUtil.parseProxyList(proxyString);
        ProtocolDispatchSelector ps = ProxyUtil.buildProtocolDispatchSelector(p);
        return ProxyUtil.setByPassListOnSelector(bypassList, ps);
    }
}

