/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.client.id;

import com.jetbrains.fus.reporting.client.id.DigestUtil;
import com.jetbrains.fus.reporting.client.id.SystemInfoRt;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/fus/reporting/client/id/MachineIdGenerator;", "", "()V", "IOREG_COMMAND_TIMEOUT_MS", "", "linuxMachineIdPaths", "", "", "macMachineIdPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getAnonymizedMachineId", "purpose", "salt", "getLinuxMachineId", "getMacOsMachineId", "getMachineId", "hashSha256", "", "data", "id-generation"})
public final class MachineIdGenerator {
    @NotNull
    public static final MachineIdGenerator INSTANCE = new MachineIdGenerator();
    private static final long IOREG_COMMAND_TIMEOUT_MS = 2000L;
    private static final Pattern macMachineIdPattern = Pattern.compile("\"IOPlatformUUID\"\\s*=\\s*\"(?<machineId>.*)\"");
    @NotNull
    private static final List<String> linuxMachineIdPaths;

    private MachineIdGenerator() {
    }

    @JvmStatic
    @Nullable
    public static final String getAnonymizedMachineId(@NotNull String purpose, @NotNull String salt) {
        Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        if (((CharSequence)purpose).length() == 0) {
            throw new IllegalArgumentException("Argument [purpose] should not be empty.");
        }
        String string = INSTANCE.getMachineId();
        if (string == null) {
            return null;
        }
        String machineId = string;
        String string2 = System.getProperty("user.name") + purpose + salt;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return INSTANCE.hashSha256(byArray, machineId);
    }

    private final String getMachineId() {
        String string;
        try {
            string = SystemInfoRt.INSTANCE.isWindows() ? Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Microsoft\\Cryptography", (String)"MachineGuid") : (SystemInfoRt.INSTANCE.isMac() ? this.getMacOsMachineId() : (SystemInfoRt.INSTANCE.isLinux() ? this.getLinuxMachineId() : null));
        }
        catch (Throwable e) {
            string = null;
        }
        return string;
    }

    private final String getLinuxMachineId() {
        for (String machineIdPath : linuxMachineIdPaths) {
            try {
                String machineId = Files.readString(Paths.get(machineIdPath, new String[0]));
                CharSequence charSequence = machineId;
                if (charSequence == null || charSequence.length() == 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)machineId, (String)"machineId");
                return ((Object)StringsKt.trim((CharSequence)machineId)).toString();
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private final String getMacOsMachineId() {
        try {
            String[] stringArray = new String[]{"ioreg", "-rd1", "-c", "IOPlatformExpertDevice"};
            Process process = Runtime.getRuntime().exec(stringArray);
            boolean finished = process.waitFor(2000L, TimeUnit.MILLISECONDS);
            if (finished) {
                byte[] byArray = process.getInputStream().readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"process.inputStream.readAllBytes()");
                byte[] byArray2 = byArray;
                Matcher matcher = macMachineIdPattern.matcher(new String(byArray2, Charsets.UTF_8));
                if (matcher.find()) {
                    return matcher.group("machineId");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final String hashSha256(byte[] salt, String data) {
        MessageDigest md = DigestUtil.INSTANCE.sha256$id_generation();
        md.update(salt);
        String string = data;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        md.update(byArray);
        byte[] byArray2 = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"md.digest()");
        return DigestUtil.INSTANCE.bytesToHex$id_generation(byArray2);
    }

    static {
        Object[] objectArray = new String[]{"/etc/machine-id", "/var/lib/dbus/machine-id"};
        linuxMachineIdPaths = CollectionsKt.listOf((Object[])objectArray);
    }
}

