/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.keychain;

import com.jetbrains.keychain.InsecureKeychainBackend;
import com.jetbrains.keychain.KeychainBackend;
import com.jetbrains.keychain.LinuxKWalletKeychainBackend;
import com.jetbrains.keychain.LinuxLibsecretKeychainBackend;
import com.jetbrains.keychain.MacosKeychainBackend;
import com.jetbrains.keychain.WindowsKeychainBackend;
import com.sun.jna.Platform;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a3\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"selectBackend", "Lcom/jetbrains/keychain/KeychainBackend;", "preferred", "fallback", "other", "", "(Lcom/jetbrains/keychain/KeychainBackend;Lcom/jetbrains/keychain/KeychainBackend;[Lcom/jetbrains/keychain/KeychainBackend;)Lcom/jetbrains/keychain/KeychainBackend;", "appLocalData", "Ljava/io/File;", "", "keychain"})
public final class KeychainBackendKt {
    private static final KeychainBackend selectBackend(KeychainBackend preferred, KeychainBackend fallback, KeychainBackend ... other) {
        KeychainBackend keychainBackend;
        Logger logger;
        block4: {
            logger = LoggerFactory.getLogger(KeychainBackend.class);
            KeychainBackend keychainBackend2 = preferred;
            if (keychainBackend2 != null) {
                KeychainBackend keychainBackend3;
                KeychainBackend it = keychainBackend3 = keychainBackend2;
                boolean bl = false;
                KeychainBackend keychainBackend4 = it.isAvailable() ? keychainBackend3 : null;
                if (keychainBackend4 != null) {
                    it = keychainBackend4;
                    boolean bl2 = false;
                    logger.info("Using preferred keychain backend, " + it.getName());
                    return it;
                }
            }
            KeychainBackend[] $this$firstOrNull$iv = other;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int it = 0; it < n; ++it) {
                KeychainBackend element$iv;
                KeychainBackend it2 = element$iv = $this$firstOrNull$iv[it];
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it2, (Object)preferred) && !Intrinsics.areEqual((Object)it2, (Object)fallback) && it2.isAvailable())) continue;
                keychainBackend = element$iv;
                break block4;
            }
            keychainBackend = null;
        }
        if (keychainBackend != null) {
            KeychainBackend it = keychainBackend;
            boolean bl = false;
            logger.info("Using first available keychain backend, " + it.getName());
            return it;
        }
        logger.info("Using fallback keychain backend, " + fallback.getName());
        return fallback;
    }

    @NotNull
    public static final KeychainBackend selectBackend(@NotNull File appLocalData, @Nullable String preferred) {
        KeychainBackend keychainBackend;
        Intrinsics.checkNotNullParameter((Object)appLocalData, (String)"appLocalData");
        if (Platform.isWindows()) {
            keychainBackend = new WindowsKeychainBackend();
        } else if (Platform.isMac()) {
            keychainBackend = new MacosKeychainBackend();
        } else {
            if (Platform.isLinux()) {
                KeychainBackend keychainBackend2;
                KeychainBackend[] options;
                InsecureKeychainBackend fallback;
                block8: {
                    KeychainBackend[] keychainBackendArray;
                    LinuxKWalletKeychainBackend kWallet = new LinuxKWalletKeychainBackend();
                    LinuxLibsecretKeychainBackend libSecret = new LinuxLibsecretKeychainBackend();
                    fallback = new InsecureKeychainBackend(new File(appLocalData, ".securestorage"));
                    if (Intrinsics.areEqual((Object)System.getenv("XDG_CURRENT_DESKTOP"), (Object)"KDE")) {
                        var6_5 = new KeychainBackend[]{kWallet, libSecret, fallback};
                        keychainBackendArray = var6_5;
                    } else {
                        var6_5 = new KeychainBackend[]{libSecret, kWallet, fallback};
                        keychainBackendArray = var6_5;
                    }
                    KeychainBackend[] $this$firstOrNull$iv = options = keychainBackendArray;
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        KeychainBackend element$iv;
                        KeychainBackend it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)preferred)) continue;
                        keychainBackend2 = element$iv;
                        break block8;
                    }
                    keychainBackend2 = null;
                }
                KeychainBackend preferredBackend = keychainBackend2;
                return KeychainBackendKt.selectBackend(preferredBackend, fallback, Arrays.copyOf(options, options.length));
            }
            throw new IllegalStateException("Unsupported platform".toString());
        }
        return keychainBackend;
    }

    public static /* synthetic */ KeychainBackend selectBackend$default(File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return KeychainBackendKt.selectBackend(file, string);
    }
}

