/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal;

import java.util.Objects;
import java.util.Optional;
import jdk.jpackage.internal.model.ConfigException;
import jdk.jpackage.internal.model.LinuxRpmPackage;
import jdk.jpackage.internal.model.LinuxRpmPackageMixin;

final class LinuxRpmPackageBuilder {

    LinuxRpmPackageBuilder(LinuxPackageBuilder pkgBuilder) {
        this.pkgBuilder = Objects.requireNonNull(pkgBuilder);
    }

    LinuxRpmPackage create() throws ConfigException {
        if (pkgBuilder.release().isEmpty()) {
            pkgBuilder.release("1");
        }
        var pkg = pkgBuilder.create();
        return LinuxRpmPackage.create(pkg, new LinuxRpmPackageMixin.Stub(
                Optional.ofNullable(licenseType).orElseGet(DEFAULTS::licenseType)));
    }

    LinuxRpmPackageBuilder licenseType(String v) {
        licenseType = v;
        return this;
    }

    private record Defaults(String licenseType) {
    }

    private String licenseType;

    private final LinuxPackageBuilder pkgBuilder;

    private static final Defaults DEFAULTS = new Defaults(I18N.getString(
            "param.license-type.default"));
}
