/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal;

import java.util.Objects;
import java.util.Optional;
import jdk.jpackage.internal.model.ConfigException;
import jdk.jpackage.internal.model.LinuxDebPackage;
import jdk.jpackage.internal.model.LinuxDebPackageMixin;

final class LinuxDebPackageBuilder {

    LinuxDebPackageBuilder(LinuxPackageBuilder pkgBuilder) {
        this.pkgBuilder = Objects.requireNonNull(pkgBuilder);
    }

    LinuxDebPackage create() throws ConfigException {
        if (pkgBuilder.category().isEmpty()) {
            pkgBuilder.category(DEFAULTS.category());
        }
        var pkg = pkgBuilder.create();
        return LinuxDebPackage.create(pkg, new LinuxDebPackageMixin.Stub(
                Optional.ofNullable(maintainerEmail).orElseGet(
                        DEFAULTS::maintainerEmail)));
    }

    LinuxDebPackageBuilder maintainerEmail(String v) {
        maintainerEmail = v;
        return this;
    }

    private record Defaults(String maintainerEmail, String category) {
    }

    private String maintainerEmail;

    private final LinuxPackageBuilder pkgBuilder;

    private static final Defaults DEFAULTS = new Defaults("Unknown", "misc");
}
