/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.model;

import com.sun.jfx.incubator.scene.control.richtext.RtfStyledOutput;
import com.sun.jfx.incubator.scene.control.richtext.rtf.RTFReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javafx.scene.input.DataFormat;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.DataFormatHandler;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledInput;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;

public class RtfFormatHandler
extends DataFormatHandler {
    private static final RtfFormatHandler instance = new RtfFormatHandler();

    private RtfFormatHandler() {
        super(DataFormat.RTF);
    }

    public static final RtfFormatHandler getInstance() {
        return instance;
    }

    @Override
    public StyledInput createStyledInput(String string, StyleAttributeMap styleAttributeMap) throws IOException {
        try (RTFReader rTFReader = new RTFReader(string);){
            StyledInput styledInput = rTFReader.generateStyledInput();
            return styledInput;
        }
    }

    @Override
    public Object copy(StyledTextModel styledTextModel, StyleResolver styleResolver, TextPos textPos, TextPos textPos2) throws IOException {
        StringWriter stringWriter = new StringWriter(65536);
        this.export(styledTextModel, styleResolver, textPos, textPos2, stringWriter);
        return stringWriter.toString();
    }

    @Override
    public void save(StyledTextModel styledTextModel, StyleResolver styleResolver, TextPos textPos, TextPos textPos2, OutputStream outputStream) throws IOException {
        Charset charset = Charset.forName("ASCII");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset);
        this.export(styledTextModel, styleResolver, textPos, textPos2, outputStreamWriter);
    }

    private void export(StyledTextModel styledTextModel, StyleResolver styleResolver, TextPos textPos, TextPos textPos2, Writer writer) throws IOException {
        RtfStyledOutput rtfStyledOutput = new RtfStyledOutput(styleResolver, writer);
        styledTextModel.export(textPos, textPos2, rtfStyledOutput.firstPassBuilder());
        rtfStyledOutput.writePrologue();
        styledTextModel.export(textPos, textPos2, rtfStyledOutput);
        rtfStyledOutput.writeEpilogue();
        rtfStyledOutput.flush();
    }
}

