/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.model;

import java.util.ArrayList;
import java.util.function.Supplier;
import javafx.scene.layout.Region;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.PlainTextFormatHandler;
import jfx.incubator.scene.control.richtext.model.RichParagraph;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;

public class BasicTextModel
extends StyledTextModel {
    private final Content content;

    public BasicTextModel(Content content) {
        this.content = content;
        this.registerDataFormatHandler(PlainTextFormatHandler.getInstance(), true, true, 0);
    }

    public BasicTextModel() {
        this(new InMemoryContent());
    }

    public void insertText(TextPos textPos, String string) {
        this.replace(null, textPos, textPos, string);
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public String getPlainText(int n) {
        return this.content.getText(n);
    }

    @Override
    public RichParagraph getParagraph(int n) {
        String string = this.getPlainText(n);
        return RichParagraph.builder().addSegment(string).build();
    }

    @Override
    public final boolean isWritable() {
        return this.content.isWritable();
    }

    @Override
    protected int insertTextSegment(int n, int n2, String string, StyleAttributeMap styleAttributeMap) {
        return this.content.insertTextSegment(n, n2, string, styleAttributeMap);
    }

    @Override
    protected void insertLineBreak(int n, int n2) {
        this.content.insertLineBreak(n, n2);
    }

    @Override
    protected void removeRange(TextPos textPos, TextPos textPos2) {
        this.content.removeRange(textPos, textPos2);
    }

    @Override
    protected void insertParagraph(int n, Supplier<Region> supplier) {
    }

    @Override
    public StyleAttributeMap getStyleAttributeMap(StyleResolver styleResolver, TextPos textPos) {
        return StyleAttributeMap.EMPTY;
    }

    @Override
    protected void applyParagraphStyle(int n, StyleAttributeMap styleAttributeMap) {
    }

    @Override
    protected final void setParagraphStyle(int n, StyleAttributeMap styleAttributeMap) {
    }

    @Override
    protected final void applyStyle(int n, int n2, int n3, StyleAttributeMap styleAttributeMap, boolean bl) {
    }

    public static interface Content {
        public int size();

        public String getText(int var1);

        public int insertTextSegment(int var1, int var2, String var3, StyleAttributeMap var4);

        public void insertLineBreak(int var1, int var2);

        public void removeRange(TextPos var1, TextPos var2);

        public boolean isWritable();
    }

    public static class InMemoryContent
    implements Content {
        private final ArrayList<String> paragraphs = new ArrayList();

        @Override
        public int size() {
            int n = this.paragraphs.size();
            return n == 0 ? 1 : n;
        }

        @Override
        public String getText(int n) {
            if (n < this.paragraphs.size()) {
                return this.paragraphs.get(n);
            }
            return "";
        }

        @Override
        public int insertTextSegment(int n, int n2, String string, StyleAttributeMap styleAttributeMap) {
            String string2 = this.getText(n);
            String string3 = InMemoryContent.insertText(string2, n2, string);
            this.setText(n, string3);
            return string.length();
        }

        private static String insertText(String string, int n, String string2) {
            if (n >= string.length()) {
                return string + string2;
            }
            return string.substring(0, n) + string2 + string.substring(n);
        }

        @Override
        public void insertLineBreak(int n, int n2) {
            if (n >= this.paragraphs.size()) {
                this.paragraphs.add("");
            } else {
                String string = this.paragraphs.get(n);
                if (n2 >= string.length()) {
                    this.paragraphs.add(n + 1, "");
                } else {
                    this.setText(n, string.substring(0, n2));
                    this.paragraphs.add(n + 1, string.substring(n2));
                }
            }
        }

        @Override
        public void removeRange(TextPos textPos, TextPos textPos2) {
            int n = textPos.index();
            String string = this.getText(n);
            if (n == textPos2.index()) {
                int n2 = string.length();
                Object object = textPos2.offset() >= n2 ? string.substring(0, textPos.offset()) : string.substring(0, textPos.offset()) + string.substring(textPos2.offset());
                this.setText(n, (String)object);
            } else {
                String string2 = string.substring(0, textPos.offset()) + this.paragraphs.get(textPos2.index()).substring(textPos2.offset());
                this.setText(n, string2);
                int n3 = textPos2.index() - n;
                ++n;
                for (int i = 0; i < n3; ++i) {
                    this.paragraphs.remove(n);
                }
            }
        }

        private void setText(int n, String string) {
            if (n < this.paragraphs.size()) {
                this.paragraphs.set(n, string);
            } else {
                this.paragraphs.add(string);
            }
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }
}

