/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext;

import java.text.DecimalFormat;
import java.util.Arrays;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import jfx.incubator.scene.control.richtext.SideDecorator;

public class LineNumberDecorator
implements SideDecorator {
    private final DecimalFormat format;

    public LineNumberDecorator() {
        this(new DecimalFormat("#,##0"));
    }

    public LineNumberDecorator(DecimalFormat decimalFormat) {
        this.format = decimalFormat;
    }

    @Override
    public double getPrefWidth(double d) {
        return 0.0;
    }

    @Override
    public Node getMeasurementNode(int n) {
        String string = this.format.format(n + 300);
        char[] cArray = new char[string.length()];
        Arrays.fill(cArray, '8');
        return this.createNode(new String(cArray));
    }

    @Override
    public Node getNode(int n) {
        String string = this.format.format(n + 1);
        return this.createNode(string);
    }

    private Node createNode(String string) {
        Label label = new Label(string);
        label.getStyleClass().add((Object)"line-number-decorator");
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setMinHeight(1.0);
        label.setPrefHeight(1.0);
        label.setAlignment(Pos.CENTER_RIGHT);
        label.setOpacity(1.0);
        return label;
    }
}

