/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.async;

import com.sun.javafx.runtime.async.AbstractAsyncOperation;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Objects;

public abstract class AbstractRemoteResource<T>
extends AbstractAsyncOperation<T> {
    private final SizedStreamSupplier sizedStreamSupplier;

    protected AbstractRemoteResource(SizedStreamSupplier sizedStreamSupplier, AsyncOperationListener<T> asyncOperationListener) {
        super(asyncOperationListener);
        this.sizedStreamSupplier = Objects.requireNonNull(sizedStreamSupplier, "sizedStreamSupplier");
    }

    protected abstract T processStream(InputStream var1);

    @Override
    public T call() throws IOException {
        SizedStream sizedStream = this.sizedStreamSupplier.get();
        this.setProgressMax(sizedStream.size);
        try (ProgressInputStream progressInputStream = new ProgressInputStream(sizedStream.stream);){
            T t = this.processStream(progressInputStream);
            return t;
        }
    }

    public static interface SizedStreamSupplier {
        public SizedStream get() throws IOException;
    }

    public record SizedStream(InputStream stream, long size) {
    }

    protected class ProgressInputStream
    extends BufferedInputStream {
        public ProgressInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public synchronized int read() throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int n = super.read();
            AbstractRemoteResource.this.addProgress(1);
            return n;
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int n3 = super.read(byArray, n, n2);
            AbstractRemoteResource.this.addProgress(n3);
            return n3;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int n = super.read(byArray);
            AbstractRemoteResource.this.addProgress(n);
            return n;
        }
    }
}

