/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Combinator;
import com.sun.javafx.css.CompoundSelector;
import com.sun.javafx.css.SimpleSelector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.StyleConverter;
import javafx.geometry.NodeOrientation;

public class BinarySerializer {
    private static final int TYPE_SIMPLE = 1;
    private static final int TYPE_COMPOUND = 2;

    public static Selector read(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 1) {
            return BinarySerializer.readSimpleSelector(dataInputStream, stringArray);
        }
        return BinarySerializer.readCompoundSelector(dataInputStream, stringArray);
    }

    public static void write(Selector selector, DataOutputStream dataOutputStream, StyleConverter.StringStore stringStore) throws IOException {
        if (selector instanceof SimpleSelector) {
            SimpleSelector simpleSelector = (SimpleSelector)selector;
            BinarySerializer.writeSimpleSelector(simpleSelector, dataOutputStream, stringStore);
        } else if (selector instanceof CompoundSelector) {
            CompoundSelector compoundSelector = (CompoundSelector)selector;
            BinarySerializer.writeCompoundSelector(compoundSelector, dataOutputStream, stringStore);
        } else {
            throw new IllegalStateException("support missing for selector type: " + String.valueOf(selector == null ? "null" : selector.getClass()));
        }
    }

    private static SimpleSelector readSimpleSelector(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        String string = stringArray[dataInputStream.readShort()];
        int n = dataInputStream.readShort();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(stringArray[dataInputStream.readShort()]);
        }
        String string2 = stringArray[dataInputStream.readShort()];
        int n2 = dataInputStream.readShort();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            arrayList2.add(stringArray[dataInputStream.readShort()]);
        }
        return new SimpleSelector(string, arrayList, arrayList2, string2);
    }

    private static CompoundSelector readCompoundSelector(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        int n;
        int n2 = dataInputStream.readShort();
        ArrayList<SimpleSelector> arrayList = new ArrayList<SimpleSelector>();
        for (n = 0; n < n2; ++n) {
            byte by = dataInputStream.readByte();
            if (by != 1) {
                throw new IllegalStateException("Expected compound selector to consist of simple selectors only, but found type: " + by);
            }
            arrayList.add(BinarySerializer.readSimpleSelector(dataInputStream, stringArray));
        }
        n = dataInputStream.readShort();
        ArrayList<Combinator> arrayList2 = new ArrayList<Combinator>();
        for (int i = 0; i < n; ++i) {
            byte by = dataInputStream.readByte();
            if (by == Combinator.CHILD.ordinal()) {
                arrayList2.add(Combinator.CHILD);
                continue;
            }
            if (by == Combinator.DESCENDANT.ordinal()) {
                arrayList2.add(Combinator.DESCENDANT);
                continue;
            }
            assert (false) : "error deserializing CompoundSelector: Combinator = " + by;
            arrayList2.add(Combinator.DESCENDANT);
        }
        return new CompoundSelector(arrayList, arrayList2);
    }

    private static void writeCompoundSelector(CompoundSelector compoundSelector, DataOutputStream dataOutputStream, StyleConverter.StringStore stringStore) throws IOException {
        dataOutputStream.writeByte(2);
        List<SimpleSelector> list = compoundSelector.getSelectors();
        dataOutputStream.writeShort(list.size());
        for (int i = 0; i < list.size(); ++i) {
            BinarySerializer.writeSimpleSelector(list.get(i), dataOutputStream, stringStore);
        }
        List<Combinator> list2 = compoundSelector.getRelationships();
        dataOutputStream.writeShort(list2.size());
        for (int i = 0; i < list2.size(); ++i) {
            dataOutputStream.writeByte(list2.get(i).ordinal());
        }
    }

    private static void writeSimpleSelector(SimpleSelector simpleSelector, DataOutputStream dataOutputStream, StyleConverter.StringStore stringStore) throws IOException {
        Object object2;
        dataOutputStream.writeByte(1);
        List<String> list = simpleSelector.getStyleClasses();
        dataOutputStream.writeShort(stringStore.addString(simpleSelector.getName()));
        dataOutputStream.writeShort(list.size());
        for (Object object2 : list) {
            dataOutputStream.writeShort(stringStore.addString((String)object2));
        }
        dataOutputStream.writeShort(stringStore.addString(simpleSelector.getId()));
        Set<PseudoClass> set = simpleSelector.getPseudoClassStates();
        object2 = simpleSelector.getNodeOrientation();
        int n = set.size() + (object2 == NodeOrientation.RIGHT_TO_LEFT || object2 == NodeOrientation.LEFT_TO_RIGHT ? 1 : 0);
        dataOutputStream.writeShort(n);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            PseudoClass pseudoClass = (PseudoClass)iterator.next();
            dataOutputStream.writeShort(stringStore.addString(pseudoClass.getPseudoClassName()));
        }
        if (object2 == NodeOrientation.RIGHT_TO_LEFT) {
            dataOutputStream.writeShort(stringStore.addString("dir(rtl)"));
        } else if (object2 == NodeOrientation.LEFT_TO_RIGHT) {
            dataOutputStream.writeShort(stringStore.addString("dir(ltr)"));
        }
    }
}

