/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.model;

import com.sun.jfx.incubator.scene.control.richtext.StringBuilderStyledOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javafx.scene.input.DataFormat;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.DataFormatHandler;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledInput;
import jfx.incubator.scene.control.richtext.model.StyledOutput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;

public class PlainTextFormatHandler
extends DataFormatHandler {
    private static final PlainTextFormatHandler instance = new PlainTextFormatHandler();

    private PlainTextFormatHandler() {
        super(DataFormat.PLAIN_TEXT);
    }

    public static final PlainTextFormatHandler getInstance() {
        return instance;
    }

    @Override
    public StyledInput createStyledInput(String string, StyleAttributeMap styleAttributeMap) {
        return StyledInput.of(string, styleAttributeMap);
    }

    @Override
    public Object copy(StyledTextModel styledTextModel, StyleResolver styleResolver, TextPos textPos, TextPos textPos2) throws IOException {
        StringBuilderStyledOutput stringBuilderStyledOutput = new StringBuilderStyledOutput();
        styledTextModel.export(textPos, textPos2, stringBuilderStyledOutput);
        return stringBuilderStyledOutput.toString();
    }

    @Override
    public void save(StyledTextModel styledTextModel, StyleResolver styleResolver, TextPos textPos, TextPos textPos2, final OutputStream outputStream) throws IOException {
        final Charset charset = Charset.forName("utf-8");
        final byte[] byArray = System.getProperty("line.separator").getBytes(charset);
        StyledOutput styledOutput = new StyledOutput(){

            @Override
            public void consume(StyledSegment styledSegment) throws IOException {
                switch (styledSegment.getType()) {
                    case LINE_BREAK: {
                        outputStream.write(byArray);
                        break;
                    }
                    case TEXT: {
                        String string = styledSegment.getText();
                        byte[] byArray2 = string.getBytes(charset);
                        outputStream.write(byArray2);
                    }
                }
            }

            @Override
            public void flush() throws IOException {
                outputStream.flush();
            }

            @Override
            public void close() throws IOException {
                outputStream.close();
            }
        };
        styledTextModel.export(textPos, textPos2, styledOutput);
        outputStream.flush();
    }
}

