/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.control.GlobalMenuAdapter;
import com.sun.javafx.scene.control.IDisconnectable;
import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.MenuBarButton;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.skin.MenuButtonSkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Pair;
import javafx.util.Subscription;

public class MenuBarSkin
extends SkinBase<MenuBar> {
    private static final ObservableList<Window> stages = Window.getWindows().filtered(window -> window instanceof Stage);
    private final HBox container;
    private int focusedMenuIndex = -1;
    private Menu openMenu;
    private MenuBarButton openMenuButton;
    private static WeakHashMap<Stage, Reference<MenuBarSkin>> systemMenuMap;
    private static List<MenuBase> wrappedDefaultMenus;
    private static Stage currentMenuBarStage;
    private List<MenuBase> wrappedMenus;
    private ChangeListener<Boolean> menuBarFocusedPropertyListener;
    private WeakChangeListener<Boolean> weakMenuBarFocusedPropertyListener;
    private ChangeListener<Scene> sceneChangeListener;
    private ChangeListener<Boolean> menuVisibilityChangeListener;
    private WeakChangeListener<Boolean> weakMenuVisibilityChangeListener;
    private ListenerHelper sceneListenerHelper;
    private IDisconnectable windowFocusHelper;
    private volatile Subscription windowSubscription;
    private boolean pendingDismiss = false;
    private boolean altKeyPressed = false;
    private EventHandler<ActionEvent> menuActionEventHandler = actionEvent -> {
        CustomMenuItem customMenuItem;
        if (actionEvent.getSource() instanceof CustomMenuItem && !(customMenuItem = (CustomMenuItem)actionEvent.getSource()).isHideOnClick()) {
            return;
        }
        this.unSelectMenus();
    };
    private ListChangeListener<MenuItem> menuItemListener = change -> {
        while (change.next()) {
            for (MenuItem menuItem : change.getAddedSubList()) {
                this.updateActionListeners(menuItem, true);
            }
            for (MenuItem menuItem : change.getRemoved()) {
                this.updateActionListeners(menuItem, false);
            }
        }
    };
    Runnable firstMenuRunnable = new Runnable(){

        @Override
        public void run() {
            if (MenuBarSkin.this.container.getChildren().size() > 0 && MenuBarSkin.this.container.getChildren().get(0) instanceof MenuButton) {
                if (MenuBarSkin.this.focusedMenuIndex != 0) {
                    MenuBarSkin.this.unSelectMenus();
                    MenuBarSkin.this.menuModeStart(0);
                    MenuBarSkin.this.openMenuButton = (MenuBarButton)MenuBarSkin.this.container.getChildren().get(0);
                    MenuBarSkin.this.openMenuButton.setHover();
                } else {
                    MenuBarSkin.this.unSelectMenus();
                }
            }
        }
    };
    private DoubleProperty spacing;
    private ObjectProperty<Pos> containerAlignment;
    private static final CssMetaData<MenuBar, Number> SPACING;
    private static final CssMetaData<MenuBar, Pos> ALIGNMENT;
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public MenuBarSkin(MenuBar menuBar) {
        super(menuBar);
        this.container = new HBox();
        this.container.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)this.container);
        this.menuBarFocusedPropertyListener = (observableValue, bl, bl2) -> {
            this.unSelectMenus();
            if (bl2.booleanValue() && !this.container.getChildren().isEmpty()) {
                this.menuModeStart(0);
                this.openMenuButton = (MenuBarButton)this.container.getChildren().get(0);
                this.setFocusedMenuIndex(0);
                this.openMenuButton.setHover();
            }
        };
        this.weakMenuBarFocusedPropertyListener = new WeakChangeListener(this.menuBarFocusedPropertyListener);
        this.menuVisibilityChangeListener = (observableValue, bl, bl2) -> this.rebuildUI();
        this.weakMenuVisibilityChangeListener = new WeakChangeListener(this.menuVisibilityChangeListener);
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        if (Platform.isFxApplicationThread()) {
            if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
                listenerHelper.addInvalidationListener(menuBar.useSystemMenuBarProperty(), observable -> this.rebuildUI());
            }
        } else {
            this.windowSubscription = ((MenuBar)this.getSkinnable()).sceneProperty().flatMap(Scene::windowProperty).subscribe(window -> {
                if (window != null) {
                    if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
                        listenerHelper.addInvalidationListener(menuBar.useSystemMenuBarProperty(), observable -> this.rebuildUI());
                    }
                    this.rebuildUI();
                }
            });
        }
        this.rebuildUI();
        listenerHelper.addListChangeListener(menuBar.getMenus(), change -> this.rebuildUI());
        KeyCombination keyCombination = Utils.isMac() ? KeyCombination.keyCombination((String)"ctrl+F10") : KeyCombination.keyCombination((String)"F10");
        ParentTraversalEngine parentTraversalEngine = new ParentTraversalEngine((Parent)this.getSkinnable());
        parentTraversalEngine.addTraverseListener((node, bounds) -> {
            if (this.openMenu != null) {
                this.openMenu.hide();
            }
            this.setFocusedMenuIndex(0);
        });
        ParentHelper.setTraversalEngine((Parent)this.getSkinnable(), (ParentTraversalEngine)parentTraversalEngine);
        listenerHelper.addChangeListener(menuBar.sceneProperty(), true, scene -> {
            if (this.sceneListenerHelper != null) {
                this.sceneListenerHelper.disconnect();
                this.sceneListenerHelper = null;
            }
            if (scene != null) {
                this.sceneListenerHelper = new ListenerHelper();
                this.sceneListenerHelper.addEventFilter((EventTarget)scene, KeyEvent.KEY_PRESSED, keyEvent -> {
                    if (this.focusedMenuIndex >= 0) {
                        switch (keyEvent.getCode()) {
                            case LEFT: {
                                boolean bl;
                                boolean bl2 = bl = menuBar.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
                                if (menuBar.getScene().getWindow().isFocused()) {
                                    if (this.openMenu != null && !this.openMenu.isShowing()) {
                                        if (bl) {
                                            this.moveToMenu(Direction.NEXT, false);
                                        } else {
                                            this.moveToMenu(Direction.PREVIOUS, false);
                                        }
                                        keyEvent.consume();
                                        return;
                                    }
                                    if (bl) {
                                        this.moveToMenu(Direction.NEXT, true);
                                    } else {
                                        this.moveToMenu(Direction.PREVIOUS, true);
                                    }
                                }
                                keyEvent.consume();
                                break;
                            }
                            case RIGHT: {
                                boolean bl;
                                boolean bl3 = bl = menuBar.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
                                if (menuBar.getScene().getWindow().isFocused()) {
                                    if (this.openMenu != null && !this.openMenu.isShowing()) {
                                        if (bl) {
                                            this.moveToMenu(Direction.PREVIOUS, false);
                                        } else {
                                            this.moveToMenu(Direction.NEXT, false);
                                        }
                                        keyEvent.consume();
                                        return;
                                    }
                                    if (bl) {
                                        this.moveToMenu(Direction.PREVIOUS, true);
                                    } else {
                                        this.moveToMenu(Direction.NEXT, true);
                                    }
                                }
                                keyEvent.consume();
                                break;
                            }
                            case DOWN: {
                                if (!menuBar.getScene().getWindow().isFocused() || this.focusedMenuIndex == -1) break;
                                Menu menu = (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
                                this.showMenu(menu, true);
                                keyEvent.consume();
                                break;
                            }
                            case ESCAPE: {
                                this.unSelectMenus();
                                keyEvent.consume();
                                break;
                            }
                        }
                    }
                });
                this.sceneListenerHelper.addEventFilter((EventTarget)scene, MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                    Bounds bounds = this.container.localToScreen(this.container.getLayoutBounds());
                    if (bounds == null || !bounds.contains(mouseEvent.getScreenX(), mouseEvent.getScreenY())) {
                        this.unSelectMenus();
                    }
                });
                this.sceneListenerHelper.addChangeListener(scene.windowProperty(), true, window -> {
                    if (this.windowFocusHelper != null) {
                        this.windowFocusHelper.disconnect();
                        this.windowFocusHelper = null;
                    }
                    if (window != null) {
                        this.windowFocusHelper = this.sceneListenerHelper.addChangeListener(window.focusedProperty(), true, bl -> {
                            if (!bl.booleanValue()) {
                                this.unSelectMenus();
                            }
                        });
                    }
                });
                this.sceneListenerHelper.addEventFilter((EventTarget)scene, KeyEvent.ANY, keyEvent -> {
                    if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED) {
                        this.altKeyPressed = false;
                        if (keyEvent.getCode() == KeyCode.ALT && !keyEvent.isConsumed()) {
                            if (this.focusedMenuIndex == -1) {
                                this.altKeyPressed = true;
                            }
                            this.unSelectMenus();
                        }
                    } else if (keyEvent.getEventType() == KeyEvent.KEY_RELEASED) {
                        if (this.altKeyPressed && keyEvent.getCode() == KeyCode.ALT && !keyEvent.isConsumed()) {
                            this.firstMenuRunnable.run();
                        }
                        this.altKeyPressed = false;
                    }
                });
                scene.getAccelerators().put((Object)keyCombination, (Object)this.firstMenuRunnable);
                this.sceneListenerHelper.addDisconnectable(() -> scene.getAccelerators().remove((Object)keyCombination));
            }
        });
    }

    private void showMenu(Menu menu) {
        this.showMenu(menu, false);
    }

    private void showMenu(Menu menu, boolean bl) {
        if (this.openMenu == menu) {
            return;
        }
        if (this.openMenu != null) {
            this.openMenu.hide();
        }
        this.openMenu = menu;
        if (!menu.isShowing() && !this.isMenuEmpty(menu)) {
            MenuBarButton menuBarButton;
            Skin<?> skin;
            if (bl && (skin = (menuBarButton = this.menuBarButtonAt(this.focusedMenuIndex)).getSkin()) instanceof MenuButtonSkinBase) {
                ((MenuButtonSkinBase)skin).requestFocusOnFirstMenuItem();
            }
            this.openMenu.show();
        }
    }

    void setFocusedMenuIndex(int n) {
        int n2 = this.focusedMenuIndex = n >= -1 && n < ((MenuBar)this.getSkinnable()).getMenus().size() ? n : -1;
        if (this.focusedMenuIndex != -1) {
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            this.openMenuButton.setHover();
        }
    }

    public static void setDefaultSystemMenuBar(MenuBar menuBar) {
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            wrappedDefaultMenus.clear();
            for (Menu menu : menuBar.getMenus()) {
                wrappedDefaultMenus.add(GlobalMenuAdapter.adapt(menu));
            }
            menuBar.getMenus().addListener(change -> {
                wrappedDefaultMenus.clear();
                for (Menu menu : menuBar.getMenus()) {
                    wrappedDefaultMenus.add(GlobalMenuAdapter.adapt(menu));
                }
            });
        }
    }

    private static MenuBarSkin getMenuBarSkin(Stage stage) {
        if (systemMenuMap == null) {
            return null;
        }
        Reference<MenuBarSkin> reference = systemMenuMap.get(stage);
        return reference == null ? null : reference.get();
    }

    private static void setSystemMenu(Stage stage) {
        List<MenuBase> list;
        if (stage != null && stage.isFocused()) {
            while (stage != null && stage.getOwner() instanceof Stage && ((list = MenuBarSkin.getMenuBarSkin(stage)) == null || ((MenuBarSkin)((Object)list)).wrappedMenus == null)) {
                stage = (Stage)stage.getOwner();
            }
        } else {
            stage = null;
        }
        if (stage != currentMenuBarStage) {
            MenuBarSkin menuBarSkin;
            list = null;
            if (stage != null && (menuBarSkin = MenuBarSkin.getMenuBarSkin(stage)) != null) {
                list = menuBarSkin.wrappedMenus;
            }
            if (list == null) {
                list = wrappedDefaultMenus;
            }
            Toolkit.getToolkit().getSystemMenu().setMenus((List)list);
            currentMenuBarStage = stage;
        }
    }

    private static void initSystemMenuBar() {
        systemMenuMap = new WeakHashMap();
        InvalidationListener invalidationListener = observable -> MenuBarSkin.setSystemMenu((Stage)((ReadOnlyProperty)observable).getBean());
        for (Window window : stages) {
            window.focusedProperty().addListener(invalidationListener);
        }
        stages.addListener(change -> {
            while (change.next()) {
                for (Window window : change.getRemoved()) {
                    window.focusedProperty().removeListener(invalidationListener);
                }
                for (Window window : change.getAddedSubList()) {
                    window.focusedProperty().addListener(invalidationListener);
                    MenuBarSkin.setSystemMenu((Stage)window);
                }
            }
        });
    }

    public final void setSpacing(double d) {
        this.spacingProperty().set(this.snapSpaceX(d));
    }

    public final double getSpacing() {
        return this.spacing == null ? 0.0 : this.snapSpaceX(this.spacing.get());
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new StyleableDoubleProperty(){

                protected void invalidated() {
                    double d = this.get();
                    MenuBarSkin.this.container.setSpacing(d);
                }

                public Object getBean() {
                    return MenuBarSkin.this;
                }

                public String getName() {
                    return "spacing";
                }

                public CssMetaData<MenuBar, Number> getCssMetaData() {
                    return SPACING;
                }
            };
        }
        return this.spacing;
    }

    public final void setContainerAlignment(Pos pos) {
        this.containerAlignmentProperty().set((Object)pos);
    }

    public final Pos getContainerAlignment() {
        return this.containerAlignment == null ? Pos.TOP_LEFT : (Pos)this.containerAlignment.get();
    }

    public final ObjectProperty<Pos> containerAlignmentProperty() {
        if (this.containerAlignment == null) {
            this.containerAlignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                public void invalidated() {
                    Pos pos = (Pos)this.get();
                    MenuBarSkin.this.container.setAlignment(pos);
                }

                public Object getBean() {
                    return MenuBarSkin.this;
                }

                public String getName() {
                    return "containerAlignment";
                }

                public CssMetaData<MenuBar, Pos> getCssMetaData() {
                    return ALIGNMENT;
                }
            };
        }
        return this.containerAlignment;
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        if (this.sceneListenerHelper != null) {
            this.sceneListenerHelper.disconnect();
            this.sceneListenerHelper = null;
        }
        this.cleanUpListeners();
        if (Platform.isFxApplicationThread()) {
            this.cleanUpSystemMenu();
        } else {
            Platform.runLater(this::cleanUpSystemMenu);
        }
        this.getChildren().remove((Object)this.container);
        super.dispose();
    }

    @Override
    protected double snappedTopInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedTopInset();
    }

    @Override
    protected double snappedBottomInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedBottomInset();
    }

    @Override
    protected double snappedLeftInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedLeftInset();
    }

    @Override
    protected double snappedRightInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedRightInset();
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        this.container.resizeRelocate(d, d2, d3, d4);
    }

    @Override
    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        return this.container.minWidth(d) + this.snappedLeftInset() + this.snappedRightInset();
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        return this.container.prefWidth(d) + this.snappedLeftInset() + this.snappedRightInset();
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        return this.container.minHeight(d) + this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        return this.container.prefHeight(d) + this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected double computeMaxHeight(double d, double d2, double d3, double d4, double d5) {
        return ((MenuBar)this.getSkinnable()).prefHeight(-1.0);
    }

    MenuBarButton menuBarButtonAt(int n) {
        return (MenuBarButton)this.container.getChildren().get(n);
    }

    int getFocusedMenuIndex() {
        return this.focusedMenuIndex;
    }

    private boolean menusContainCustomMenuItem() {
        for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            if (!this.menuContainsCustomMenuItem(menu)) continue;
            System.err.println("Warning: MenuBar ignored property useSystemMenuBar because menus contain CustomMenuItem");
            return true;
        }
        return false;
    }

    private boolean menuContainsCustomMenuItem(Menu menu) {
        for (MenuItem menuItem : menu.getItems()) {
            if (menuItem instanceof CustomMenuItem && !(menuItem instanceof SeparatorMenuItem)) {
                return true;
            }
            if (!(menuItem instanceof Menu) || !this.menuContainsCustomMenuItem((Menu)menuItem)) continue;
            return true;
        }
        return false;
    }

    private int getMenuBarButtonIndex(MenuBarButton menuBarButton) {
        for (int i = 0; i < this.container.getChildren().size(); ++i) {
            MenuBarButton menuBarButton2 = (MenuBarButton)this.container.getChildren().get(i);
            if (menuBarButton != menuBarButton2) continue;
            return i;
        }
        return -1;
    }

    private void updateActionListeners(MenuItem menuItem, boolean bl) {
        if (menuItem instanceof Menu) {
            Menu menu = (Menu)menuItem;
            if (bl) {
                menu.getItems().addListener(this.menuItemListener);
            } else {
                menu.getItems().removeListener(this.menuItemListener);
            }
            for (MenuItem menuItem2 : menu.getItems()) {
                this.updateActionListeners(menuItem2, bl);
            }
        } else if (bl) {
            menuItem.addEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
        } else {
            menuItem.removeEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
        }
    }

    private void cleanUpListeners() {
        Subscription subscription = this.windowSubscription;
        if (subscription != null) {
            subscription.unsubscribe();
            this.windowSubscription = null;
        }
        ((MenuBar)this.getSkinnable()).focusedProperty().removeListener(this.weakMenuBarFocusedPropertyListener);
        for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            this.updateActionListeners(menu, false);
            menu.visibleProperty().removeListener(this.weakMenuVisibilityChangeListener);
        }
        for (Menu menu : this.container.getChildren()) {
            MenuBarButton menuBarButton = (MenuBarButton)((Object)menu);
            menuBarButton.hide();
            menuBarButton.menu.showingProperty().removeListener(menuBarButton.menuListener);
            menuBarButton.disableProperty().unbind();
            menuBarButton.textProperty().unbind();
            menuBarButton.graphicProperty().unbind();
            menuBarButton.styleProperty().unbind();
            menuBarButton.dispose();
            menuBarButton.setSkin(null);
            menuBarButton = null;
        }
        this.container.getChildren().clear();
    }

    private void rebuildUI() {
        if (!Platform.isFxApplicationThread()) {
            return;
        }
        this.cleanUpListeners();
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            Object object;
            Scene scene3 = ((MenuBar)this.getSkinnable()).getScene();
            if (scene3 != null) {
                if (this.sceneChangeListener == null) {
                    this.sceneChangeListener = (observableValue, scene, scene2) -> {
                        Stage stage;
                        if (scene != null && scene.getWindow() instanceof Stage) {
                            stage = (Stage)scene.getWindow();
                            MenuBarSkin menuBarSkin = MenuBarSkin.getMenuBarSkin(stage);
                            if (menuBarSkin == this) {
                                menuBarSkin.wrappedMenus = null;
                                systemMenuMap.remove(stage);
                                if (currentMenuBarStage == stage) {
                                    currentMenuBarStage = null;
                                    MenuBarSkin.setSystemMenu(stage);
                                }
                            } else if (((MenuBar)this.getSkinnable()).isUseSystemMenuBar() && menuBarSkin != null && menuBarSkin.getSkinnable() != null && ((MenuBar)menuBarSkin.getSkinnable()).isUseSystemMenuBar()) {
                                ((MenuBar)menuBarSkin.getSkinnable()).setUseSystemMenuBar(false);
                            }
                        }
                        if (scene2 != null && ((MenuBar)this.getSkinnable()).isUseSystemMenuBar() && !this.menusContainCustomMenuItem() && scene2.getWindow() instanceof Stage) {
                            stage = (Stage)scene2.getWindow();
                            if (systemMenuMap == null) {
                                MenuBarSkin.initSystemMenuBar();
                            }
                            this.wrappedMenus = new ArrayList<MenuBase>();
                            systemMenuMap.put(stage, new WeakReference<MenuBarSkin>(this));
                            for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
                                this.wrappedMenus.add(GlobalMenuAdapter.adapt(menu));
                            }
                            currentMenuBarStage = null;
                            MenuBarSkin.setSystemMenu(stage);
                            ((MenuBar)this.getSkinnable()).requestLayout();
                            Platform.runLater(() -> ((MenuBar)this.getSkinnable()).requestLayout());
                        }
                    };
                    ((MenuBar)this.getSkinnable()).sceneProperty().addListener(this.sceneChangeListener);
                }
                this.sceneChangeListener.changed((ObservableValue)((MenuBar)this.getSkinnable()).sceneProperty(), (Object)scene3, (Object)scene3);
                if (currentMenuBarStage != null ? MenuBarSkin.getMenuBarSkin(currentMenuBarStage) == this : ((MenuBar)this.getSkinnable()).isUseSystemMenuBar()) {
                    return;
                }
            } else if (currentMenuBarStage != null && (object = MenuBarSkin.getMenuBarSkin(currentMenuBarStage)) == this) {
                MenuBarSkin.setSystemMenu(null);
            }
        }
        ((MenuBar)this.getSkinnable()).focusedProperty().addListener(this.weakMenuBarFocusedPropertyListener);
        for (Object object : ((MenuBar)this.getSkinnable()).getMenus()) {
            ((MenuItem)object).visibleProperty().addListener(this.weakMenuVisibilityChangeListener);
            if (!((MenuItem)object).isVisible()) continue;
            MenuBarButton menuBarButton = new MenuBarButton(this, (Menu)object);
            menuBarButton.setFocusTraversable(false);
            menuBarButton.getStyleClass().add((Object)"menu");
            menuBarButton.setStyle(((MenuItem)object).getStyle());
            menuBarButton.getItems().setAll(((Menu)object).getItems());
            this.container.getChildren().add((Object)menuBarButton);
            menuBarButton.menuListener = (arg_0, arg_1, arg_2) -> this.lambda$rebuildUI$2((Menu)object, menuBarButton, arg_0, arg_1, arg_2);
            menuBarButton.menu = object;
            ((Menu)object).showingProperty().addListener(menuBarButton.menuListener);
            menuBarButton.disableProperty().bindBidirectional((Property)((MenuItem)object).disableProperty());
            menuBarButton.textProperty().bind((ObservableValue)((MenuItem)object).textProperty());
            menuBarButton.graphicProperty().bind(((MenuItem)object).graphicProperty());
            menuBarButton.styleProperty().bind((ObservableValue)((MenuItem)object).styleProperty());
            menuBarButton.getProperties().addListener(arg_0 -> MenuBarSkin.lambda$rebuildUI$3(menuBarButton, (Menu)object, arg_0));
            menuBarButton.showingProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$rebuildUI$4(menuBarButton, (Menu)object, arg_0, arg_1, arg_2));
            menuBarButton.setOnMousePressed(arg_0 -> this.lambda$rebuildUI$5(menuBarButton, (Menu)object, arg_0));
            menuBarButton.setOnMouseReleased(mouseEvent -> {
                if (menuBarButton.getScene().getWindow().isFocused() && this.pendingDismiss) {
                    this.resetOpenMenu();
                }
                this.pendingDismiss = false;
            });
            menuBarButton.setOnMouseEntered(arg_0 -> this.lambda$rebuildUI$7(menuBarButton, (Menu)object, arg_0));
            this.updateActionListeners((MenuItem)object, true);
        }
        ((MenuBar)this.getSkinnable()).requestLayout();
    }

    private void cleanUpSystemMenu() {
        if (this.sceneChangeListener != null && this.getSkinnable() != null) {
            ((MenuBar)this.getSkinnable()).sceneProperty().removeListener(this.sceneChangeListener);
            this.sceneChangeListener = null;
        }
        if (currentMenuBarStage != null && MenuBarSkin.getMenuBarSkin(currentMenuBarStage) == this) {
            MenuBarSkin.setSystemMenu(null);
        }
        if (systemMenuMap != null) {
            Iterator<Map.Entry<Stage, Reference<MenuBarSkin>>> iterator = systemMenuMap.entrySet().iterator();
            while (iterator.hasNext()) {
                MenuBarSkin menuBarSkin;
                Map.Entry<Stage, Reference<MenuBarSkin>> entry = iterator.next();
                Reference<MenuBarSkin> reference = entry.getValue();
                MenuBarSkin menuBarSkin2 = menuBarSkin = reference != null ? reference.get() : null;
                if (menuBarSkin != null && menuBarSkin != this) continue;
                iterator.remove();
            }
        }
    }

    private boolean isMenuEmpty(Menu menu) {
        boolean bl = true;
        if (menu != null) {
            for (MenuItem menuItem : menu.getItems()) {
                if (menuItem == null || !menuItem.isVisible()) continue;
                bl = false;
            }
        }
        return bl;
    }

    private void resetOpenMenu() {
        if (this.openMenu != null) {
            this.openMenu.hide();
            this.openMenu = null;
        }
    }

    private void unSelectMenus() {
        this.clearMenuButtonHover();
        if (this.focusedMenuIndex == -1) {
            return;
        }
        if (this.openMenu != null) {
            this.openMenu.hide();
            this.openMenu = null;
        }
        if (this.openMenuButton != null) {
            this.openMenuButton.clearHover();
            this.openMenuButton = null;
        }
        this.menuModeEnd();
    }

    private void menuModeStart(int n) {
        if (this.focusedMenuIndex == -1) {
            SceneHelper.getSceneAccessor().setTransientFocusContainer(((MenuBar)this.getSkinnable()).getScene(), (Node)this.getSkinnable());
        }
        this.setFocusedMenuIndex(n);
    }

    private void menuModeEnd() {
        if (this.focusedMenuIndex != -1) {
            SceneHelper.getSceneAccessor().setTransientFocusContainer(((MenuBar)this.getSkinnable()).getScene(), null);
            ((MenuBar)this.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_NODE);
        }
        this.setFocusedMenuIndex(-1);
    }

    private void moveToMenu(Direction direction, boolean bl) {
        Menu menu = this.menuBarButtonAt((int)this.focusedMenuIndex).menu;
        boolean bl2 = bl && menu.isShowing();
        this.findSibling(direction, this.focusedMenuIndex).ifPresent(pair -> {
            this.setFocusedMenuIndex((Integer)pair.getValue());
            if (bl2) {
                this.showMenu((Menu)pair.getKey(), false);
            }
        });
    }

    private Optional<Pair<Menu, Integer>> findSibling(Direction direction, int n) {
        if (n == -1) {
            return Optional.empty();
        }
        List list = ((MenuBar)this.getSkinnable()).getMenus().stream().filter(MenuItem::isVisible).collect(Collectors.toList());
        int n2 = list.size();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            ++n3;
            n4 = (n + (direction.isForward() ? 1 : -1)) % n2;
            if (n4 == -1) {
                n4 = n2 - 1;
            }
            if (!((Menu)list.get(n4)).isDisable()) break;
            n = n4;
        }
        this.clearMenuButtonHover();
        return Optional.of(new Pair((Object)((Menu)list.get(n4)), (Object)n4));
    }

    private void updateFocusedIndex() {
        int n = 0;
        for (Node node : this.container.getChildren()) {
            if (node.isHover()) {
                this.setFocusedMenuIndex(n);
                return;
            }
            ++n;
        }
        this.menuModeEnd();
    }

    private void clearMenuButtonHover() {
        for (Node node : this.container.getChildren()) {
            if (!node.isHover()) continue;
            ((MenuBarButton)node).clearHover();
            ((MenuBarButton)node).disarm();
            return;
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return MenuBarSkin.getClassCssMetaData();
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case FOCUS_NODE: {
                return this.openMenuButton;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    private /* synthetic */ void lambda$rebuildUI$7(MenuBarButton menuBarButton, Menu menu, MouseEvent mouseEvent) {
        if (menuBarButton.getScene() != null && menuBarButton.getScene().getWindow() != null && menuBarButton.getScene().getWindow().isFocused()) {
            if (this.openMenuButton != null && this.openMenuButton != menuBarButton) {
                this.openMenuButton.clearHover();
                this.openMenuButton = null;
                this.openMenuButton = menuBarButton;
            }
            this.updateFocusedIndex();
            if (this.openMenu != null && this.openMenu != menu) {
                this.showMenu(menu);
            }
        }
    }

    private /* synthetic */ void lambda$rebuildUI$5(MenuBarButton menuBarButton, Menu menu, MouseEvent mouseEvent) {
        this.pendingDismiss = menuBarButton.isShowing();
        if (menuBarButton.getScene().getWindow().isFocused()) {
            this.showMenu(menu);
            this.menuModeStart(this.getMenuBarButtonIndex(menuBarButton));
        }
    }

    private /* synthetic */ void lambda$rebuildUI$4(MenuBarButton menuBarButton, Menu menu, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        if (bl2.booleanValue()) {
            if (this.openMenuButton == null && this.focusedMenuIndex != -1) {
                this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            }
            if (this.openMenuButton != null && this.openMenuButton != menuBarButton) {
                this.openMenuButton.clearHover();
            }
            this.openMenuButton = menuBarButton;
            this.showMenu(menu);
        } else {
            this.openMenu = null;
            this.openMenuButton = null;
        }
    }

    private static /* synthetic */ void lambda$rebuildUI$3(MenuBarButton menuBarButton, Menu menu, MapChangeListener.Change change) {
        if (change.wasAdded() && "autoHide".equals(change.getKey())) {
            menuBarButton.getProperties().remove((Object)"autoHide");
            menu.hide();
        }
    }

    private /* synthetic */ void lambda$rebuildUI$2(Menu menu, MenuBarButton menuBarButton, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        if (menu.isShowing()) {
            menuBarButton.show();
            this.menuModeStart(this.container.getChildren().indexOf((Object)menuBarButton));
        } else {
            menuBarButton.hide();
        }
    }

    static {
        wrappedDefaultMenus = new ArrayList<MenuBase>();
        SPACING = new CssMetaData<MenuBar, Number>("-fx-spacing", SizeConverter.getInstance(), (Number)0.0){

            public boolean isSettable(MenuBar menuBar) {
                MenuBarSkin menuBarSkin = (MenuBarSkin)menuBar.getSkin();
                return menuBarSkin.spacing == null || !menuBarSkin.spacing.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(MenuBar menuBar) {
                MenuBarSkin menuBarSkin = (MenuBarSkin)menuBar.getSkin();
                return (StyleableProperty)menuBarSkin.spacingProperty();
            }
        };
        ALIGNMENT = new CssMetaData<MenuBar, Pos>("-fx-alignment", (StyleConverter)new EnumConverter(Pos.class), Pos.TOP_LEFT){

            public boolean isSettable(MenuBar menuBar) {
                MenuBarSkin menuBarSkin = (MenuBarSkin)menuBar.getSkin();
                return menuBarSkin.containerAlignment == null || !menuBarSkin.containerAlignment.isBound();
            }

            public StyleableProperty<Pos> getStyleableProperty(MenuBar menuBar) {
                MenuBarSkin menuBarSkin = (MenuBarSkin)menuBar.getSkin();
                return (StyleableProperty)menuBarSkin.containerAlignmentProperty();
            }
        };
        ArrayList arrayList = new ArrayList(SkinBase.getClassCssMetaData());
        String string = ALIGNMENT.getProperty();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            CssMetaData cssMetaData = (CssMetaData)arrayList.get(i);
            if (!string.equals(cssMetaData.getProperty())) continue;
            arrayList.remove(cssMetaData);
        }
        arrayList.add(SPACING);
        arrayList.add(ALIGNMENT);
        STYLEABLES = Collections.unmodifiableList(arrayList);
    }
}

