/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import com.mckoi.util.GeneralFormatter;
import com.mckoi.util.GeneralParser;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.Date;

public class TimeFrame {
    private static final BigDecimal BD_ZERO = new BigDecimal(0);
    public static int WEEKS = 1;
    public static int DAYS = 2;
    public static int HOURS = 3;
    public static int MINUTES = 4;
    private BigDecimal period;

    public TimeFrame(BigDecimal period) {
        this.period = period;
    }

    public BigDecimal getPeriod() {
        return this.period;
    }

    public boolean isNoTime() {
        return this.period.equals(BD_ZERO);
    }

    public Date addToDate(Date date) {
        return new Date(date.getTime() + this.period.longValue());
    }

    public String format(int format_type) {
        return this.format(format_type, true);
    }

    public String format(int format_type, boolean shorthand) {
        if (this.period == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        double val = this.period.longValue();
        if (format_type == WEEKS) {
            GeneralFormatter.appendWeekType(str, val, shorthand);
        } else if (format_type == DAYS) {
            GeneralFormatter.appendDayType(str, val, shorthand);
        } else if (format_type == HOURS) {
            GeneralFormatter.appendHourType(str, val, shorthand);
        } else if (format_type == MINUTES) {
            GeneralFormatter.appendMinuteType(str, val, shorthand);
        }
        return str.toString();
    }

    public static TimeFrame parse(String str) throws ParseException {
        if (str == null || str.equals("")) {
            return null;
        }
        BigDecimal period = GeneralParser.parseTimeMeasure(new StringCharacterIterator(str));
        return new TimeFrame(period);
    }

    public boolean equals(Object ob) {
        TimeFrame tf = (TimeFrame)ob;
        if (tf == null) {
            return false;
        }
        return this == tf || this.period.equals(tf.period);
    }

    public String toString() {
        return this.format(WEEKS);
    }
}

