/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class ResultOutputUtil {
    private static void writeBreak(int[] widths, PrintWriter out) {
        out.print('+');
        for (int i = 0; i < widths.length; ++i) {
            int wid = widths[i] + 2;
            for (int n = 0; n < wid; ++n) {
                out.print('-');
            }
            out.print('+');
        }
        out.println();
    }

    private static void writeRow(int[] widths, String[] cols, PrintWriter out) {
        out.print('|');
        for (int i = 0; i < widths.length; ++i) {
            String str = cols[i];
            out.print(' ');
            out.print(str);
            int wid = widths[i] + 1 - str.length();
            for (int n = 0; n < wid; ++n) {
                out.print(' ');
            }
            out.print('|');
        }
        out.println();
    }

    public static void formatAsText(ResultSet result_set, PrintWriter out) throws SQLException {
        int i;
        ResultSetMetaData meta_data = result_set.getMetaData();
        int[] max_widths = new int[meta_data.getColumnCount()];
        Vector[] data = new Vector[meta_data.getColumnCount()];
        for (int i2 = 0; i2 < data.length; ++i2) {
            data[i2] = new Vector();
        }
        int row_count = 0;
        for (i = 0; i < data.length; ++i) {
            String str = meta_data.getColumnLabel(i + 1);
            max_widths[i] = Math.max(str.length(), max_widths[i]);
        }
        while (result_set.next()) {
            for (i = 0; i < data.length; ++i) {
                Object ob = result_set.getObject(i + 1);
                String str = "NULL";
                if (ob != null) {
                    str = ob.toString();
                }
                data[i].addElement(str);
                max_widths[i] = Math.max(str.length(), max_widths[i]);
            }
            ++row_count;
        }
        String[] line = new String[data.length];
        ResultOutputUtil.writeBreak(max_widths, out);
        for (int n = 0; n < line.length; ++n) {
            line[n] = meta_data.getColumnLabel(n + 1);
        }
        ResultOutputUtil.writeRow(max_widths, line, out);
        ResultOutputUtil.writeBreak(max_widths, out);
        for (int i3 = 0; i3 < row_count; ++i3) {
            for (int n = 0; n < line.length; ++n) {
                line[n] = (String)data[n].elementAt(i3);
            }
            ResultOutputUtil.writeRow(max_widths, line, out);
        }
        ResultOutputUtil.writeBreak(max_widths, out);
    }
}

