/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class LogWriter
extends Writer {
    private final File log_file;
    private final long max_size;
    private final int archive_count;
    private long log_file_size;
    private Writer out;

    public LogWriter(File base_name, long max_size, int archive_count) throws IOException {
        if (archive_count < 1) {
            throw new Error("'archive_count' must be 1 or greater.");
        }
        this.log_file = base_name;
        this.max_size = max_size;
        this.archive_count = archive_count;
        this.log_file_size = base_name.exists() ? base_name.length() : 0L;
        this.out = new BufferedWriter(new FileWriter(base_name.getPath(), true));
    }

    private void checkLogSize() throws IOException {
        if (this.log_file_size > this.max_size) {
            this.out.flush();
            this.out.close();
            this.out = null;
            File top = new File(this.log_file.getPath() + "." + this.archive_count);
            top.delete();
            for (int i = this.archive_count - 1; i > 0; --i) {
                File source = new File(this.log_file.getPath() + "." + i);
                File dest = new File(this.log_file.getPath() + "." + (i + 1));
                source.renameTo(dest);
            }
            this.log_file.renameTo(new File(this.log_file.getPath() + ".1"));
            this.out = new BufferedWriter(new FileWriter(this.log_file.getPath(), true));
            this.log_file_size = 0L;
        }
    }

    public synchronized void write(int c) throws IOException {
        this.out.write(c);
        ++this.log_file_size;
    }

    public synchronized void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
        this.log_file_size += (long)len;
    }

    public synchronized void write(String str, int off, int len) throws IOException {
        this.out.write(str, off, len);
        this.log_file_size += (long)len;
    }

    public synchronized void flush() throws IOException {
        this.out.flush();
        this.checkLogSize();
    }

    public synchronized void close() throws IOException {
        this.out.flush();
        this.out.close();
    }
}

