/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import com.mckoi.util.LogWriter;
import com.mckoi.util.NullLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class Log {
    private final LogWriter log_output;
    private final DateFormat date_format = DateFormat.getDateTimeInstance();

    public Log(String path) throws FileNotFoundException, IOException {
        this(new File(path));
    }

    public Log(File file, int size, int max_count) throws IOException {
        this.log_output = new LogWriter(file, size, max_count);
    }

    public Log(File file) throws FileNotFoundException, IOException {
        this(file, 524288, 12);
    }

    protected Log() {
        this.log_output = null;
    }

    public synchronized void log(String text) {
        try {
            this.log_output.write("[");
            this.log_output.write(this.date_format.format(new Date()));
            this.log_output.write("] ");
            this.log_output.write(text);
            this.log_output.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void logln(String text) {
        try {
            this.log_output.write(text);
            this.log_output.write(10);
            this.log_output.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void close() {
        try {
            this.log_output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Log nullLog() {
        return new NullLog();
    }
}

