/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import java.math.BigDecimal;

public class GeneralFormatter {
    public static final int MAX_WEEKS = 0;
    public static final int MAX_DAYS = 1;
    public static final int MAX_HOURS = 2;
    public static final int MAX_MINUTES = 3;
    public static final int MAX_SECONDS = 4;
    public static final int MAX_MILLISECONDS = 5;
    private static final long MILLIS_IN_WEEK = 604800000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_SECOND = 1000L;

    private static void appendFrame(StringBuffer str, double num, String frame, boolean do_round, boolean append_plural_s) {
        if (do_round) {
            num = (long)num;
        }
        if (num != 0.0) {
            str.append(new BigDecimal(num));
            str.append(' ');
            str.append(frame);
            if (num != 1.0 && append_plural_s) {
                str.append('s');
            }
            str.append(' ');
        }
    }

    public static void appendWeekType(StringBuffer str, double total, boolean shorthand) {
        double num = total / 6.048E8;
        GeneralFormatter.appendFrame(str, num, "week", true, true);
        num = total % 6.048E8 / 8.64E7;
        GeneralFormatter.appendFrame(str, num, "day", true, true);
        num = total % 8.64E7 / 3600000.0;
        GeneralFormatter.appendFrame(str, num, "hr", true, true);
        num = total % 3600000.0 / 60000.0;
        GeneralFormatter.appendFrame(str, num, "min", true, true);
        num = total % 60000.0 / 1000.0;
        GeneralFormatter.appendFrame(str, num, "sec", true, false);
        num = total % 1000.0;
        GeneralFormatter.appendFrame(str, num, "ms", true, false);
    }

    public static void appendDayType(StringBuffer str, double total, boolean shorthand) {
        double num = total / 8.64E7;
        GeneralFormatter.appendFrame(str, num, "day", true, true);
        num = total % 8.64E7 / 3600000.0;
        GeneralFormatter.appendFrame(str, num, "hr", true, true);
        num = total % 3600000.0 / 60000.0;
        GeneralFormatter.appendFrame(str, num, "min", true, true);
        num = total % 60000.0 / 1000.0;
        GeneralFormatter.appendFrame(str, num, "sec", true, false);
        num = total % 1000.0;
        GeneralFormatter.appendFrame(str, num, "ms", true, false);
    }

    public static void appendHourType(StringBuffer str, double total, boolean shorthand) {
        double num = total / 3600000.0;
        GeneralFormatter.appendFrame(str, num, "hr", true, true);
        num = total % 3600000.0 / 60000.0;
        GeneralFormatter.appendFrame(str, num, "min", true, true);
        num = total % 60000.0 / 1000.0;
        GeneralFormatter.appendFrame(str, num, "sec", true, false);
        num = total % 1000.0;
        GeneralFormatter.appendFrame(str, num, "ms", true, false);
    }

    public static void appendMinuteType(StringBuffer str, double total, boolean shorthand) {
        double num = total / 60000.0;
        GeneralFormatter.appendFrame(str, num, "min", true, true);
        num = total % 60000.0 / 1000.0;
        GeneralFormatter.appendFrame(str, num, "sec", true, false);
        num = total % 1000.0;
        GeneralFormatter.appendFrame(str, num, "ms", true, false);
    }
}

