/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import java.util.StringTokenizer;
import java.util.Vector;

public class CommandLine {
    private String[] args;

    public CommandLine(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        this.args = args;
    }

    public boolean containsSwitch(String switch_str) {
        for (int i = 0; i < this.args.length; ++i) {
            if (!this.args[i].equals(switch_str)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSwitchFrom(String switch_str) {
        StringTokenizer tok = new StringTokenizer(switch_str, ",");
        while (tok.hasMoreElements()) {
            String elem = tok.nextElement().toString();
            if (!this.containsSwitch(elem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSwitchStart(String switch_str) {
        for (int i = 0; i < this.args.length; ++i) {
            if (!this.args[i].startsWith(switch_str)) continue;
            return true;
        }
        return false;
    }

    public String[] allSwitchesStartingWith(String switch_str) {
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < this.args.length; ++i) {
            if (!this.args[i].startsWith(switch_str)) continue;
            list.addElement(this.args[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    public String switchArgument(String switch_str) {
        for (int i = 0; i < this.args.length - 1; ++i) {
            if (!this.args[i].equals(switch_str)) continue;
            return this.args[i + 1];
        }
        return null;
    }

    public String switchArgument(String switch_str, String def) {
        String arg = this.switchArgument(switch_str);
        if (arg == null) {
            return def;
        }
        return arg;
    }

    public String[] switchArguments(String switch_str, int arg_count) {
        for (int i = 0; i < this.args.length - 1; ++i) {
            if (!this.args[i].equals(switch_str) || i + arg_count >= this.args.length) continue;
            String[] ret_list = new String[arg_count];
            for (int n = 0; n < arg_count; ++n) {
                ret_list[n] = this.args[i + n + 1];
            }
            return ret_list;
        }
        return null;
    }
}

