/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

public class Cache {
    private int max_cache_size;
    private int current_cache_size;
    private int wipe_to;
    private final ListNode[] node_hash;
    private ListNode list_start;
    private ListNode list_end;
    private long total_gets = 0L;
    private long get_total = 0L;

    public Cache(int hash_size, int max_size, int clean_percentage) {
        if (clean_percentage >= 85) {
            throw new RuntimeException("Can't set to wipe more than 85% of the cache during clean.");
        }
        this.max_cache_size = max_size;
        this.current_cache_size = 0;
        this.wipe_to = max_size - clean_percentage * max_size / 100;
        this.node_hash = new ListNode[hash_size];
        this.list_start = null;
        this.list_end = null;
    }

    public Cache(int max_size, int clean_percentage) {
        this(max_size * 2 + 1, max_size, 20);
    }

    public Cache(int max_size) {
        this(max_size, 20);
    }

    public Cache() {
        this(50);
    }

    protected final int getHashSize() {
        return this.max_cache_size * 2 + 1;
    }

    protected void checkClean() {
        if (this.current_cache_size >= this.max_cache_size) {
            this.clean();
        }
    }

    protected boolean shouldWipeMoreNodes() {
        return this.current_cache_size >= this.wipe_to;
    }

    protected void notifyWipingNode(Object ob) {
    }

    protected void notifyGetWalks(long total_walks, long total_get_ops) {
    }

    private ListNode getFromHash(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.node_hash.length;
        int get_count = 1;
        ListNode e = this.node_hash[index];
        while (e != null) {
            if (key.equals(e.key)) {
                ++this.total_gets;
                this.get_total += (long)get_count;
                if ((this.total_gets & 0x1FFFL) == 0L) {
                    try {
                        this.notifyGetWalks(this.get_total, this.total_gets);
                        if (this.get_total > 0L) {
                            this.get_total = 0L;
                            this.total_gets = 0L;
                        }
                    }
                    catch (Throwable except) {
                        // empty catch block
                    }
                }
                if (get_count > 1) {
                    this.bringToHead(e);
                }
                return e;
            }
            ++get_count;
            e = e.next_hash_entry;
        }
        return null;
    }

    private ListNode putIntoHash(ListNode node) {
        int hash = node.key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.node_hash.length;
        Object key = node.key;
        ListNode e = this.node_hash[index];
        while (e != null) {
            if (key.equals(e.key)) {
                throw new Error("ListNode with same key already in the hash - remove first.");
            }
            e = e.next_hash_entry;
        }
        node.next_hash_entry = this.node_hash[index];
        this.node_hash[index] = node;
        return node;
    }

    private ListNode removeFromHash(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.node_hash.length;
        ListNode prev = null;
        ListNode e = this.node_hash[index];
        while (e != null) {
            if (key.equals(e.key)) {
                if (prev == null) {
                    this.node_hash[index] = e.next_hash_entry;
                } else {
                    prev.next_hash_entry = e.next_hash_entry;
                }
                return e;
            }
            prev = e;
            e = e.next_hash_entry;
        }
        return null;
    }

    private void clearHash() {
        for (int i = this.node_hash.length - 1; i >= 0; --i) {
            this.node_hash[i] = null;
        }
    }

    public final int nodeCount() {
        return this.current_cache_size;
    }

    public final void put(Object key, Object ob) {
        this.checkClean();
        ListNode node = this.getFromHash(key);
        if (node == null) {
            node = this.createListNode();
            node.key = key;
            node.contents = ob;
            node.next = this.list_start;
            node.previous = null;
            this.list_start = node;
            if (node.next == null) {
                this.list_end = node;
            } else {
                node.next.previous = node;
            }
            ++this.current_cache_size;
            this.putIntoHash(node);
        } else {
            node.contents = ob;
            this.bringToHead(node);
        }
    }

    public final Object get(Object key) {
        ListNode node = this.getFromHash(key);
        if (node != null) {
            return node.contents;
        }
        return null;
    }

    public final Object remove(Object key) {
        ListNode node = this.removeFromHash(key);
        if (node != null) {
            if (this.list_start == node) {
                this.list_start = node.next;
                if (this.list_start != null) {
                    this.list_start.previous = null;
                } else {
                    this.list_end = null;
                }
            } else if (this.list_end == node) {
                this.list_end = node.previous;
                if (this.list_end != null) {
                    this.list_end.next = null;
                } else {
                    this.list_start = null;
                }
            } else {
                node.previous.next = node.next;
                node.next.previous = node.previous;
            }
            --this.current_cache_size;
            Object contents = node.contents;
            node.contents = null;
            node.key = null;
            return contents;
        }
        return null;
    }

    public void removeAll() {
        if (this.current_cache_size != 0) {
            this.current_cache_size = 0;
            this.clearHash();
        }
        this.list_start = null;
        this.list_end = null;
    }

    public void clear() {
        this.removeAll();
    }

    private final ListNode createListNode() {
        return new ListNode();
    }

    protected final int clean() {
        ListNode node = this.list_end;
        if (node == null) {
            return 0;
        }
        int actual_count = 0;
        while (node != null && this.shouldWipeMoreNodes()) {
            this.notifyWipingNode(node.contents);
            this.removeFromHash(node.key);
            node.contents = null;
            node.key = null;
            ListNode old_node = node;
            node = node.previous;
            old_node.next = null;
            old_node.previous = null;
            --this.current_cache_size;
            ++actual_count;
        }
        if (node != null) {
            node.next = null;
            this.list_end = node;
        } else {
            this.list_start = null;
            this.list_end = null;
        }
        return actual_count;
    }

    private final void bringToHead(ListNode node) {
        if (this.list_start != node) {
            ListNode next_node = node.next;
            ListNode previous_node = node.previous;
            node.next = this.list_start;
            node.previous = null;
            this.list_start = node;
            node.next.previous = node;
            if (next_node != null) {
                next_node.previous = previous_node;
            } else {
                this.list_end = previous_node;
            }
            previous_node.next = next_node;
        }
    }

    static final class ListNode {
        ListNode next;
        ListNode previous;
        ListNode next_hash_entry;
        Object key;
        Object contents;

        ListNode() {
        }
    }
}

