/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import com.mckoi.util.IndexComparator;
import com.mckoi.util.IntegerIterator;
import com.mckoi.util.IntegerListBlockInterface;
import com.mckoi.util.IntegerListInterface;
import com.mckoi.util.IntegerVector;
import java.util.ArrayList;

public abstract class AbstractBlockIntegerList
implements IntegerListInterface {
    protected ArrayList block_list = new ArrayList(10);
    private int count = 0;
    private boolean immutable = false;

    public AbstractBlockIntegerList() {
    }

    public AbstractBlockIntegerList(IntegerListBlockInterface[] blocks) {
        this();
        for (int i = 0; i < blocks.length; ++i) {
            this.block_list.add(blocks[i]);
            this.count += blocks[i].size();
        }
    }

    public AbstractBlockIntegerList(IntegerVector ivec) {
        this();
        int sz = ivec.size();
        for (int i = 0; i < sz; ++i) {
            this.add(ivec.intAt(i));
        }
    }

    public AbstractBlockIntegerList(IntegerListInterface i_list) {
        this();
        if (i_list instanceof AbstractBlockIntegerList) {
            AbstractBlockIntegerList in_list = (AbstractBlockIntegerList)i_list;
            ArrayList in_blocks = in_list.block_list;
            int in_blocks_count = in_blocks.size();
            for (int i = 0; i < in_blocks_count; ++i) {
                IntegerListBlockInterface block = (IntegerListBlockInterface)in_blocks.get(i);
                IntegerListBlockInterface dest_block = this.insertListBlock(i, this.newListBlock());
                block.copyTo(dest_block);
            }
            this.count = i_list.size();
        } else {
            IntegerIterator i = i_list.iterator();
            while (i.hasNext()) {
                this.add(i.next());
            }
        }
        if (i_list.isImmutable()) {
            this.setImmutable();
        }
    }

    protected abstract IntegerListBlockInterface newListBlock();

    protected void deleteListBlock(IntegerListBlockInterface list_block) {
    }

    final void copyToArray(int[] array, int offset, int length) {
        if (array.length >= length && offset + length <= this.size()) {
            for (int i = 0; i < this.block_list.size(); ++i) {
                IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(i);
                offset += block.copyTo(array, offset);
            }
            return;
        }
        throw new Error("Size mismatch.");
    }

    private final IntegerListBlockInterface insertListBlock(int index, IntegerListBlockInterface list_block) {
        this.block_list.add(index, list_block);
        if (index + 1 < this.block_list.size()) {
            IntegerListBlockInterface next_b;
            list_block.next = next_b = (IntegerListBlockInterface)this.block_list.get(index + 1);
            next_b.previous = list_block;
        } else {
            list_block.next = null;
        }
        if (index > 0) {
            IntegerListBlockInterface previous_b;
            list_block.previous = previous_b = (IntegerListBlockInterface)this.block_list.get(index - 1);
            previous_b.next = list_block;
        } else {
            list_block.previous = null;
        }
        return list_block;
    }

    private final void removeListBlock(int index) {
        IntegerListBlockInterface new_prev = null;
        IntegerListBlockInterface new_next = null;
        if (index + 1 < this.block_list.size()) {
            new_next = (IntegerListBlockInterface)this.block_list.get(index + 1);
        }
        if (index > 0) {
            new_prev = (IntegerListBlockInterface)this.block_list.get(index - 1);
        }
        if (new_prev != null) {
            new_prev.next = new_next;
        }
        if (new_next != null) {
            new_next.previous = new_prev;
        }
        IntegerListBlockInterface been_removed = (IntegerListBlockInterface)this.block_list.remove(index);
        this.deleteListBlock(been_removed);
    }

    private final void insertIntoBlock(int val, int block_index, IntegerListBlockInterface block, int position) {
        block.insertIntAt(val, position);
        ++this.count;
        if (block.isFull()) {
            IntegerListBlockInterface next_b;
            int move_size = block.size() / 7 - 1;
            IntegerListBlockInterface move_to = block_index < this.block_list.size() - 1 ? ((next_b = (IntegerListBlockInterface)this.block_list.get(block_index + 1)).canContain(move_size) ? next_b : this.insertListBlock(block_index + 1, this.newListBlock())) : this.insertListBlock(block_index + 1, this.newListBlock());
            block.moveTo(move_to, 0, move_size);
        }
    }

    protected final int removeFromBlock(int block_index, IntegerListBlockInterface block, int position) {
        int old_value = block.removeIntAt(position);
        --this.count;
        if (block.isEmpty() && this.block_list.size() > 1) {
            this.removeListBlock(block_index);
        }
        return old_value;
    }

    private final int findBlockContaining(Object key, IndexComparator c) {
        if (this.count == 0) {
            return -1;
        }
        int low = 0;
        int high = this.block_list.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(mid);
            if (c.compare(block.bottomInt(), key) > 0) {
                high = mid - 1;
                continue;
            }
            if (c.compare(block.topInt(), key) < 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private final int findLastBlock(Object key, IndexComparator c) {
        if (this.count == 0) {
            return -1;
        }
        int low = 0;
        int high = this.block_list.size() - 1;
        while (low <= high) {
            IntegerListBlockInterface block;
            if (high - low <= 2) {
                for (int i = high; i >= low; --i) {
                    block = (IntegerListBlockInterface)this.block_list.get(i);
                    if (c.compare(block.bottomInt(), key) > 0) continue;
                    if (c.compare(block.topInt(), key) >= 0) {
                        return i;
                    }
                    return -(i + 1) - 1;
                }
                return -(low + 1);
            }
            int mid = (low + high) / 2;
            block = (IntegerListBlockInterface)this.block_list.get(mid);
            if (c.compare(block.bottomInt(), key) > 0) {
                high = mid - 1;
                continue;
            }
            if (c.compare(block.topInt(), key) < 0) {
                low = mid + 1;
                continue;
            }
            low = mid;
            if (low != high) continue;
            return low;
        }
        return -(low + 1);
    }

    private final int findFirstBlock(Object key, IndexComparator c) {
        if (this.count == 0) {
            return -1;
        }
        int low = 0;
        int high = this.block_list.size() - 1;
        while (low <= high) {
            IntegerListBlockInterface block;
            if (high - low <= 2) {
                for (int i = low; i <= high; ++i) {
                    block = (IntegerListBlockInterface)this.block_list.get(i);
                    if (c.compare(block.topInt(), key) < 0) continue;
                    if (c.compare(block.bottomInt(), key) <= 0) {
                        return i;
                    }
                    return -(i + 1);
                }
                return -(high + 1) - 1;
            }
            int mid = (low + high) / 2;
            block = (IntegerListBlockInterface)this.block_list.get(mid);
            if (c.compare(block.bottomInt(), key) > 0) {
                high = mid - 1;
                continue;
            }
            if (c.compare(block.topInt(), key) < 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return -(low + 1);
    }

    private final int findFirstBlock(int val) {
        if (this.count == 0) {
            return -1;
        }
        int low = 0;
        int high = this.block_list.size() - 1;
        while (low <= high) {
            IntegerListBlockInterface block;
            if (high - low <= 2) {
                for (int i = low; i <= high; ++i) {
                    block = (IntegerListBlockInterface)this.block_list.get(i);
                    if (block.topInt() < val) continue;
                    if (block.bottomInt() <= val) {
                        return i;
                    }
                    return -(i + 1);
                }
                return -(high + 1) - 1;
            }
            int mid = (low + high) / 2;
            block = (IntegerListBlockInterface)this.block_list.get(mid);
            if (block.bottomInt() > val) {
                high = mid - 1;
                continue;
            }
            if (block.topInt() < val) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return -(low + 1);
    }

    private final int findLastBlock(int val) {
        if (this.count == 0) {
            return -1;
        }
        int low = 0;
        int high = this.block_list.size() - 1;
        while (low <= high) {
            IntegerListBlockInterface block;
            if (high - low <= 2) {
                for (int i = high; i >= low; --i) {
                    block = (IntegerListBlockInterface)this.block_list.get(i);
                    if (block.bottomInt() > val) continue;
                    if (block.topInt() >= val) {
                        return i;
                    }
                    return -(i + 1) - 1;
                }
                return -(low + 1);
            }
            int mid = (low + high) / 2;
            block = (IntegerListBlockInterface)this.block_list.get(mid);
            if (block.bottomInt() > val) {
                high = mid - 1;
                continue;
            }
            if (block.topInt() < val) {
                low = mid + 1;
                continue;
            }
            low = mid;
            if (low != high) continue;
            return low;
        }
        return -(low + 1);
    }

    private void checkImmutable() {
        if (this.immutable) {
            throw new Error("List is immutable.");
        }
        if (this.block_list.size() == 0) {
            this.insertListBlock(0, this.newListBlock());
        }
    }

    public final void setImmutable() {
        this.immutable = true;
    }

    public final boolean isImmutable() {
        return this.immutable;
    }

    public final int size() {
        return this.count;
    }

    public final int get(int pos) {
        int size = this.block_list.size();
        int start = 0;
        for (int i = 0; i < size; ++i) {
            IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(i);
            int bsize = block.size();
            if (pos >= start && pos < start + bsize) {
                return block.intAt(pos - start);
            }
            start += bsize;
        }
        throw new Error("'pos' (" + pos + ") out of bounds.");
    }

    public final void add(int val, int pos) {
        this.checkImmutable();
        int size = this.block_list.size();
        int start = 0;
        for (int i = 0; i < size; ++i) {
            Object ob = this.block_list.get(i);
            IntegerListBlockInterface block = (IntegerListBlockInterface)ob;
            int bsize = block.size();
            if (pos >= start && pos <= start + bsize) {
                this.insertIntoBlock(val, i, block, pos - start);
                return;
            }
            start += bsize;
        }
        throw new Error("'pos' (" + pos + ") out of bounds.");
    }

    public final void add(int val) {
        this.checkImmutable();
        int size = this.block_list.size();
        IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(size - 1);
        this.insertIntoBlock(val, size - 1, block, block.size());
    }

    public final int remove(int pos) {
        this.checkImmutable();
        int size = this.block_list.size();
        int start = 0;
        for (int i = 0; i < size; ++i) {
            IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(i);
            int bsize = block.size();
            if (pos >= start && pos <= start + bsize) {
                return this.removeFromBlock(i, block, pos - start);
            }
            start += bsize;
        }
        throw new Error("'pos' (" + pos + ") out of bounds.");
    }

    public final boolean contains(int val) {
        int block_num = this.findLastBlock(val);
        if (block_num < 0) {
            return false;
        }
        IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(block_num);
        int sr = block.searchLast(val);
        return sr >= 0;
    }

    public final void insertSort(int val) {
        IntegerListBlockInterface block;
        int i;
        this.checkImmutable();
        int block_num = this.findLastBlock(val);
        if (block_num < 0 && (block_num = -(block_num + 1) - 1) < 0) {
            block_num = 0;
        }
        i = (i = (block = (IntegerListBlockInterface)this.block_list.get(block_num)).searchLast(val)) < 0 ? -(i + 1) : ++i;
        this.insertIntoBlock(val, block_num, block, i);
    }

    public final boolean uniqueInsertSort(int val) {
        IntegerListBlockInterface block;
        int i;
        this.checkImmutable();
        int block_num = this.findLastBlock(val);
        if (block_num < 0 && (block_num = -(block_num + 1) - 1) < 0) {
            block_num = 0;
        }
        if ((i = (block = (IntegerListBlockInterface)this.block_list.get(block_num)).searchLast(val)) >= 0) {
            return false;
        }
        i = -(i + 1);
        this.insertIntoBlock(val, block_num, block, i);
        return true;
    }

    public final boolean removeSort(int val) {
        IntegerListBlockInterface block;
        int i;
        this.checkImmutable();
        int block_num = this.findLastBlock(val);
        if (block_num < 0 && (block_num = -(block_num + 1) - 1) < 0) {
            block_num = 0;
        }
        if ((i = (block = (IntegerListBlockInterface)this.block_list.get(block_num)).searchLast(val)) < 0) {
            return false;
        }
        int val_removed = this.removeFromBlock(block_num, block, i);
        if (val != val_removed) {
            throw new Error("Incorrect value removed.");
        }
        return true;
    }

    public final boolean contains(Object key, IndexComparator c) {
        int block_num = this.findBlockContaining(key, c);
        if (block_num < 0) {
            return false;
        }
        IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(block_num);
        int sr = block.binarySearch(key, c);
        return sr >= 0;
    }

    public final void insertSort(Object key, int val, IndexComparator c) {
        IntegerListBlockInterface block;
        int i;
        this.checkImmutable();
        int block_num = this.findLastBlock(key, c);
        if (block_num < 0 && (block_num = -(block_num + 1) - 1) < 0) {
            block_num = 0;
        }
        i = (i = (block = (IntegerListBlockInterface)this.block_list.get(block_num)).searchLast(key, c)) < 0 ? -(i + 1) : ++i;
        this.insertIntoBlock(val, block_num, block, i);
    }

    public final int removeSort(Object key, int val, IndexComparator c) {
        int orig_block_num;
        this.checkImmutable();
        int block_num = orig_block_num = this.findFirstBlock(key, c);
        int l_block_num = this.block_list.size() - 1;
        if (block_num < 0) {
            throw new Error("Value (" + key + ") was not found in the list.");
        }
        IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(block_num);
        int i = block.iterativeSearch(val);
        while (i == -1) {
            if (++block_num > l_block_num) {
                throw new Error("Value (" + key + ") was not found in the list.");
            }
            block = (IntegerListBlockInterface)this.block_list.get(block_num);
            i = block.iterativeSearch(val);
        }
        return this.removeFromBlock(block_num, block, i);
    }

    public final int searchLast(Object key, IndexComparator c) {
        int sr;
        int block_num = this.findLastBlock(key, c);
        if (block_num < 0) {
            block_num = -(block_num + 1);
            sr = -1;
        } else {
            IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(block_num);
            sr = block.searchLast(key, c);
        }
        int offset = 0;
        for (int i = 0; i < block_num; ++i) {
            IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(i);
            offset += block.size();
        }
        if (sr >= 0) {
            return offset + sr;
        }
        return -offset + sr;
    }

    public final int searchFirst(Object key, IndexComparator c) {
        int sr;
        int block_num = this.findFirstBlock(key, c);
        if (block_num < 0) {
            block_num = -(block_num + 1);
            sr = -1;
        } else {
            IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(block_num);
            sr = block.searchFirst(key, c);
        }
        int offset = 0;
        for (int i = 0; i < block_num; ++i) {
            IntegerListBlockInterface block = (IntegerListBlockInterface)this.block_list.get(i);
            offset += block.size();
        }
        if (sr >= 0) {
            return offset + sr;
        }
        return -offset + sr;
    }

    public IntegerIterator iterator(int start_offset, int end_offset) {
        return new BILIterator(start_offset, end_offset);
    }

    public IntegerIterator iterator() {
        return this.iterator(0, this.size() - 1);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Blocks: " + this.block_list.size() + "\n");
        for (int i = 0; i < this.block_list.size(); ++i) {
            buf.append("Block (" + i + "): " + this.block_list.get(i).toString() + "\n");
        }
        return new String(buf);
    }

    public void checkSorted(IndexComparator c) {
        IntegerIterator iterator = this.iterator(0, this.size() - 1);
        AbstractBlockIntegerList.checkSorted(iterator, c);
    }

    public static void checkSorted(IntegerIterator iterator, IndexComparator c) {
        if (iterator.hasNext()) {
            int last_index = iterator.next();
            while (iterator.hasNext()) {
                int cur = iterator.next();
                if (c.compare(cur, last_index) < 0) {
                    throw new Error("List not sorted!");
                }
                last_index = cur;
            }
        }
    }

    private final class BILIterator
    implements IntegerIterator {
        private int start_offset;
        private int end_offset;
        private IntegerListBlockInterface current_block;
        private int current_block_size;
        private int block_index;
        private int block_offset;
        private int cur_offset;

        public BILIterator(int start_offset, int end_offset) {
            this.start_offset = start_offset;
            this.end_offset = end_offset;
            this.cur_offset = start_offset - 1;
            if (end_offset >= start_offset) {
                this.setupVars(start_offset - 1);
            }
        }

        private void setupVars(int pos) {
            int size = AbstractBlockIntegerList.this.block_list.size();
            int start = 0;
            this.block_index = 0;
            while (this.block_index < size) {
                IntegerListBlockInterface block = (IntegerListBlockInterface)AbstractBlockIntegerList.this.block_list.get(this.block_index);
                int bsize = block.size();
                if (pos < start + bsize) {
                    this.block_offset = pos - start;
                    if (this.block_offset < 0) {
                        this.block_offset = -1;
                    }
                    this.current_block = block;
                    this.current_block_size = bsize;
                    return;
                }
                start += bsize;
                ++this.block_index;
            }
            throw new Error("'pos' (" + pos + ") out of bounds.");
        }

        public boolean hasNext() {
            return this.cur_offset < this.end_offset;
        }

        public int next() {
            ++this.block_offset;
            ++this.cur_offset;
            if (this.block_offset >= this.current_block_size) {
                ++this.block_index;
                this.current_block = (IntegerListBlockInterface)AbstractBlockIntegerList.this.block_list.get(this.block_index);
                this.current_block_size = this.current_block.size();
                this.block_offset = 0;
            }
            return this.current_block.intAt(this.block_offset);
        }

        public boolean hasPrevious() {
            return this.cur_offset > this.start_offset;
        }

        private void walkBack() {
            --this.block_offset;
            --this.cur_offset;
            if (this.block_offset < 0 && this.block_index > 0) {
                --this.block_index;
                this.current_block = (IntegerListBlockInterface)AbstractBlockIntegerList.this.block_list.get(this.block_index);
                this.current_block_size = this.current_block.size();
                this.block_offset = this.current_block.size() - 1;
            }
        }

        public int previous() {
            this.walkBack();
            return this.current_block.intAt(this.block_offset);
        }

        public void remove() {
            AbstractBlockIntegerList.this.checkImmutable();
            int orig_block_count = AbstractBlockIntegerList.this.block_list.size();
            AbstractBlockIntegerList.this.removeFromBlock(this.block_index, this.current_block, this.block_offset);
            if (orig_block_count == AbstractBlockIntegerList.this.block_list.size()) {
                --this.current_block_size;
                this.walkBack();
            } else {
                --this.cur_offset;
                this.setupVars(this.cur_offset);
            }
            --this.end_offset;
        }
    }
}

