/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.tools;

import com.mckoi.database.Database;
import com.mckoi.database.DatabaseSystem;
import com.mckoi.database.control.DefaultDBConfig;
import com.mckoi.util.CommandLine;
import java.io.IOException;

public class DataFileConvertTool {
    private static void printSyntax() {
        System.out.println("DataFileConvertTool -path [data files path] -u [admin username] -p [admin password]");
    }

    public static void main(String[] args) {
        CommandLine cl = new CommandLine(args);
        String path = cl.switchArgument("-path");
        String admin_username = cl.switchArgument("-u");
        String admin_password = cl.switchArgument("-p");
        if (path == null) {
            DataFileConvertTool.printSyntax();
            System.out.println("Error: -path not found on command line.");
            System.exit(-1);
        }
        if (admin_username == null) {
            DataFileConvertTool.printSyntax();
            System.out.println("Error: -u [username] not found on command line.");
            System.exit(-1);
        }
        if (admin_password == null) {
            DataFileConvertTool.printSyntax();
            System.out.println("Error: -p [password] not found on command line.");
            System.exit(-1);
        }
        DatabaseSystem system = new DatabaseSystem();
        DefaultDBConfig config = new DefaultDBConfig();
        config.setDatabasePath(path);
        config.setMinimumDebugLevel(Integer.MAX_VALUE);
        system.setDebugLevel(Integer.MAX_VALUE);
        system.init(config);
        Database database = new Database(system, "DefaultDatabase");
        boolean success = false;
        try {
            success = database.convertToCurrent(System.out, admin_username);
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
            e.printStackTrace(System.out);
        }
        if (success) {
            System.out.println("-- Convert Successful --");
        } else {
            System.out.println("-- Convert Failed --");
        }
        database.startShutDownThread();
        database.waitUntilShutdown();
    }
}

