/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.tools;

import com.mckoi.database.TableDataConglomerate;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.control.DefaultDBConfig;
import com.mckoi.util.CommandLine;
import com.mckoi.util.ShellUserTerminal;
import java.io.StringWriter;

public class DBConglomerateRepairTool {
    private static void repair(String path, String name) {
        ShellUserTerminal terminal = new ShellUserTerminal();
        TransactionSystem system = new TransactionSystem();
        DefaultDBConfig config = new DefaultDBConfig();
        config.setDatabasePath(path);
        config.setLogPath("");
        config.setMinimumDebugLevel(50000);
        config.setValue("do_not_use_nio_api", "enabled");
        system.setDebugOutput(new StringWriter());
        system.init(config);
        TableDataConglomerate conglomerate = new TableDataConglomerate(system, system.storeSystem());
        conglomerate.fix(name, terminal);
        system.dispose();
    }

    private static void printSyntax() {
        System.out.println("DBConglomerateRepairTool -path [data directory] [-name [database name]]");
    }

    public static void main(String[] args) {
        CommandLine cl = new CommandLine(args);
        String path = cl.switchArgument("-path");
        String name = cl.switchArgument("-name", "DefaultDatabase");
        if (path == null) {
            DBConglomerateRepairTool.printSyntax();
            System.out.println("Error: -path not found on command line.");
            System.exit(-1);
        }
        DBConglomerateRepairTool.repair(path, name);
    }
}

