/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.store;

import com.mckoi.store.IOStoreDataAccessor;
import com.mckoi.store.StoreDataAccessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class ScatteringStoreDataAccessor
implements StoreDataAccessor {
    private final File path;
    private final String file_name;
    private final String first_ext;
    private final long max_slice_size;
    private ArrayList slice_list;
    private long true_file_length;
    private final Object lock = new Object();
    private boolean open = false;

    public ScatteringStoreDataAccessor(File path, String file_name, String first_ext, long max_slice_size) {
        this.slice_list = new ArrayList();
        this.path = path;
        this.file_name = file_name;
        this.first_ext = first_ext;
        this.max_slice_size = max_slice_size;
    }

    public void convertToScatteringStore(File f) throws IOException {
        int BUFFER_SIZE = 65536;
        RandomAccessFile src = new RandomAccessFile(f, "rw");
        long file_size = f.length();
        long current_p = this.max_slice_size;
        long to_write = Math.min(file_size - current_p, this.max_slice_size);
        int write_to_part = 1;
        byte[] copy_buffer = new byte[BUFFER_SIZE];
        while (to_write > 0L) {
            src.seek(current_p);
            File to_f = this.slicePartFile(write_to_part);
            if (to_f.exists()) {
                throw new IOException("Copy error, slice already exists.");
            }
            FileOutputStream to_raf = new FileOutputStream(to_f);
            while (to_write > 0L) {
                int size_to_copy = (int)Math.min((long)BUFFER_SIZE, to_write);
                src.readFully(copy_buffer, 0, size_to_copy);
                to_raf.write(copy_buffer, 0, size_to_copy);
                current_p += (long)size_to_copy;
                to_write -= (long)size_to_copy;
            }
            to_raf.flush();
            to_raf.close();
            to_write = Math.min(file_size - current_p, this.max_slice_size);
            ++write_to_part;
        }
        if (file_size > this.max_slice_size) {
            src.seek(0L);
            src.setLength(this.max_slice_size);
        }
        src.close();
    }

    private File slicePartFile(int i) {
        if (i == 0) {
            return new File(this.path, this.file_name + "." + this.first_ext);
        }
        StringBuffer fn = new StringBuffer();
        fn.append(this.file_name);
        fn.append(".");
        if (i < 10) {
            fn.append("00");
        } else if (i < 100) {
            fn.append("0");
        }
        fn.append(i);
        return new File(this.path, fn.toString());
    }

    private int countStoreFiles() {
        int i = 0;
        File f = this.slicePartFile(i);
        while (f.exists()) {
            f = this.slicePartFile(++i);
        }
        return i;
    }

    private StoreDataAccessor createSliceDataAccessor(File file) {
        return new IOStoreDataAccessor(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long discoverSize() throws IOException {
        long running_total = 0L;
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            File f = this.slicePartFile(i);
            while (f.exists()) {
                running_total += this.createSliceDataAccessor(f).getSize();
                f = this.slicePartFile(++i);
            }
        }
        return running_total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean read_only) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.slice_list = new ArrayList();
            File f = this.slicePartFile(0);
            boolean open_existing = f.exists();
            if (open_existing && f.length() > this.max_slice_size) {
                File f2 = this.slicePartFile(1);
                if (f2.exists()) {
                    throw new IOException("File length exceeds maximum slice size setting.");
                }
                if (!read_only) {
                    this.convertToScatteringStore(f);
                } else {
                    throw new IOException("Unable to convert to a scattered store because read-only.");
                }
            }
            FileSlice slice = new FileSlice();
            slice.data = this.createSliceDataAccessor(f);
            slice.data.open(read_only);
            this.slice_list.add(slice);
            long running_length = slice.data.getSize();
            if (open_existing) {
                int i = 1;
                File slice_part = this.slicePartFile(i);
                while (slice_part.exists()) {
                    slice = new FileSlice();
                    slice.data = this.createSliceDataAccessor(slice_part);
                    slice.data.open(read_only);
                    this.slice_list.add(slice);
                    running_length += slice.data.getSize();
                    slice_part = this.slicePartFile(++i);
                }
            }
            this.true_file_length = running_length;
            this.open = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int sz = this.slice_list.size();
            for (int i = 0; i < sz; ++i) {
                FileSlice slice = (FileSlice)this.slice_list.get(i);
                slice.data.close();
            }
            this.slice_list = null;
            this.open = false;
        }
    }

    public boolean delete() {
        int count_files = this.countStoreFiles();
        for (int i = count_files - 1; i >= 0; --i) {
            File f = this.slicePartFile(i);
            boolean delete_success = this.createSliceDataAccessor(f).delete();
            if (delete_success) continue;
            return false;
        }
        return true;
    }

    public boolean exists() {
        return this.slicePartFile(0).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(long position, byte[] buf, int off, int len) throws IOException {
        while (len > 0) {
            FileSlice slice;
            int file_i = (int)(position / this.max_slice_size);
            long file_p = position % this.max_slice_size;
            int file_len = (int)Math.min((long)len, this.max_slice_size - file_p);
            Object object = this.lock;
            synchronized (object) {
                if (file_i < 0 || file_i >= this.slice_list.size()) {
                    return;
                }
                slice = (FileSlice)this.slice_list.get(file_i);
            }
            slice.data.read(file_p, buf, off, file_len);
            position += (long)file_len;
            off += file_len;
            len -= file_len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long position, byte[] buf, int off, int len) throws IOException {
        while (len > 0) {
            FileSlice slice;
            int file_i = (int)(position / this.max_slice_size);
            long file_p = position % this.max_slice_size;
            int file_len = (int)Math.min((long)len, this.max_slice_size - file_p);
            Object object = this.lock;
            synchronized (object) {
                if (file_i < 0 || file_i >= this.slice_list.size()) {
                    return;
                }
                slice = (FileSlice)this.slice_list.get(file_i);
            }
            slice.data.write(file_p, buf, off, file_len);
            position += (long)file_len;
            off += file_len;
            len -= file_len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(long length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long total_size_to_grow = length - this.true_file_length;
            if (total_size_to_grow < 0L) {
                throw new IOException("Unable to make the data area size smaller for this type of store.");
            }
            while (total_size_to_grow > 0L) {
                int last = this.slice_list.size() - 1;
                FileSlice slice = (FileSlice)this.slice_list.get(last);
                long old_slice_length = slice.data.getSize();
                long to_grow = Math.min(total_size_to_grow, this.max_slice_size - old_slice_length);
                slice.data.setSize(old_slice_length + to_grow);
                slice.data.synch();
                if ((total_size_to_grow -= to_grow) <= 0L) continue;
                File slice_file = this.slicePartFile(last + 1);
                slice = new FileSlice();
                slice.data = this.createSliceDataAccessor(slice_file);
                slice.data.open(false);
                this.slice_list.add(slice);
            }
            this.true_file_length = length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.open) {
                return this.true_file_length;
            }
            return this.discoverSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synch() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int sz = this.slice_list.size();
            for (int i = 0; i < sz; ++i) {
                FileSlice slice = (FileSlice)this.slice_list.get(i);
                slice.data.synch();
            }
        }
    }

    private static class FileSlice {
        StoreDataAccessor data;

        private FileSlice() {
        }
    }
}

