/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.store;

import com.mckoi.store.Area;
import com.mckoi.store.AreaWriter;
import com.mckoi.store.MutableArea;
import com.mckoi.store.Store;
import com.mckoi.util.ByteArrayUtil;
import com.mckoi.util.UserTerminal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractStore
implements Store {
    protected long[] free_bin_list;
    protected long wilderness_pointer;
    protected boolean read_only;
    protected long total_allocated_space;
    private boolean dirty_open;
    protected static final long DATA_AREA_OFFSET = 1312L;
    protected static final long FIXED_AREA_OFFSET = 128L;
    protected static final long BIN_AREA_OFFSET = 256L;
    protected static final int MAGIC = 11447953;
    private byte[] buf = new byte[8];
    private final byte[] bin_area = new byte[1024];
    protected final byte[] header_buf = new byte[16];
    private long[] header_info = new long[2];
    private long[] header_info2 = new long[2];
    private static final int[] BIN_SIZES = new int[]{32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, 480, 512, 544, 576, 608, 640, 672, 704, 736, 768, 800, 832, 864, 896, 928, 960, 992, 1024, 1056, 1088, 1120, 1152, 1184, 1216, 1248, 1280, 1312, 1344, 1376, 1408, 1440, 1472, 1504, 1536, 1568, 1600, 1632, 1664, 1696, 1728, 1760, 1792, 1824, 1856, 1888, 1920, 1952, 1984, 2016, 2048, 2080, 2144, 2208, 2272, 2336, 2400, 2464, 2528, 2592, 2656, 2720, 2784, 2848, 2912, 2976, 3040, 3104, 3168, 3232, 3296, 3360, 3424, 3488, 3552, 3616, 3680, 3744, 3808, 3872, 3936, 4000, 4064, 4128, 4384, 4640, 4896, 5152, 5408, 5664, 5920, 6176, 6432, 6688, 6944, 7200, 7456, 7712, 7968, 8224, 10272, 12320, 14368, 16416, 18464, 20512, 22560, 24608, 57376, 90144, 122912, 155680, 1204256, 0x226020};
    protected static final int BIN_ENTRIES = BIN_SIZES.length;
    private static final int MAX_BIN_SIZE = BIN_SIZES[BIN_ENTRIES - 1];

    protected AbstractStore(boolean read_only) {
        this.free_bin_list = new long[BIN_ENTRIES + 1];
        for (int i = 0; i < BIN_ENTRIES + 1; ++i) {
            this.free_bin_list[i] = -1L;
        }
        this.wilderness_pointer = -1L;
        this.read_only = read_only;
    }

    private synchronized void initializeToEmpty() throws IOException {
        this.setDataAreaSize(1312L);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(256);
        DataOutputStream out = new DataOutputStream(bout);
        out.writeInt(11447953);
        out.writeInt(1);
        out.writeLong(-1L);
        out.writeByte(0);
        out.flush();
        byte[] buf = new byte[1312];
        byte[] buf2 = bout.toByteArray();
        System.arraycopy(buf2, 0, buf, 0, buf2.length);
        for (int i = 256; i < 1312; ++i) {
            buf[i] = -1;
        }
        this.writeByteArrayToPT(0L, buf, 0, buf.length);
    }

    public synchronized boolean open() throws IOException {
        long file_length;
        this.internalOpen(this.read_only);
        if (this.endOfDataAreaPointer() < 1312L) {
            this.initializeToEmpty();
        }
        byte[] read_buf = new byte[256];
        this.readByteArrayFrom(0L, read_buf, 0, read_buf.length);
        ByteArrayInputStream b_in = new ByteArrayInputStream(read_buf);
        DataInputStream din = new DataInputStream(b_in);
        int magic = din.readInt();
        if (magic != 11447953) {
            throw new IOException("Format invalid: Magic value is not as expected.");
        }
        int version = din.readInt();
        if (version != 1) {
            throw new IOException("Format invalid: unrecognised version.");
        }
        din.readLong();
        byte status = din.readByte();
        this.dirty_open = false;
        if (status == 1) {
            this.dirty_open = true;
        }
        this.readBins();
        if (!this.read_only) {
            this.writeByteToPT(16L, 1);
        }
        if ((file_length = this.endOfDataAreaPointer()) <= 8L) {
            throw new IOException("Format invalid: File size is too small.");
        }
        if (file_length == 1312L) {
            this.wilderness_pointer = -1L;
        } else {
            this.readByteArrayFrom(file_length - 8L, read_buf, 0, 8);
            long last_boundary = ByteArrayUtil.getLong(read_buf, 0);
            long last_area_pointer = file_length - last_boundary;
            if (last_area_pointer < 1312L) {
                System.out.println("last_boundary = " + last_boundary);
                System.out.println("last_area_pointer = " + last_area_pointer);
                throw new IOException("File corrupt: last_area_pointer is before data part of file.");
            }
            if (last_area_pointer > file_length - 8L) {
                throw new IOException("File corrupt: last_area_pointer at the end of the file.");
            }
            this.readByteArrayFrom(last_area_pointer, read_buf, 0, 8);
            long last_area_header = ByteArrayUtil.getLong(read_buf, 0);
            this.wilderness_pointer = (last_area_header & Long.MIN_VALUE) != 0L ? last_area_pointer : -1L;
        }
        return this.dirty_open;
    }

    public synchronized void close() throws IOException {
        if (!this.read_only) {
            this.writeByteToPT(16L, 0);
        }
        this.internalClose();
    }

    protected static boolean isValidBoundarySize(long size) {
        long MAX_AREA_SIZE = 429496729400L;
        return (size &= Long.MAX_VALUE) < MAX_AREA_SIZE && size >= 24L && (size & 7L) == 0L;
    }

    private long readLongAt(long position) throws IOException {
        this.readByteArrayFrom(position, this.buf, 0, 8);
        return ByteArrayUtil.getLong(this.buf, 0);
    }

    private boolean repairScan(ArrayList areas_to_fix, long pointer, long end_pointer, boolean scan_forward, int max_repairs) throws IOException {
        boolean b;
        long v;
        long i;
        if (pointer == end_pointer) {
            return true;
        }
        if (pointer > end_pointer || max_repairs <= 0) {
            return false;
        }
        long pointer_to_head = scan_forward ? pointer : end_pointer - 8L;
        long first_header = this.readLongAt(pointer_to_head) & Long.MAX_VALUE;
        long max_bound_size = end_pointer - pointer;
        if (AbstractStore.isValidBoundarySize(first_header) && first_header <= max_bound_size) {
            long scan_area_p2;
            long pointer_to_tail;
            long end_area_pointer = pointer_to_tail = scan_forward ? pointer + first_header - 8L : end_pointer - first_header;
            long end_header = this.readLongAt(end_area_pointer) & Long.MAX_VALUE;
            boolean valid_end_header = first_header == end_header;
            long scan_area_p1 = scan_forward ? pointer + first_header : pointer;
            long l = scan_area_p2 = scan_forward ? end_pointer : end_pointer - first_header;
            if (!valid_end_header) {
                long area_p = scan_forward ? pointer_to_head : pointer_to_tail;
                areas_to_fix.add(new Long(area_p));
                areas_to_fix.add(new Long(first_header));
                boolean b2 = this.repairScan(areas_to_fix, scan_area_p1, scan_area_p2, true, max_repairs - 1);
                if (b2) {
                    return true;
                }
                areas_to_fix.remove(areas_to_fix.size() - 1);
                areas_to_fix.remove(areas_to_fix.size() - 1);
            } else {
                boolean b3;
                boolean something_broken = false;
                long previous1_scan_area_p1 = scan_area_p1;
                long previous2_scan_area_p1 = scan_area_p1;
                long previous3_scan_area_p1 = scan_area_p1;
                while (scan_area_p1 < scan_area_p2 && !something_broken) {
                    long scan_end_header;
                    something_broken = true;
                    long scanning_header = this.readLongAt(scan_area_p1) & Long.MAX_VALUE;
                    long scan_max_bound_size = scan_area_p2 - scan_area_p1;
                    if (!AbstractStore.isValidBoundarySize(scanning_header) || scanning_header > scan_max_bound_size || (scan_end_header = this.readLongAt(scan_area_p1 + scanning_header - 8L) & Long.MAX_VALUE) != scanning_header) continue;
                    previous3_scan_area_p1 = previous2_scan_area_p1;
                    previous2_scan_area_p1 = previous1_scan_area_p1;
                    previous1_scan_area_p1 = scan_area_p1;
                    scan_area_p1 += scanning_header;
                    something_broken = false;
                }
                if (something_broken) {
                    scan_area_p1 = previous3_scan_area_p1;
                }
                if (b3 = this.repairScan(areas_to_fix, scan_area_p1, scan_area_p2, true, max_repairs)) {
                    return b3;
                }
            }
        }
        if (scan_forward) {
            boolean b4 = this.repairScan(areas_to_fix, pointer, end_pointer, false, max_repairs);
            if (b4) {
                return b4;
            }
        } else {
            return false;
        }
        long max_size = end_pointer - pointer;
        for (i = 16L; i < max_size; i += 8L) {
            v = this.readLongAt(pointer + i) & Long.MAX_VALUE;
            if (v != i + 8L) continue;
            areas_to_fix.add(new Long(pointer));
            areas_to_fix.add(new Long(i + 8L));
            b = this.repairScan(areas_to_fix, pointer + i + 8L, end_pointer, true, max_repairs - 1);
            if (b) {
                return true;
            }
            areas_to_fix.remove(areas_to_fix.size() - 1);
            areas_to_fix.remove(areas_to_fix.size() - 1);
        }
        for (i = max_size - 8L - 16L; i >= 0L; i -= 8L) {
            v = this.readLongAt(pointer + i) & Long.MAX_VALUE;
            if (v != max_size - i) continue;
            areas_to_fix.add(new Long(pointer + i));
            areas_to_fix.add(new Long(max_size - i));
            b = this.repairScan(areas_to_fix, pointer, pointer + i, true, max_repairs - 1);
            if (b) {
                return true;
            }
            areas_to_fix.remove(areas_to_fix.size() - 1);
            areas_to_fix.remove(areas_to_fix.size() - 1);
        }
        areas_to_fix.add(new Long(pointer));
        areas_to_fix.add(new Long(end_pointer - pointer));
        return true;
    }

    public synchronized void openScanAndFix(UserTerminal terminal) throws IOException {
        long area_size;
        long pointer;
        int i;
        this.internalOpen(this.read_only);
        terminal.println("- Store: " + this.toString());
        if (this.endOfDataAreaPointer() < 1312L) {
            terminal.println("+ Store too small - initializing to empty.");
            this.initializeToEmpty();
            return;
        }
        byte[] read_buf = new byte[256];
        this.readByteArrayFrom(0L, read_buf, 0, read_buf.length);
        ByteArrayInputStream b_in = new ByteArrayInputStream(read_buf);
        DataInputStream din = new DataInputStream(b_in);
        int magic = din.readInt();
        if (magic != 11447953) {
            terminal.println("! Store magic value not present - not fixable.");
            return;
        }
        int version = din.readInt();
        if (version != 1) {
            terminal.println("! Store version is invalid - not fixable.");
            return;
        }
        long end_of_data_area = this.endOfDataAreaPointer();
        if (end_of_data_area < 1328L) {
            terminal.println("! Store is too small, reinitializing store to blank state.");
            this.initializeToEmpty();
            return;
        }
        ArrayList repairs = new ArrayList();
        boolean b = this.repairScan(repairs, 1312L, this.endOfDataAreaPointer(), true, 20);
        if (b) {
            if (repairs.size() == 0) {
                terminal.println("- Store areas are intact.");
            } else {
                terminal.println("+ " + repairs.size() / 2 + " area repairs:");
                for (i = 0; i < repairs.size(); i += 2) {
                    terminal.println("  Area pointer: " + repairs.get(i));
                    terminal.println("  Area size: " + repairs.get(i + 1));
                    pointer = (Long)repairs.get(i);
                    long size = (Long)repairs.get(i + 1);
                    this.coalescArea(pointer, size);
                }
            }
        } else {
            terminal.println("- Store is not repairable!");
        }
        this.free_bin_list = new long[BIN_ENTRIES + 1];
        for (i = 0; i < BIN_ENTRIES + 1; ++i) {
            this.free_bin_list[i] = -1L;
        }
        terminal.println("+ Rebuilding free bins.");
        long[] header = new long[2];
        for (pointer = 1312L; pointer < end_of_data_area; pointer += area_size) {
            boolean is_free;
            this.getAreaHeader(pointer, header);
            area_size = header[0] & Long.MAX_VALUE;
            boolean bl = is_free = (header[0] & Long.MIN_VALUE) != 0L;
            if (!is_free) continue;
            this.addToBinChain(pointer, area_size);
        }
        this.writeAllBins();
        terminal.println("- Store repair complete.");
        this.open();
    }

    public synchronized void statsScan(HashMap properties) throws IOException {
        long area_size;
        long free_areas = 0L;
        long free_total = 0L;
        long allocated_areas = 0L;
        long allocated_total = 0L;
        long end_of_data_area = this.endOfDataAreaPointer();
        long[] header = new long[2];
        for (long pointer = 1312L; pointer < end_of_data_area; pointer += area_size) {
            this.getAreaHeader(pointer, header);
            area_size = header[0] & Long.MAX_VALUE;
            if ((header[0] & Long.MIN_VALUE) != 0L) {
                ++free_areas;
                free_total += area_size;
                continue;
            }
            ++allocated_areas;
            allocated_total += area_size;
        }
        if (this.wilderness_pointer != -1L) {
            this.getAreaHeader(this.wilderness_pointer, header);
            long wilderness_size = header[0] & Long.MAX_VALUE;
            properties.put("AbstractStore.wilderness_size", new Long(wilderness_size));
        }
        properties.put("AbstractStore.end_of_data_area", new Long(end_of_data_area));
        properties.put("AbstractStore.free_areas", new Long(free_areas));
        properties.put("AbstractStore.free_total", new Long(free_total));
        properties.put("AbstractStore.allocated_areas", new Long(allocated_areas));
        properties.put("AbstractStore.allocated_total", new Long(allocated_total));
    }

    public List getAllAreas() throws IOException {
        long area_size;
        ArrayList<Long> list = new ArrayList<Long>();
        long end_of_data_area = this.endOfDataAreaPointer();
        long[] header = new long[2];
        for (long pointer = 1312L; pointer < end_of_data_area; pointer += area_size) {
            this.getAreaHeader(pointer, header);
            area_size = header[0] & Long.MAX_VALUE;
            if ((header[0] & Long.MIN_VALUE) != 0L) continue;
            list.add(new Long(pointer));
        }
        return list;
    }

    public ArrayList findAllocatedAreasNotIn(ArrayList list) throws IOException {
        long area_size;
        Collections.sort(list);
        ArrayList<Long> leaked_areas = new ArrayList<Long>();
        int list_index = 0;
        long looking_for = Long.MAX_VALUE;
        if (list_index < list.size()) {
            looking_for = (Long)list.get(list_index);
            ++list_index;
        }
        long end_of_data_area = this.endOfDataAreaPointer();
        long[] header = new long[2];
        for (long pointer = 1312L; pointer < end_of_data_area; pointer += area_size) {
            boolean area_free;
            this.getAreaHeader(pointer, header);
            area_size = header[0] & Long.MAX_VALUE;
            boolean bl = area_free = (header[0] & Long.MIN_VALUE) != 0L;
            if (pointer == looking_for) {
                if (area_free) {
                    throw new IOException("Area (pointer = " + pointer + ") is not allocated!");
                }
                if (list_index < list.size()) {
                    looking_for = (Long)list.get(list_index);
                    ++list_index;
                    continue;
                }
                looking_for = Long.MAX_VALUE;
                continue;
            }
            if (pointer > looking_for) {
                throw new IOException("Area (pointer = " + looking_for + ") wasn't found in store!");
            }
            if (area_free) continue;
            leaked_areas.add(new Long(pointer));
        }
        return leaked_areas;
    }

    public synchronized long totalAllocatedSinceStart() {
        return this.total_allocated_space;
    }

    private int minimumBinSizeIndex(long size) {
        int i = Arrays.binarySearch(BIN_SIZES, (int)size);
        if (i < 0) {
            i = -(i + 1);
        }
        return i;
    }

    protected abstract void internalOpen(boolean var1) throws IOException;

    protected abstract void internalClose() throws IOException;

    protected abstract int readByteFrom(long var1) throws IOException;

    protected abstract int readByteArrayFrom(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void writeByteTo(long var1, int var3) throws IOException;

    protected abstract void writeByteArrayTo(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract long endOfDataAreaPointer() throws IOException;

    protected abstract void setDataAreaSize(long var1) throws IOException;

    private final void writeByteToPT(long position, int b) throws IOException {
        this.writeByteTo(position, b);
    }

    private final void writeByteArrayToPT(long position, byte[] buf, int off, int len) throws IOException {
        this.writeByteArrayTo(position, buf, off, len);
    }

    protected void checkPointer(long pointer) throws IOException {
        if (pointer < 1312L || pointer >= this.endOfDataAreaPointer()) {
            throw new IOException("Pointer out of range: 1312 > " + pointer + " > " + this.endOfDataAreaPointer());
        }
    }

    protected void readBins() throws IOException {
        this.readByteArrayFrom(256L, this.bin_area, 0, 1024);
        ByteArrayInputStream bin = new ByteArrayInputStream(this.bin_area);
        DataInputStream in = new DataInputStream(bin);
        for (int i = 0; i < 128; ++i) {
            this.free_bin_list[i] = in.readLong();
        }
    }

    protected void writeAllBins() throws IOException {
        int p = 0;
        int i = 0;
        while (i < 128) {
            long val = this.free_bin_list[i];
            ByteArrayUtil.setLong(val, this.bin_area, p);
            ++i;
            p += 8;
        }
        this.writeByteArrayToPT(256L, this.bin_area, 0, 1024);
    }

    protected void writeBinIndex(int index) throws IOException {
        int p = index * 8;
        long val = this.free_bin_list[index];
        ByteArrayUtil.setLong(val, this.bin_area, p);
        this.writeByteArrayToPT(256L + (long)p, this.bin_area, p, 8);
    }

    protected void getAreaHeader(long pointer, long[] header) throws IOException {
        this.readByteArrayFrom(pointer, this.header_buf, 0, 16);
        header[0] = ByteArrayUtil.getLong(this.header_buf, 0);
        header[1] = ByteArrayUtil.getLong(this.header_buf, 8);
    }

    protected long getPreviousAreaHeader(long pointer, long[] header) throws IOException {
        if (pointer == 1312L) {
            header[0] = 0L;
            return -1L;
        }
        this.readByteArrayFrom(pointer - 8L, this.header_buf, 0, 8);
        long sz = ByteArrayUtil.getLong(this.header_buf, 0);
        long previous_pointer = pointer - (sz &= Long.MAX_VALUE);
        this.readByteArrayFrom(previous_pointer, this.header_buf, 0, 8);
        header[0] = ByteArrayUtil.getLong(this.header_buf, 0);
        return previous_pointer;
    }

    protected long getNextAreaHeader(long pointer, long[] header) throws IOException {
        this.readByteArrayFrom(pointer, this.header_buf, 0, 8);
        long sz = ByteArrayUtil.getLong(this.header_buf, 0);
        long next_pointer = pointer + (sz &= Long.MAX_VALUE);
        if (next_pointer >= this.endOfDataAreaPointer()) {
            header[0] = 0L;
            return -1L;
        }
        this.readByteArrayFrom(next_pointer, this.header_buf, 0, 8);
        header[0] = ByteArrayUtil.getLong(this.header_buf, 0);
        return next_pointer;
    }

    protected void reboundArea(long pointer, long[] header, boolean write_headers) throws IOException {
        if (write_headers) {
            ByteArrayUtil.setLong(header[0], this.header_buf, 0);
            ByteArrayUtil.setLong(header[1], this.header_buf, 8);
            this.writeByteArrayToPT(pointer, this.header_buf, 0, 16);
        } else {
            ByteArrayUtil.setLong(header[1], this.header_buf, 8);
            this.writeByteArrayToPT(pointer + 8L, this.header_buf, 8, 8);
        }
    }

    protected void coalescArea(long pointer, long size) throws IOException {
        ByteArrayUtil.setLong(size, this.header_buf, 0);
        this.writeByteArrayToPT(pointer, this.header_buf, 0, 8);
        this.writeByteArrayToPT(pointer + size - 8L, this.header_buf, 0, 8);
    }

    protected long expandDataArea(long minimum_size) throws IOException {
        long end_of_data_area = this.endOfDataAreaPointer();
        long over_grow = end_of_data_area / 64L;
        long d = over_grow & 7L;
        if (d != 0L) {
            over_grow += 8L - d;
        }
        if ((over_grow = Math.min(over_grow, 262144L)) < 1024L) {
            over_grow = 1024L;
        }
        long grow_by = minimum_size + over_grow;
        long new_file_length = end_of_data_area + grow_by;
        this.setDataAreaSize(new_file_length);
        return grow_by;
    }

    protected void splitArea(long pointer, long new_boundary) throws IOException {
        this.readByteArrayFrom(pointer, this.header_buf, 0, 8);
        long cur_size = ByteArrayUtil.getLong(this.header_buf, 0) & Long.MAX_VALUE;
        long left_size = new_boundary;
        long right_size = cur_size - new_boundary;
        if (right_size < 0L) {
            throw new Error("right_size < 0");
        }
        ByteArrayUtil.setLong(left_size, this.header_buf, 0);
        ByteArrayUtil.setLong(right_size, this.header_buf, 8);
        this.writeByteArrayToPT(pointer + new_boundary - 8L, this.header_buf, 0, 16);
        this.writeByteArrayToPT(pointer, this.header_buf, 0, 8);
        this.writeByteArrayToPT(pointer + cur_size - 8L, this.header_buf, 8, 8);
    }

    private void addToBinChain(long pointer, long size) throws IOException {
        this.checkPointer(pointer);
        int bin_chain_index = this.minimumBinSizeIndex(size);
        long cur_pointer = this.free_bin_list[bin_chain_index];
        if (cur_pointer == -1L) {
            this.header_info[0] = size | Long.MIN_VALUE;
            this.header_info[1] = -1L;
            this.reboundArea(pointer, this.header_info, true);
            this.free_bin_list[bin_chain_index] = pointer;
            this.writeBinIndex(bin_chain_index);
        } else {
            boolean inserted = false;
            long last_pointer = -1L;
            int searches = 0;
            while (cur_pointer != -1L && !inserted) {
                this.getAreaHeader(cur_pointer, this.header_info);
                long header = this.header_info[0];
                long next = this.header_info[1];
                if ((header & Long.MIN_VALUE) == 0L) {
                    throw new Error("Assert failed - area not marked as deleted.  pos = " + cur_pointer + " this = " + this.toString());
                }
                long area_size = header ^ Long.MIN_VALUE;
                if (area_size >= size || searches >= 12) {
                    long previous = last_pointer;
                    this.header_info[0] = size | Long.MIN_VALUE;
                    this.header_info[1] = cur_pointer;
                    this.reboundArea(pointer, this.header_info, true);
                    if (last_pointer != -1L) {
                        this.getAreaHeader(previous, this.header_info);
                        this.header_info[1] = pointer;
                        this.reboundArea(previous, this.header_info, false);
                    } else {
                        this.free_bin_list[bin_chain_index] = pointer;
                        this.writeBinIndex(bin_chain_index);
                    }
                    inserted = true;
                }
                last_pointer = cur_pointer;
                cur_pointer = next;
                ++searches;
            }
            if (!inserted) {
                this.header_info[0] = size | Long.MIN_VALUE;
                this.header_info[1] = -1L;
                this.reboundArea(pointer, this.header_info, true);
                this.getAreaHeader(last_pointer, this.header_info);
                this.header_info[1] = pointer;
                this.reboundArea(last_pointer, this.header_info, false);
            }
        }
    }

    private void removeFromBinChain(long pointer, long size) throws IOException {
        int bin_chain_index = this.minimumBinSizeIndex(size);
        long previous_pointer = -1L;
        long cur_pointer = this.free_bin_list[bin_chain_index];
        while (pointer != cur_pointer) {
            if (cur_pointer == -1L) {
                throw new IOException("Area not found in bin chain!  pos = " + pointer + " store = " + this.toString());
            }
            this.getAreaHeader(cur_pointer, this.header_info);
            previous_pointer = cur_pointer;
            cur_pointer = this.header_info[1];
        }
        if (previous_pointer == -1L) {
            this.getAreaHeader(pointer, this.header_info);
            this.free_bin_list[bin_chain_index] = this.header_info[1];
            this.writeBinIndex(bin_chain_index);
        } else {
            this.getAreaHeader(previous_pointer, this.header_info2);
            this.getAreaHeader(pointer, this.header_info);
            this.header_info2[1] = this.header_info[1];
            this.reboundArea(previous_pointer, this.header_info2, false);
        }
    }

    private void cropArea(long pointer, long allocated_size) throws IOException {
        boolean is_wilderness;
        long header;
        this.getAreaHeader(pointer, this.header_info);
        long free_area_size = header = this.header_info[0];
        long size_difference = free_area_size - allocated_size;
        boolean bl = is_wilderness = pointer == this.wilderness_pointer;
        if (is_wilderness && size_difference >= 32L || size_difference >= 512L) {
            this.splitArea(pointer, allocated_size);
            long left_over_pointer = pointer + allocated_size;
            this.addToBinChain(left_over_pointer, size_difference);
            if (is_wilderness || left_over_pointer + size_difference >= this.endOfDataAreaPointer()) {
                this.wilderness_pointer = left_over_pointer;
            }
        } else if (is_wilderness) {
            this.wilderness_pointer = -1L;
        }
    }

    private long alloc(long size) throws IOException {
        long free_area_pointer;
        int i;
        long d;
        if (size < 0L) {
            throw new IOException("Negative size allocation");
        }
        if ((size += 16L) < 32L) {
            size = 32L;
        }
        if ((d = size & 7L) != 0L) {
            size += 8L - d;
        }
        long real_alloc_size = size;
        int bin_chain_index = size > (long)MAX_BIN_SIZE ? BIN_ENTRIES : (i = this.minimumBinSizeIndex(size));
        int found_bin_index = -1;
        long previous_pointer = -1L;
        boolean first = true;
        for (int i2 = bin_chain_index; i2 < BIN_ENTRIES + 1 && found_bin_index == -1; ++i2) {
            long cur_pointer = this.free_bin_list[i2];
            if (cur_pointer != -1L) {
                if (!first) {
                    found_bin_index = i2;
                    previous_pointer = -1L;
                } else {
                    long last_pointer = -1L;
                    for (int searches = 0; cur_pointer != -1L && found_bin_index == -1 && searches < 12; ++searches) {
                        this.getAreaHeader(cur_pointer, this.header_info);
                        long area_size = this.header_info[0] & Long.MAX_VALUE;
                        if (cur_pointer != this.wilderness_pointer && area_size >= size) {
                            found_bin_index = i2;
                            previous_pointer = last_pointer;
                        }
                        last_pointer = cur_pointer;
                        cur_pointer = this.header_info[1];
                    }
                }
            }
            first = false;
        }
        if (found_bin_index == -1) {
            long current_area_size;
            long size_to_grow;
            long working_pointer;
            if (this.wilderness_pointer != -1L) {
                working_pointer = this.wilderness_pointer;
                this.getAreaHeader(this.wilderness_pointer, this.header_info);
                long wilderness_size = this.header_info[0] & Long.MAX_VALUE;
                this.removeFromBinChain(working_pointer, wilderness_size);
                this.wilderness_pointer = -1L;
                size_to_grow = size - wilderness_size;
                current_area_size = wilderness_size;
            } else {
                working_pointer = this.endOfDataAreaPointer();
                size_to_grow = size;
                current_area_size = 0L;
            }
            long expanded_size = 0L;
            if (size_to_grow > 0L) {
                expanded_size = this.expandDataArea(size_to_grow);
            }
            this.coalescArea(working_pointer, current_area_size + expanded_size);
            this.cropArea(working_pointer, size);
            this.total_allocated_space += real_alloc_size;
            return working_pointer;
        }
        if (previous_pointer == -1L) {
            free_area_pointer = this.free_bin_list[found_bin_index];
            this.getAreaHeader(free_area_pointer, this.header_info);
            this.free_bin_list[found_bin_index] = this.header_info[1];
            this.writeBinIndex(found_bin_index);
        } else {
            this.getAreaHeader(previous_pointer, this.header_info2);
            free_area_pointer = this.header_info2[1];
            this.getAreaHeader(free_area_pointer, this.header_info);
            this.header_info2[1] = this.header_info[1];
            this.reboundArea(previous_pointer, this.header_info2, false);
        }
        this.header_info[0] = this.header_info[0] & Long.MAX_VALUE;
        this.reboundArea(free_area_pointer, this.header_info, true);
        this.cropArea(free_area_pointer, size);
        this.total_allocated_space += real_alloc_size;
        return free_area_pointer;
    }

    private void free(long pointer) throws IOException {
        long freeing_area_size;
        this.getAreaHeader(pointer, this.header_info);
        if ((this.header_info[0] & Long.MIN_VALUE) != 0L) {
            throw new IOException("Area already marked as unallocated.");
        }
        boolean set_as_wilderness = pointer + this.header_info[0] >= this.endOfDataAreaPointer();
        long r_pointer = pointer;
        long r_size = freeing_area_size = this.header_info[0];
        long left_pointer = this.getPreviousAreaHeader(pointer, this.header_info2);
        boolean coalesc = false;
        if ((this.header_info2[0] & Long.MIN_VALUE) != 0L) {
            long area_size = this.header_info2[0] & Long.MAX_VALUE;
            r_pointer = left_pointer;
            r_size += area_size;
            this.removeFromBinChain(left_pointer, area_size);
            coalesc = true;
        }
        if (!set_as_wilderness) {
            long right_pointer = this.getNextAreaHeader(pointer, this.header_info2);
            if ((this.header_info2[0] & Long.MIN_VALUE) != 0L) {
                long area_size = this.header_info2[0] & Long.MAX_VALUE;
                r_size += area_size;
                this.removeFromBinChain(right_pointer, area_size);
                set_as_wilderness = right_pointer == this.wilderness_pointer;
                coalesc = true;
            }
        }
        if (coalesc) {
            this.coalescArea(r_pointer, r_size);
        }
        this.addToBinChain(r_pointer, r_size);
        if (set_as_wilderness) {
            this.wilderness_pointer = r_pointer;
        }
        this.total_allocated_space -= freeing_area_size;
    }

    private long getAreaSize(long pointer) throws IOException {
        byte[] buf = new byte[8];
        this.readByteArrayFrom(pointer, buf, 0, 8);
        long v = ByteArrayUtil.getLong(buf, 0);
        if ((v & Long.MIN_VALUE) != 0L) {
            throw new IOException("Area is deleted.");
        }
        return v - 16L;
    }

    public synchronized AreaWriter createArea(long size) throws IOException {
        long pointer = this.alloc(size);
        return new StoreAreaWriter(pointer, size);
    }

    public synchronized void deleteArea(long id) throws IOException {
        this.free(id);
    }

    public InputStream getAreaInputStream(long id) throws IOException {
        if (id == -1L) {
            return new StoreAreaInputStream(128L, 64L);
        }
        return new StoreAreaInputStream(id + 8L, this.getAreaSize(id));
    }

    public Area getArea(long id) throws IOException {
        if (id == -1L) {
            return new StoreArea(id, 128L, 64L);
        }
        return new StoreArea(id, id);
    }

    public MutableArea getMutableArea(long id) throws IOException {
        if (id == -1L) {
            return new StoreMutableArea(id, 128L, 64L);
        }
        return new StoreMutableArea(id, id);
    }

    public boolean lastCloseClean() {
        return !this.dirty_open;
    }

    private class StoreAreaWriter
    extends StoreMutableArea
    implements AreaWriter {
        public StoreAreaWriter(long pointer, long fixed_size) throws IOException {
            super(pointer, pointer + 8L, fixed_size);
        }

        public OutputStream getOutputStream() {
            return new AreaOutputStream(this);
        }

        public void finish() throws IOException {
        }
    }

    static class AreaOutputStream
    extends OutputStream {
        private final AreaWriter writer;

        public AreaOutputStream(AreaWriter writer) {
            this.writer = writer;
        }

        public void write(int b) throws IOException {
            this.writer.put((byte)b);
        }

        public void write(byte[] buf) throws IOException {
            this.writer.put(buf, 0, buf.length);
        }

        public void write(byte[] buf, int off, int len) throws IOException {
            this.writer.put(buf, off, len);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    private class StoreMutableArea
    extends StoreArea
    implements MutableArea {
        public StoreMutableArea(long id, long pointer) throws IOException {
            super(id, pointer);
        }

        public StoreMutableArea(long id, long pointer, long fixed_size) throws IOException {
            super(id, pointer, fixed_size);
        }

        public void checkOut() throws IOException {
        }

        public void put(byte b) throws IOException {
            AbstractStore.this.writeByteToPT(this.checkPositionBounds(1), b);
        }

        public void put(byte[] buf, int off, int len) throws IOException {
            AbstractStore.this.writeByteArrayToPT(this.checkPositionBounds(len), buf, off, len);
        }

        public void put(byte[] buf) throws IOException {
            this.put(buf, 0, buf.length);
        }

        public void putShort(short s) throws IOException {
            ByteArrayUtil.setShort(s, this.buffer, 0);
            AbstractStore.this.writeByteArrayToPT(this.checkPositionBounds(2), this.buffer, 0, 2);
        }

        public void putInt(int i) throws IOException {
            ByteArrayUtil.setInt(i, this.buffer, 0);
            AbstractStore.this.writeByteArrayToPT(this.checkPositionBounds(4), this.buffer, 0, 4);
        }

        public void putLong(long l) throws IOException {
            ByteArrayUtil.setLong(l, this.buffer, 0);
            AbstractStore.this.writeByteArrayToPT(this.checkPositionBounds(8), this.buffer, 0, 8);
        }

        public void putChar(char c) throws IOException {
            ByteArrayUtil.setChar(c, this.buffer, 0);
            AbstractStore.this.writeByteArrayToPT(this.checkPositionBounds(2), this.buffer, 0, 2);
        }

        public String toString() {
            return "[MutableArea start_pointer=" + this.start_pointer + " end_pointer=" + this.end_pointer + " position=" + this.position + "]";
        }
    }

    private class StoreArea
    implements Area {
        protected static final int BUFFER_SIZE = 8;
        protected final long id;
        protected final long start_pointer;
        protected final long end_pointer;
        protected long position;
        protected final byte[] buffer = new byte[8];

        public StoreArea(long id, long pointer) throws IOException {
            AbstractStore.this.checkPointer(pointer);
            AbstractStore.this.readByteArrayFrom(pointer, this.buffer, 0, 8);
            long v = ByteArrayUtil.getLong(this.buffer, 0);
            if ((v & Long.MIN_VALUE) != 0L) {
                throw new IOException("Store being constructed on deleted area.");
            }
            long max_size = v - 16L;
            this.id = id;
            this.position = this.start_pointer = pointer + 8L;
            this.end_pointer = this.start_pointer + max_size;
        }

        public StoreArea(long id, long pointer, long fixed_size) throws IOException {
            if (pointer != 128L) {
                AbstractStore.this.checkPointer(pointer);
            }
            this.id = id;
            this.position = this.start_pointer = pointer;
            this.end_pointer = this.start_pointer + fixed_size;
        }

        protected long checkPositionBounds(int diff) throws IOException {
            long new_pos = this.position + (long)diff;
            if (new_pos > this.end_pointer) {
                throw new IOException("Position out of bounds.  start=" + this.start_pointer + " end=" + this.end_pointer + " pos=" + this.position + " new_pos=" + new_pos);
            }
            long old_pos = this.position;
            this.position = new_pos;
            return old_pos;
        }

        public long getID() {
            return this.id;
        }

        public int position() {
            return (int)(this.position - this.start_pointer);
        }

        public int capacity() {
            return (int)(this.end_pointer - this.start_pointer);
        }

        public void position(int position) throws IOException {
            long act_position = this.start_pointer + (long)position;
            if (act_position >= 0L && act_position < this.end_pointer) {
                this.position = act_position;
                return;
            }
            throw new IOException("Moved position out of bounds.");
        }

        public void copyTo(AreaWriter destination_writer, int size) throws IOException {
            int BUFFER_SIZE = 2048;
            byte[] buf = new byte[2048];
            int to_copy = Math.min(size, 2048);
            while (to_copy > 0) {
                this.get(buf, 0, to_copy);
                destination_writer.put(buf, 0, to_copy);
                to_copy = Math.min(size -= to_copy, 2048);
            }
        }

        public byte get() throws IOException {
            return (byte)AbstractStore.this.readByteFrom(this.checkPositionBounds(1));
        }

        public void get(byte[] buf, int off, int len) throws IOException {
            AbstractStore.this.readByteArrayFrom(this.checkPositionBounds(len), buf, off, len);
        }

        public short getShort() throws IOException {
            AbstractStore.this.readByteArrayFrom(this.checkPositionBounds(2), this.buffer, 0, 2);
            return ByteArrayUtil.getShort(this.buffer, 0);
        }

        public int getInt() throws IOException {
            AbstractStore.this.readByteArrayFrom(this.checkPositionBounds(4), this.buffer, 0, 4);
            return ByteArrayUtil.getInt(this.buffer, 0);
        }

        public long getLong() throws IOException {
            AbstractStore.this.readByteArrayFrom(this.checkPositionBounds(8), this.buffer, 0, 8);
            return ByteArrayUtil.getLong(this.buffer, 0);
        }

        public char getChar() throws IOException {
            AbstractStore.this.readByteArrayFrom(this.checkPositionBounds(2), this.buffer, 0, 2);
            return ByteArrayUtil.getChar(this.buffer, 0);
        }

        public String toString() {
            return "[Area start_pointer=" + this.start_pointer + " end_pointer=" + this.end_pointer + " position=" + this.position + "]";
        }
    }

    private class StoreAreaInputStream
    extends InputStream {
        private long pointer;
        private long end_pointer;
        private long mark;

        public StoreAreaInputStream(long pointer, long max_size) {
            this.pointer = pointer;
            this.end_pointer = pointer + max_size;
            this.mark = -1L;
        }

        public int read() throws IOException {
            if (this.pointer >= this.end_pointer) {
                return -1;
            }
            int b = AbstractStore.this.readByteFrom(this.pointer);
            ++this.pointer;
            return b;
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            if (this.pointer >= this.end_pointer) {
                return -1;
            }
            int read_count = Math.min(len, (int)(this.end_pointer - this.pointer));
            int act_read_count = AbstractStore.this.readByteArrayFrom(this.pointer, buf, off, read_count);
            if (act_read_count != read_count) {
                throw new IOException("act_read_count != read_count");
            }
            this.pointer += (long)read_count;
            return read_count;
        }

        public long skip(long skip) throws IOException {
            long to_skip = Math.min(this.end_pointer - this.pointer, skip);
            this.pointer += to_skip;
            return to_skip;
        }

        public int available() throws IOException {
            return (int)(this.end_pointer - this.pointer);
        }

        public void close() throws IOException {
        }

        public void mark(int read_limit) {
            this.mark = this.pointer;
        }

        public void reset() throws IOException {
            this.pointer = this.mark;
        }

        public boolean markSupported() {
            return true;
        }
    }
}

