/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.jfccontrols;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import javax.swing.SwingUtilities;

public class SwingBlockUtil {
    private int block_state = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block() {
        SwingBlockUtil swingBlockUtil = this;
        synchronized (swingBlockUtil) {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new Error("Not on the event dispatcher.");
            }
            if (this.block_state != 0) {
                throw new Error("Can't nest queries.");
            }
            this.block_state = 1;
        }
        EventQueue theQueue = SwingBlockUtil.eventQueue();
        while (this.isBlocked()) {
            try {
                AWTEvent event = theQueue.getNextEvent();
                Object src = event.getSource();
                if (event instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)event)).dispatch();
                    continue;
                }
                if (src instanceof Component) {
                    ((Component)src).dispatchEvent(event);
                    continue;
                }
                if (src instanceof MenuComponent) {
                    ((MenuComponent)src).dispatchEvent(event);
                    continue;
                }
                System.err.println("unable to dispatch event: " + event);
            }
            catch (Throwable e) {
                System.err.println("Exception thrown during block util dispatching:");
                e.printStackTrace(System.err);
            }
        }
        this.block_state = 0;
    }

    public void unblock() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SwingBlockUtil.this.block_state == 1) {
                    SwingBlockUtil.this.block_state = 2;
                }
            }
        });
    }

    private boolean isBlocked() {
        return this.block_state <= 1;
    }

    private static EventQueue eventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }
}

