/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.jfccontrols;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.swing.table.AbstractTableModel;

public class ResultSetTableModel
extends AbstractTableModel {
    private ResultSet result_set;
    private ResultSetMetaData meta_data;
    private int row_count;
    private boolean preserve_table_structure = false;

    public ResultSetTableModel(ResultSet result_set) {
        if (result_set != null) {
            this.updateResultSet(result_set);
        } else {
            this.clear();
        }
    }

    public ResultSetTableModel() {
        this(null);
    }

    public void setPreserveTableStructure(boolean status) {
        this.preserve_table_structure = status;
    }

    public void updateResultSet(ResultSet result_set) {
        try {
            boolean fire_structure_change = true;
            if (this.result_set != null) {
                if (this.preserve_table_structure) {
                    ResultSetMetaData old_meta_data = this.meta_data;
                    ResultSetMetaData new_meta_data = result_set.getMetaData();
                    int col_count = new_meta_data.getColumnCount();
                    if (old_meta_data.getColumnCount() == col_count) {
                        boolean different = false;
                        for (int i = 1; i < col_count + 1 && !different; ++i) {
                            different = !old_meta_data.getColumnName(i).equals(new_meta_data.getColumnName(i)) || !old_meta_data.getTableName(i).equals(new_meta_data.getTableName(i)) || !old_meta_data.getSchemaName(i).equals(new_meta_data.getSchemaName(i));
                        }
                        fire_structure_change = different;
                    }
                }
                this.result_set.close();
            }
            this.result_set = result_set;
            this.meta_data = result_set.getMetaData();
            this.row_count = result_set.last() ? result_set.getRow() : 0;
            if (fire_structure_change) {
                this.fireTableStructureChanged();
            } else {
                this.fireTableDataChanged();
            }
        }
        catch (SQLException e) {
            throw new Error("SQL Exception: " + e.getMessage());
        }
    }

    public void clear() {
        if (this.result_set != null) {
            try {
                this.result_set.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.result_set = null;
        this.meta_data = null;
        this.row_count = 0;
        this.fireTableStructureChanged();
    }

    public int getRowCount() {
        return this.row_count;
    }

    public int getColumnCount() {
        if (this.meta_data != null) {
            try {
                return this.meta_data.getColumnCount();
            }
            catch (SQLException e) {
                throw new Error("SQL Exception: " + e.getMessage());
            }
        }
        return 0;
    }

    public String getColumnName(int column) {
        if (this.meta_data != null) {
            try {
                return this.meta_data.getColumnLabel(column + 1);
            }
            catch (SQLException e) {
                throw new Error("SQL Exception: " + e.getMessage());
            }
        }
        throw new Error("No columns!");
    }

    public Object getValueAt(int row, int column) {
        if (this.result_set != null) {
            try {
                this.result_set.absolute(row + 1);
                return this.result_set.getObject(column + 1);
            }
            catch (SQLException e) {
                throw new Error("SQL Exception: " + e.getMessage());
            }
        }
        throw new Error("No contents!");
    }
}

