/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.jfccontrols;

import com.mckoi.jfccontrols.Query;
import com.mckoi.jfccontrols.SwingBlockUtil;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class QueryAgent {
    private Connection connection = null;
    private SwingBlockUtil block_util;
    private QueryThread query_thread;
    private char query_finished = (char)102;
    private SQLException sql_exception;
    private ResultSet result_set;
    private static QueryAgent query_agent = null;

    public QueryAgent(Connection connection) {
        this.connection = connection;
        this.block_util = new SwingBlockUtil();
        this.query_thread = new QueryThread();
        this.query_thread.start();
    }

    public Connection connection() {
        return this.connection;
    }

    public ResultSet executeQuery(Query query) throws SQLException, InterruptedException {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Not on the event dispatcher.");
        }
        if (this.query_finished != 'f') {
            throw new Error("Can't nest queries.");
        }
        PreparedStatement statement = this.connection.prepareStatement(query.getString());
        for (int i = 0; i < query.parameterCount(); ++i) {
            statement.setObject(i + 1, query.getParameter(i));
        }
        this.query_thread.addStatement(statement);
        this.query_finished = (char)110;
        this.block_util.block();
        if (this.query_finished == 'e') {
            SQLException e = this.sql_exception;
            this.sql_exception = null;
            this.query_finished = (char)102;
            throw e;
        }
        if (this.query_finished == 'r') {
            ResultSet rs = this.result_set;
            this.result_set = null;
            this.query_finished = (char)102;
            return rs;
        }
        if (this.query_finished == 'c') {
            this.query_finished = (char)102;
            throw new InterruptedException("Query Cancelled");
        }
        char old_state = this.query_finished;
        this.query_finished = (char)102;
        throw new Error("Unknown query state: " + old_state);
    }

    public void cancelQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (QueryAgent.this.query_finished != 'f') {
                    QueryAgent.this.query_finished = 'c';
                    QueryAgent.this.block_util.unblock();
                }
            }
        });
    }

    private EventQueue eventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    private boolean isQueryDone() {
        return this.query_finished != 'n';
    }

    private void notifyException(PreparedStatement statement, final SQLException e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (QueryAgent.this.query_finished != 'f') {
                    QueryAgent.this.sql_exception = e;
                    QueryAgent.this.query_finished = 'e';
                    QueryAgent.this.block_util.unblock();
                }
            }
        });
    }

    private void notifyComplete(PreparedStatement statement, final ResultSet result_set) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (QueryAgent.this.query_finished != 'f') {
                    QueryAgent.this.result_set = result_set;
                    QueryAgent.this.query_finished = 'r';
                    QueryAgent.this.block_util.unblock();
                }
            }
        });
    }

    public static void initAgent(Connection connection) {
        if (query_agent == null) {
            query_agent = new QueryAgent(connection);
        }
    }

    public static QueryAgent getDefaultAgent() {
        return query_agent;
    }

    public static ResultSet execute(Query query) throws SQLException, InterruptedException {
        return QueryAgent.getDefaultAgent().executeQuery(query);
    }

    public static void cancel() {
        QueryAgent.getDefaultAgent().cancelQuery();
    }

    private class QueryThread
    extends Thread {
        private ArrayList statements = new ArrayList();

        private QueryThread() {
            this.setDaemon(true);
            this.setName("Mckoi - Query Agent");
        }

        private synchronized void addStatement(PreparedStatement statement) {
            this.statements.add(statement);
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: while (true) {
                try {
                    while (true) {
                        PreparedStatement to_exec = null;
                        QueryThread queryThread = this;
                        synchronized (queryThread) {
                            while (this.statements.size() == 0) {
                                this.wait();
                            }
                            to_exec = (PreparedStatement)this.statements.remove(0);
                        }
                        try {
                            ResultSet result_set = to_exec.executeQuery();
                            QueryAgent.this.notifyComplete(to_exec, result_set);
                            continue block7;
                        }
                        catch (SQLException e) {
                            QueryAgent.this.notifyException(to_exec, e);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    System.err.println("Exception during QueryThread: " + e.getMessage());
                    e.printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }
    }
}

