/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.jfccontrols;

import com.mckoi.util.TimeFrame;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

public class Query
implements Cloneable {
    private String query_string;
    private ArrayList parameters;

    public Query(String query) {
        this.query_string = query;
    }

    private void internalSet(int index, Object ob) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        for (int i = this.parameters.size(); i < index; ++i) {
            this.parameters.add(null);
        }
        Object old = this.parameters.set(index - 1, ob);
        if (old != null) {
            // empty if block
        }
    }

    public String getString() {
        return this.query_string;
    }

    public int parameterCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public Object getParameter(int index) {
        return this.parameters.get(index);
    }

    public Query changeSQL(String sql) {
        try {
            Query query = (Query)this.clone();
            query.query_string = sql;
            return query;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Query: " + this.query_string + "\n");
        str.append("Parameters: ");
        for (int i = 0; i < this.parameterCount(); ++i) {
            str.append(this.getParameter(i));
            str.append(", ");
        }
        return new String(str);
    }

    public void setString(int para_index, String str) {
        this.internalSet(para_index, str);
    }

    public void setBoolean(int para_index, boolean val) {
        this.internalSet(para_index, new Boolean(val));
    }

    public void setBigDecimal(int para_index, BigDecimal val) {
        this.internalSet(para_index, val);
    }

    public void setInt(int para_index, int val) {
        this.internalSet(para_index, new BigDecimal(val));
    }

    public void setLong(int para_index, long val) {
        this.internalSet(para_index, new BigDecimal(val));
    }

    public void setDouble(int para_index, double val) {
        this.internalSet(para_index, new BigDecimal(val));
    }

    public void setDate(int para_index, Date val) {
        this.internalSet(para_index, val);
    }

    public void setTimeFrame(int para_index, TimeFrame val) {
        this.internalSet(para_index, val.getPeriod());
    }

    public void setObject(int para_index, Object val) {
        if (val == null || val instanceof BigDecimal || val instanceof String || val instanceof Date || val instanceof Boolean) {
            this.internalSet(para_index, val);
        } else if (val instanceof TimeFrame) {
            this.setTimeFrame(para_index, (TimeFrame)val);
        } else if (val instanceof Integer) {
            this.internalSet(para_index, new BigDecimal((Integer)val));
        } else if (val instanceof Long) {
            this.internalSet(para_index, new BigDecimal((Long)val));
        } else if (val instanceof Double) {
            this.internalSet(para_index, new BigDecimal((Double)val));
        } else {
            this.setString(para_index, val.toString());
        }
    }
}

