/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.debug;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public final class Debug {
    private static final boolean PRINT_ALERT_TO_MESSAGES = false;
    private static final boolean EXCEPTIONS_TO_ERR = false;
    public static final int INFORMATION = 10;
    public static final int WARNING = 20;
    public static final int ALERT = 30;
    public static final int ERROR = 40;
    public static final int MESSAGE = 10000;
    private static final Object debug_lock = new Object();
    static final PrintWriter SYSTEM_OUT = new PrintWriter(System.out, true);
    static final PrintWriter SYSTEM_ERR = new PrintWriter(System.err, true);
    static int debug_level = 0;
    static PrintWriter out = SYSTEM_ERR;
    static PrintWriter err = SYSTEM_ERR;

    private static final void internalWrite(PrintWriter out, int level, String class_string, String message) {
        if (level < 10000) {
            out.print("> ");
            out.print(class_string);
            out.print(" ( lvl: ");
            out.print(level);
            out.print(" )\n  ");
        } else {
            out.print("% ");
        }
        out.println(message);
        out.flush();
    }

    public static final void setOutput(Writer out) {
        Debug.out = new PrintWriter(out, false);
    }

    public static final void setDebugLevel(int level) {
        debug_level = level;
    }

    public static final void listenToEventDispatcher() {
        System.setProperty("sun.awt.exception.handler", "com.mckoi.debug.DispatchNotify");
    }

    public static final boolean isInterestedIn(int level) {
        return level >= debug_level;
    }

    public static final void write(int level, Object ob, String message) {
        Debug.write(level, ob.getClass().getName(), message);
    }

    public static final void write(int level, Class cla, String message) {
        Debug.write(level, cla.getName(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void write(int level, String class_string, String message) {
        if (Debug.isInterestedIn(level)) {
            Object object = debug_lock;
            synchronized (object) {
                if (level >= 40 && level < 10000) {
                    Debug.internalWrite(SYSTEM_ERR, level, class_string, message);
                }
                Debug.internalWrite(out, level, class_string, message);
            }
        }
    }

    public static final void write(Object ob, String message) {
        Debug.write(5, ob, message);
    }

    private static final void writeTime() {
        out.print("[ TIME: ");
        out.print(new Date(System.currentTimeMillis()));
        out.println(" ]");
        out.flush();
    }

    public static final void writeException(Throwable e) {
        Debug.writeException(40, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeException(int level, Throwable e) {
        Object object = debug_lock;
        synchronized (object) {
            if (level >= 40) {
                System.err.print("[com.mckoi.debug.Debug - Exception thrown: '");
                System.err.print(e.getMessage());
                System.err.println("']");
                e.printStackTrace(System.err);
            }
            if (Debug.isInterestedIn(level)) {
                Debug.writeTime();
                out.print("% ");
                e.printStackTrace(out);
                out.flush();
            }
        }
    }
}

