/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.sql;

import com.mckoi.database.Expression;
import com.mckoi.database.FunctionDef;
import com.mckoi.database.Operator;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import com.mckoi.database.sql.Token;
import com.mckoi.util.BigNumber;

public class Util {
    private static TObject ZERO_NUMBER = TObject.intVal(0);

    public static String asNonQuotedRef(Token token) {
        if (token.kind == 196) {
            return token.image.substring(1, token.image.length() - 1);
        }
        if (token.kind == 199 || token.kind == 203) {
            String image = token.image;
            StringBuffer b = new StringBuffer();
            int sz = image.length();
            for (int i = 0; i < sz; ++i) {
                char c = image.charAt(i);
                if (c == '\"') continue;
                b.append(c);
            }
            return new String(b);
        }
        return token.image;
    }

    public static Object toParamObject(Token token, boolean upper_identifiers) {
        if (token.kind == 195) {
            String raw_string = token.image.substring(1, token.image.length() - 1);
            return TObject.stringVal(Util.escapeTranslated(raw_string));
        }
        if (token.kind == 19) {
            return TObject.booleanVal(token.image.equalsIgnoreCase("true"));
        }
        if (token.kind == 20) {
            return TObject.nullVal();
        }
        if (token.kind == 21) {
            String str = token.image.substring(5).trim();
            return TObject.stringVal(str);
        }
        if (token.kind == 196 || token.kind == 202 || token.kind == 197 || token.kind == 198 || token.kind == 199) {
            Variable v;
            int div;
            String name = Util.asNonQuotedRef(token);
            if (upper_identifiers) {
                name = name.toUpperCase();
            }
            if ((div = name.lastIndexOf(".")) != -1) {
                String column_name = name.substring(div + 1);
                TableName table_name = TableName.resolve(name.substring(0, div));
                v = new Variable(table_name, column_name);
            } else {
                v = new Variable(name);
            }
            return v;
        }
        String name = token.image;
        if (upper_identifiers) {
            name = name.toUpperCase();
        }
        return new Variable(token.image);
    }

    public static TObject zeroNumber() {
        return ZERO_NUMBER;
    }

    public static TObject parseNumberToken(Token token, boolean negative) {
        if (negative) {
            return TObject.bigNumberVal(BigNumber.fromString("-" + token.image));
        }
        return TObject.bigNumberVal(BigNumber.fromString(token.image));
    }

    public static TObject toArrayParamObject(Expression[] arr) {
        return new TObject(TType.ARRAY_TYPE, arr);
    }

    public static String expressionListToString(Expression[] list) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            buf.append(list[i].text().toString());
            if (i >= list.length - 1) continue;
            buf.append(", ");
        }
        return new String(buf);
    }

    public static Expression normalize(Expression exp) {
        if (exp.containsNotOperator()) {
            return Util.normalize(exp, false);
        }
        return exp;
    }

    private static Expression normalize(Expression exp, boolean inverse) {
        if (exp.size() <= 1) {
            if (inverse) {
                return Util.standardInverse(exp);
            }
            return exp;
        }
        Operator op = (Operator)exp.last();
        Expression[] exps = exp.split();
        if (op.isNot()) {
            return Util.normalize(exps[0], !inverse);
        }
        if (op.isNotInversible()) {
            Expression resolved_expr = new Expression(Util.normalize(exps[0], false), op, Util.normalize(exps[1], false));
            if (inverse) {
                return Util.standardInverse(resolved_expr);
            }
            return resolved_expr;
        }
        if (op.isLogical()) {
            if (inverse) {
                return new Expression(Util.normalize(exps[0], inverse), op.inverse(), Util.normalize(exps[1], inverse));
            }
            return new Expression(Util.normalize(exps[0], inverse), op, Util.normalize(exps[1], inverse));
        }
        if (inverse) {
            return new Expression(Util.normalize(exps[0], false), op.inverse(), Util.normalize(exps[1], false));
        }
        return new Expression(Util.normalize(exps[0], false), op, Util.normalize(exps[1], false));
    }

    private static Expression standardInverse(Expression exp) {
        return new Expression(exp, Operator.get("="), new Expression(TObject.booleanVal(false)));
    }

    public static FunctionDef resolveFunctionName(String name, Expression[] exp_list) {
        return new FunctionDef(name, exp_list);
    }

    private static String escapeTranslated(String input) {
        StringBuffer result = new StringBuffer();
        int size = input.length();
        boolean last_char_escape = false;
        boolean last_char_quote = false;
        for (int i = 0; i < size; ++i) {
            char c = input.charAt(i);
            if (last_char_quote) {
                last_char_quote = false;
                if (c == '\'') continue;
                result.append(c);
                continue;
            }
            if (last_char_escape) {
                if (c == '\\') {
                    result.append('\\');
                } else if (c == '\'') {
                    result.append('\'');
                } else if (c == 't') {
                    result.append('\t');
                } else if (c == 'n') {
                    result.append('\n');
                } else if (c == 'r') {
                    result.append('\r');
                } else {
                    result.append('\\');
                    result.append(c);
                }
                last_char_escape = false;
                continue;
            }
            if (c == '\\') {
                last_char_escape = true;
                continue;
            }
            if (c == '\'') {
                last_char_quote = true;
                result.append(c);
                continue;
            }
            result.append(c);
        }
        return new String(result);
    }
}

