/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbcserver;

import com.mckoi.database.Database;
import com.mckoi.database.jdbcserver.ConnectionPoolServer;
import com.mckoi.database.jdbcserver.ServerConnection;
import com.mckoi.debug.DebugLogger;
import java.io.IOException;
import java.util.ArrayList;

final class MultiThreadedConnectionPoolServer
implements ConnectionPoolServer {
    private static final boolean DISPLAY_STATS = false;
    private Database database;
    private ArrayList client_threads;

    MultiThreadedConnectionPoolServer(Database database) {
        this.database = database;
        this.client_threads = new ArrayList();
    }

    public final DebugLogger Debug() {
        return this.database.Debug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ServerConnection connection) {
        ClientThread client_thread = new ClientThread(connection);
        ArrayList arrayList = this.client_threads;
        synchronized (arrayList) {
            this.client_threads.add(client_thread);
        }
        client_thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList arrayList = this.client_threads;
        synchronized (arrayList) {
            int size = this.client_threads.size();
            for (int i = 0; i < size; ++i) {
                ((ClientThread)this.client_threads.get(i)).close();
            }
        }
    }

    private class ClientThread
    extends Thread {
        private ServerConnection server_connection;
        private boolean client_closed;
        private boolean processing_command;

        public ClientThread(ServerConnection connection) {
            this.setName("Mckoi - Client Connection");
            this.server_connection = connection;
            this.client_closed = false;
            this.processing_command = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkCurrentConnection() throws InterruptedException {
            try {
                ClientThread clientThread = this;
                synchronized (clientThread) {
                    while (this.processing_command) {
                        if (this.client_closed) {
                            return;
                        }
                        this.wait(120000L);
                    }
                }
                this.server_connection.blockForRequest();
                this.processing_command = true;
                MultiThreadedConnectionPoolServer.this.database.execute(null, null, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            try {
                                ClientThread.this.server_connection.processRequest();
                            }
                            catch (IOException e) {
                                MultiThreadedConnectionPoolServer.this.Debug().writeException(10, e);
                                Object var3_2 = null;
                                ClientThread.this.processing_command = false;
                                ClientThread clientThread2 = ClientThread.this;
                                synchronized (clientThread2) {
                                    ClientThread.this.notifyAll();
                                    return;
                                }
                            }
                            Object var3_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            ClientThread.this.processing_command = false;
                            ClientThread clientThread = ClientThread.this;
                            synchronized (clientThread) {
                                ClientThread.this.notifyAll();
                                throw throwable;
                            }
                        }
                        ClientThread.this.processing_command = false;
                        ClientThread clientThread = ClientThread.this;
                        synchronized (clientThread) {
                            ClientThread.this.notifyAll();
                            return;
                        }
                    }
                });
            }
            catch (IOException e) {
                this.close();
                MultiThreadedConnectionPoolServer.this.Debug().write(10, this, "IOException generated while checking connections, removing provider.");
                MultiThreadedConnectionPoolServer.this.Debug().writeException(10, e);
            }
        }

        public synchronized void close() {
            this.client_closed = true;
            try {
                this.server_connection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        boolean closed = false;
                        Object object = this;
                        synchronized (object) {
                            closed = this.client_closed;
                        }
                        if (closed) {
                            object = MultiThreadedConnectionPoolServer.this.client_threads;
                            synchronized (object) {
                                MultiThreadedConnectionPoolServer.this.client_threads.remove(this);
                            }
                            return;
                        }
                        this.checkCurrentConnection();
                    }
                }
                catch (Throwable e) {
                    MultiThreadedConnectionPoolServer.this.Debug().write(40, this, "Connection Pool Farmer Error");
                    MultiThreadedConnectionPoolServer.this.Debug().writeException(e);
                    continue;
                }
                break;
            }
        }
    }
}

