/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.jdbc.AbstractStreamableObject;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.MSQLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

class MStreamableBlob
extends AbstractStreamableObject
implements Blob {
    MStreamableBlob(MConnection connection, int result_set_id, byte type, long streamable_object_id, long size) {
        super(connection, result_set_id, type, streamable_object_id, size);
    }

    public long length() throws SQLException {
        return this.rawSize();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (--pos < 0L || pos + (long)length > this.length()) {
            throw new SQLException("Out of bounds.");
        }
        byte[] buf = new byte[length];
        InputStream i_stream = this.getBinaryStream();
        try {
            i_stream.skip(pos);
            for (int i = 0; i < length; ++i) {
                buf[i] = (byte)i_stream.read();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw new SQLException("IO Error: " + e.getMessage());
        }
        return buf;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new AbstractStreamableObject.StreamableObjectInputStream(this.rawSize());
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw MSQLException.unsupported();
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw MSQLException.unsupported();
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw MSQLException.unsupported();
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw MSQLException.unsupported();
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void truncate(long len) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void free() throws SQLException {
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        long end = pos + length;
        if (end > this.rawSize() || end < 0L) {
            throw new IndexOutOfBoundsException();
        }
        AbstractStreamableObject.StreamableObjectInputStream is = new AbstractStreamableObject.StreamableObjectInputStream(end);
        try {
            ((InputStream)is).skip(pos);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return is;
    }
}

