/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.StreamableObject;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.MDriver;
import com.mckoi.database.jdbc.MResultSet;
import com.mckoi.database.jdbc.MSQLException;
import com.mckoi.database.jdbc.SQLQuery;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.util.Vector;

class MStatement
implements Statement {
    private MConnection connection;
    private MResultSet[] result_set_list;
    private int max_field_size;
    private int max_row_count;
    private int query_timeout;
    private int fetch_size;
    private SQLWarning head_warning;
    private boolean escape_processing;
    private Vector batch_list;
    private Vector streamable_object_list;
    private int multi_result_set_index;

    MStatement(MConnection connection) {
        this.connection = connection;
        this.escape_processing = true;
    }

    final void addSQLWarning(SQLWarning warning) {
        if (this.head_warning == null) {
            this.head_warning = warning;
        } else {
            this.head_warning.setNextWarning(warning);
        }
    }

    final MResultSet[] internalResultSetList(int count) {
        int i;
        if (count <= 0) {
            throw new Error("'count' must be > 0");
        }
        if (this.result_set_list != null && this.result_set_list.length != count) {
            for (i = 0; i < this.result_set_list.length; ++i) {
                this.result_set_list[i].dispose();
            }
            this.result_set_list = null;
        }
        if (this.result_set_list == null) {
            this.result_set_list = new MResultSet[count];
            for (i = 0; i < count; ++i) {
                this.result_set_list[i] = new MResultSet(this.connection, this);
            }
        }
        return this.result_set_list;
    }

    final MResultSet internalResultSet() {
        return this.internalResultSetList(1)[0];
    }

    protected StreamableObject createStreamableObject(InputStream x, int length, byte type) {
        StreamableObject s_ob = this.connection.createStreamableObject(x, length, type);
        if (this.streamable_object_list == null) {
            this.streamable_object_list = new Vector();
        }
        this.streamable_object_list.add(s_ob);
        return s_ob;
    }

    protected void addBatch(SQLQuery query) {
        if (this.batch_list == null) {
            this.batch_list = new Vector();
        }
        this.batch_list.add(query);
    }

    protected MResultSet executeQuery(SQLQuery query) throws SQLException {
        MResultSet result_set = this.internalResultSet();
        this.executeQueries(new SQLQuery[]{query});
        return result_set;
    }

    protected MResultSet[] executeQueries(SQLQuery[] queries) throws SQLException {
        int i;
        MResultSet[] results = this.internalResultSetList(queries.length);
        this.multi_result_set_index = 0;
        for (i = 0; i < queries.length; ++i) {
            queries[i].prepare(this.escape_processing);
            results[i].closeCurrentResult();
        }
        this.connection.executeQueries(queries, results);
        for (i = 0; i < queries.length; ++i) {
            MResultSet result_set = results[i];
            result_set.setFetchSize(this.fetch_size);
            result_set.setMaxRowCount(this.max_row_count);
            boolean contains_large_objects = result_set.containsLargeObjects();
            if (!contains_large_objects && result_set.rowCount() < 40) {
                result_set.storeResultLocally();
                continue;
            }
            result_set.updateResultPart(0, Math.min(10, result_set.rowCount()));
        }
        return results;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(new SQLQuery(sql));
    }

    public int executeUpdate(String sql) throws SQLException {
        MResultSet result_set = this.executeQuery(new SQLQuery(sql));
        return result_set.intValue();
    }

    public void close() throws SQLException {
        if (this.result_set_list != null) {
            for (int i = 0; i < this.result_set_list.length; ++i) {
                this.result_set_list[i].dispose();
            }
            this.result_set_list = null;
        }
        if (this.streamable_object_list != null) {
            int sz = this.streamable_object_list.size();
            for (int i = 0; i < sz; ++i) {
                StreamableObject s_object = (StreamableObject)this.streamable_object_list.elementAt(i);
                this.connection.removeStreamableObject(s_object);
            }
            this.streamable_object_list = null;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("MaxFieldSize negative.");
        }
        this.max_field_size = max;
    }

    public int getMaxRows() throws SQLException {
        return this.max_row_count;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("MaxRows negative.");
        }
        this.max_row_count = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escape_processing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.query_timeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("Negative query timout.");
        }
        this.query_timeout = seconds;
        MDriver.QUERY_TIMEOUT = seconds;
    }

    public void cancel() throws SQLException {
        if (this.result_set_list != null) {
            for (int i = 0; i < this.result_set_list.length; ++i) {
                this.connection.disposeResult(this.result_set_list[i].getResultID());
            }
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.head_warning;
    }

    public void clearWarnings() throws SQLException {
        this.head_warning = null;
    }

    public void setCursorName(String name) throws SQLException {
    }

    public boolean execute(String sql) throws SQLException {
        MResultSet result_set = this.executeQuery(new SQLQuery(sql));
        return !result_set.isUpdate();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.result_set_list != null && this.multi_result_set_index < this.result_set_list.length) {
            return this.result_set_list[this.multi_result_set_index];
        }
        return null;
    }

    public int getUpdateCount() throws SQLException {
        MResultSet rs;
        if (this.result_set_list != null && this.multi_result_set_index < this.result_set_list.length && (rs = this.result_set_list[this.multi_result_set_index]).isUpdate()) {
            return rs.intValue();
        }
        return -1;
    }

    public boolean getMoreResults() throws SQLException {
        if (this.result_set_list == null || this.multi_result_set_index >= this.result_set_list.length) {
            return false;
        }
        ++this.multi_result_set_index;
        return true;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException("Negative fetch size.");
        }
        this.fetch_size = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetch_size;
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        return 1004;
    }

    public void addBatch(String sql) throws SQLException {
        this.addBatch(new SQLQuery(sql));
    }

    public void clearBatch() throws SQLException {
        this.batch_list = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.batch_list == null) {
            throw new SQLException("Batch list is empty - nothing to do.");
        }
        int sz = this.batch_list.size();
        SQLQuery[] batch_query_list = new SQLQuery[sz];
        for (int i = 0; i < sz; ++i) {
            batch_query_list[i] = (SQLQuery)this.batch_list.elementAt(i);
        }
        try {
            MResultSet[] batch_results = this.executeQueries(batch_query_list);
            int[] update_result = new int[sz];
            for (int i = 0; i < sz; ++i) {
                update_result[i] = batch_results[i].intValue();
                batch_results[i].closeCurrentResult();
            }
            nArray = update_result;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return nArray;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.getMoreResults();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw MSQLException.unsupported();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw MSQLException.unsupported();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw MSQLException.unsupported();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw MSQLException.unsupported();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw MSQLException.unsupported();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw MSQLException.unsupported();
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw MSQLException.unsupported();
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public boolean isClosed() throws SQLException {
        return this.result_set_list == null;
    }

    public void setPoolable(boolean poolable) throws SQLException {
    }

    public boolean isPoolable() throws SQLException {
        return true;
    }

    public Object unwrap(Class iface) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

