/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.ColumnDescription;
import com.mckoi.database.global.ObjectTranslator;
import com.mckoi.database.global.StreamableObject;
import com.mckoi.database.global.StringObject;
import com.mckoi.database.jdbc.MBlob;
import com.mckoi.database.jdbc.MClob;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.MResultSetMetaData;
import com.mckoi.database.jdbc.MSQLException;
import com.mckoi.database.jdbc.MStatement;
import com.mckoi.database.jdbc.MStreamableBlob;
import com.mckoi.database.jdbc.MStreamableClob;
import com.mckoi.util.BigNumber;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public final class MResultSet
implements ResultSet {
    private static final int DEFAULT_FETCH_SIZE = 32;
    private static final int MAXIMUM_FETCH_SIZE = 512;
    private static int unique_id_key = 1;
    private static BigNumber BD_ZERO = BigNumber.fromInt(0);
    private int unique_id;
    private MConnection connection;
    private MStatement statement;
    private SQLWarning head_warning;
    private int result_id;
    private ColumnDescription[] col_list;
    private int query_time_ms;
    private int result_row_count;
    private int max_row_count = Integer.MAX_VALUE;
    private int block_top_row;
    private int block_row_count;
    private int fetch_size;
    private Vector result_block;
    private int real_index = Integer.MAX_VALUE;
    private int real_index_offset = -1;
    private boolean last_was_null = false;
    private Hashtable column_hash;
    private boolean closed_on_server;

    MResultSet(MConnection connection, MStatement statement) {
        this.connection = connection;
        this.statement = statement;
        this.unique_id = unique_id_key++;
        this.result_id = -1;
        this.result_block = new Vector();
    }

    void addSQLWarning(SQLWarning warning) {
        if (this.head_warning == null) {
            this.head_warning = warning;
        } else {
            this.head_warning.setNextWarning(warning);
        }
    }

    boolean verboseColumnNames() {
        return this.connection.verboseColumnNames();
    }

    void connSetup(int result_id, ColumnDescription[] col_list, int total_row_count) {
        this.result_id = result_id;
        this.col_list = col_list;
        this.result_row_count = total_row_count;
        this.block_top_row = -1;
        this.result_block.removeAllElements();
        this.real_index = -1;
        this.fetch_size = 32;
        this.closed_on_server = false;
    }

    void setQueryTime(int time_ms) {
        this.query_time_ms = time_ms;
    }

    void setMaxRowCount(int row_count) {
        this.max_row_count = row_count == 0 ? Integer.MAX_VALUE : row_count;
    }

    boolean containsLargeObjects() {
        for (int i = 0; i < this.col_list.length; ++i) {
            ColumnDescription col = this.col_list[i];
            int sql_type = col.getSQLType();
            if (sql_type != -2 && sql_type != -3 && sql_type != -4 && sql_type != 2004 && sql_type != 1 && sql_type != 12 && sql_type != -1 && sql_type != 2005) continue;
            return true;
        }
        return false;
    }

    void storeResultLocally() throws SQLException {
        this.updateResultPart(0, this.rowCount());
        this.connection.disposeResult(this.result_id);
        this.closed_on_server = true;
    }

    void updateResultPart(int row_index, int row_count) throws SQLException {
        if (row_count == 0) {
            return;
        }
        if (row_index + row_count < 0) {
            throw new SQLException("ResultSet row index is before the start of the set.");
        }
        if (row_index < 0) {
            row_index = 0;
            row_count += row_index;
        }
        if (row_index >= this.rowCount()) {
            throw new SQLException("ResultSet row index is after the end of the set.");
        }
        if (row_index + row_count > this.rowCount()) {
            row_count = this.rowCount() - row_index;
        }
        if (this.result_id == -1) {
            throw new SQLException("result_id == -1.  No result to get from.");
        }
        try {
            this.result_block = this.connection.getRowCache().getResultPart(this.result_block, this.connection, this.result_id, row_index, row_count, this.columnCount(), this.rowCount());
            this.block_top_row = row_index;
            this.block_row_count = row_count;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException("IO Error: " + e.getMessage());
        }
    }

    void closeCurrentResult() throws SQLException {
        if (this.getResultID() != -1) {
            if (!this.closed_on_server) {
                this.connection.disposeResult(this.result_id);
                this.closed_on_server = true;
            }
            this.result_id = -1;
            this.real_index = Integer.MAX_VALUE;
            if (this.column_hash != null) {
                this.column_hash.clear();
            }
        }
    }

    int getResultID() {
        return this.result_id;
    }

    int rowCount() {
        return Math.min(this.result_row_count, this.max_row_count);
    }

    int columnCount() {
        return this.col_list.length;
    }

    ColumnDescription getColumn(int column) {
        return this.col_list[column];
    }

    boolean isUpdate() {
        return this.columnCount() == 1 && this.rowCount() == 1 && this.getColumn(0).getName().equals("@aresult");
    }

    int intValue() throws SQLException {
        if (this.isUpdate()) {
            Object ob = this.result_block.elementAt(0);
            if (ob instanceof BigNumber) {
                return ((BigNumber)ob).intValue();
            }
            return 0;
        }
        throw new SQLException("Unable to format query result as an update value.");
    }

    void dispose() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection = null;
        this.statement = null;
        this.col_list = null;
        this.result_block = null;
    }

    void ensureIndexLoaded() throws SQLException {
        if (this.real_index == -1) {
            throw new SQLException("Row index out of bounds.");
        }
        int row_offset = this.real_index - this.block_top_row;
        if (row_offset >= this.block_row_count) {
            this.updateResultPart(this.real_index, this.fetch_size);
            row_offset = this.real_index - this.block_top_row;
            this.real_index_offset = row_offset * this.columnCount();
        } else if (row_offset < 0) {
            int fs_dif = Math.min(this.fetch_size, 8);
            this.updateResultPart(this.real_index - this.fetch_size + fs_dif, this.fetch_size);
            row_offset = this.real_index - this.block_top_row;
            this.real_index_offset = row_offset * this.columnCount();
        }
    }

    int findColumnIndex(String name) throws SQLException {
        Integer index;
        boolean case_insensitive;
        if (this.column_hash == null) {
            this.column_hash = new Hashtable();
        }
        if (case_insensitive = this.connection.isCaseInsensitiveIdentifiers()) {
            name = name.toUpperCase();
        }
        if ((index = (Integer)this.column_hash.get(name)) == null) {
            String col_name;
            int i;
            int col_count = this.columnCount();
            String[] cols = new String[col_count];
            for (i = 0; i < col_count; ++i) {
                col_name = this.col_list[i].getName();
                if (col_name.startsWith("\"")) {
                    col_name = col_name.substring(1, col_name.length() - 1);
                }
                if (col_name.startsWith("@")) {
                    col_name = col_name.substring(2);
                }
                if (case_insensitive) {
                    col_name = col_name.toUpperCase();
                }
                cols[i] = col_name;
            }
            for (i = 0; i < col_count; ++i) {
                col_name = cols[i];
                if (!col_name.equals(name)) continue;
                this.column_hash.put(name, new Integer(i + 1));
                return i + 1;
            }
            String point_name = "." + name;
            for (int i2 = 0; i2 < col_count; ++i2) {
                String col_name2 = cols[i2];
                if (!col_name2.endsWith(point_name)) continue;
                this.column_hash.put(name, new Integer(i2 + 1));
                return i2 + 1;
            }
            throw new SQLException("Couldn't find column with name: " + name);
        }
        return index;
    }

    Object getRawColumn(int column) throws SQLException {
        if (column < 1 || column > this.columnCount()) {
            throw new SQLException("Column index out of bounds: 1 > " + column + " > " + this.columnCount());
        }
        this.ensureIndexLoaded();
        Object ob = this.result_block.elementAt(this.real_index_offset + (column - 1));
        if (ob != null) {
            this.last_was_null = false;
            if (this.getColumn(column - 1).getSQLType() == 2000) {
                ob = ObjectTranslator.deserialize((ByteLongObject)ob);
            }
            return ob;
        }
        this.last_was_null = true;
        return null;
    }

    Object getRawColumn(String name) throws SQLException {
        return this.getRawColumn(this.findColumnIndex(name));
    }

    private void realIndexUpdate() throws SQLException {
        int row_offset = this.real_index - this.block_top_row;
        this.real_index_offset = row_offset * this.columnCount();
        this.clearWarnings();
    }

    private boolean canMakeString(Object ob) {
        return ob instanceof StringObject || ob instanceof StreamableObject;
    }

    private String makeString(Object ob) throws SQLException {
        if (ob instanceof StreamableObject) {
            Clob clob = this.asClob(ob);
            long clob_len = clob.length();
            if (clob_len < 0x40000000L) {
                return clob.getSubString(1L, (int)clob_len);
            }
            throw new SQLException("Clob too large to return as a string.");
        }
        if (ob instanceof ByteLongObject) {
            throw new ClassCastException();
        }
        return ob.toString();
    }

    private Blob asBlob(Object ob) {
        if (ob instanceof StreamableObject) {
            StreamableObject s_ob = (StreamableObject)ob;
            byte type = (byte)(s_ob.getType() & 0xF);
            if (type == 2) {
                return new MStreamableBlob(this.connection, this.result_id, type, s_ob.getIdentifier(), s_ob.getSize());
            }
        } else if (ob instanceof ByteLongObject) {
            return new MBlob((ByteLongObject)ob);
        }
        throw new ClassCastException();
    }

    private Clob asClob(Object ob) {
        if (ob instanceof StreamableObject) {
            StreamableObject s_ob = (StreamableObject)ob;
            byte type = (byte)(s_ob.getType() & 0xF);
            if (type == 3 || type == 4) {
                return new MStreamableClob(this.connection, this.result_id, type, s_ob.getIdentifier(), s_ob.getSize());
            }
        } else if (ob instanceof StringObject) {
            return new MClob(ob.toString());
        }
        throw new ClassCastException();
    }

    private Object jdbcObjectCast(Object ob, int sql_type) throws SQLException {
        switch (sql_type) {
            case -7: {
                return ob;
            }
            case -6: {
                return new Byte(((BigNumber)ob).byteValue());
            }
            case 5: {
                return new Short(((BigNumber)ob).shortValue());
            }
            case 4: {
                return new Integer(((BigNumber)ob).intValue());
            }
            case -5: {
                return new Long(((BigNumber)ob).longValue());
            }
            case 6: {
                return new Double(((BigNumber)ob).doubleValue());
            }
            case 7: {
                return new Float(((BigNumber)ob).floatValue());
            }
            case 8: {
                return new Double(((BigNumber)ob).doubleValue());
            }
            case 2: {
                return ((BigNumber)ob).asBigDecimal();
            }
            case 3: {
                return ((BigNumber)ob).asBigDecimal();
            }
            case 1: {
                return this.makeString(ob);
            }
            case 12: {
                return this.makeString(ob);
            }
            case -1: {
                return this.makeString(ob);
            }
            case 91: {
                return new Date(((java.util.Date)ob).getTime());
            }
            case 92: {
                return new Time(((java.util.Date)ob).getTime());
            }
            case 93: {
                return new Timestamp(((java.util.Date)ob).getTime());
            }
            case -4: 
            case -3: 
            case -2: {
                Blob b = this.asBlob(ob);
                return b.getBytes(1L, (int)b.length());
            }
            case 0: {
                return ob;
            }
            case 1111: {
                return ob;
            }
            case 2000: {
                return ob;
            }
            case 2001: {
                return ob;
            }
            case 2002: {
                return ob;
            }
            case 2003: {
                return ob;
            }
            case 2004: {
                return this.asBlob(ob);
            }
            case 2005: {
                return this.asClob(ob);
            }
            case 2006: {
                return ob;
            }
        }
        return ob;
    }

    public int extQueryTimeMillis() {
        return this.query_time_ms;
    }

    public java.util.Date extGetDate(int columnIndex) throws SQLException {
        return (java.util.Date)this.getRawColumn(columnIndex);
    }

    public java.util.Date extGetDate(String columnName) throws SQLException {
        return this.extGetDate(this.findColumnIndex(columnName));
    }

    public boolean next() throws SQLException {
        int row_count = this.rowCount();
        if (this.real_index < row_count) {
            ++this.real_index;
            if (this.real_index < row_count) {
                this.realIndexUpdate();
            }
        }
        return this.real_index < row_count;
    }

    public void close() throws SQLException {
        this.closeCurrentResult();
    }

    public boolean wasNull() throws SQLException {
        return this.last_was_null;
    }

    public String getString(int columnIndex) throws SQLException {
        Object str = this.getRawColumn(columnIndex);
        if (str == null) {
            return null;
        }
        if (this.canMakeString(str)) {
            return this.makeString(str);
        }
        if (str instanceof java.util.Date) {
            int sql_type = this.getColumn(columnIndex - 1).getSQLType();
            return this.jdbcObjectCast(str, sql_type).toString();
        }
        return str.toString();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Object ob = this.getRawColumn(columnIndex);
        if (ob == null) {
            return false;
        }
        if (ob instanceof Boolean) {
            return (Boolean)ob;
        }
        if (ob instanceof BigNumber) {
            return ((BigNumber)ob).compareTo(BD_ZERO) != 0;
        }
        if (this.canMakeString(ob)) {
            return this.makeString(ob).equalsIgnoreCase("true");
        }
        throw new SQLException("Unable to cast value in ResultSet to boolean");
    }

    public byte getByte(int columnIndex) throws SQLException {
        BigNumber num = this.getBigNumber(columnIndex);
        return num == null ? (byte)0 : num.byteValue();
    }

    public short getShort(int columnIndex) throws SQLException {
        BigNumber num = this.getBigNumber(columnIndex);
        return num == null ? (short)0 : num.shortValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        BigNumber num = this.getBigNumber(columnIndex);
        return num == null ? 0 : num.intValue();
    }

    public long getLong(int columnIndex) throws SQLException {
        BigNumber num = this.getBigNumber(columnIndex);
        return num == null ? 0L : num.longValue();
    }

    public float getFloat(int columnIndex) throws SQLException {
        BigNumber num = this.getBigNumber(columnIndex);
        return num == null ? 0.0f : num.floatValue();
    }

    public double getDouble(int columnIndex) throws SQLException {
        BigNumber num = this.getBigNumber(columnIndex);
        return num == null ? 0.0 : num.doubleValue();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        Blob b = this.getBlob(columnIndex);
        if (b == null) {
            return null;
        }
        if (b.length() <= Integer.MAX_VALUE) {
            return b.getBytes(1L, (int)b.length());
        }
        throw new SQLException("Blob too large to return as byte[]");
    }

    public Date getDate(int columnIndex) throws SQLException {
        java.util.Date d = this.extGetDate(columnIndex);
        if (d != null) {
            return new Date(d.getTime());
        }
        return null;
    }

    public Time getTime(int columnIndex) throws SQLException {
        java.util.Date d = this.extGetDate(columnIndex);
        if (d != null) {
            return new Time(d.getTime());
        }
        return null;
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        java.util.Date d = this.extGetDate(columnIndex);
        if (d != null) {
            return new Timestamp(d.getTime());
        }
        return null;
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        Clob c = this.getClob(columnIndex);
        if (c == null) {
            return null;
        }
        return c.getAsciiStream();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLException("Deprecated method not supported");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Blob blob = this.getBlob(columnIndex);
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumnIndex(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumnIndex(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumnIndex(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumnIndex(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumnIndex(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumnIndex(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumnIndex(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumnIndex(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumnIndex(columnName));
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumnIndex(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumnIndex(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumnIndex(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumnIndex(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumnIndex(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumnIndex(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumnIndex(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.head_warning;
    }

    public void clearWarnings() throws SQLException {
        this.head_warning = null;
    }

    public String getCursorName() throws SQLException {
        throw MSQLException.unsupported();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new MResultSetMetaData(this);
    }

    public Object getObject(int columnIndex) throws SQLException {
        Object ob = this.getRawColumn(columnIndex);
        if (ob == null) {
            return ob;
        }
        if (this.connection.isStrictGetObject()) {
            ColumnDescription col_desc = this.getColumn(columnIndex - 1);
            int sql_type = col_desc.getSQLType();
            return this.jdbcObjectCast(ob, sql_type);
        }
        if (ob instanceof ByteLongObject || ob instanceof StreamableObject) {
            return this.asBlob(ob);
        }
        return ob;
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumnIndex(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        return this.findColumnIndex(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigNumber bnum = this.getBigNumber(columnIndex);
        if (bnum != null) {
            return bnum.asBigDecimal();
        }
        return null;
    }

    private BigNumber getBigNumber(int columnIndex) throws SQLException {
        Object ob = this.getRawColumn(columnIndex);
        if (ob == null) {
            return null;
        }
        if (ob instanceof BigNumber) {
            return (BigNumber)ob;
        }
        return BigNumber.fromString(this.makeString(ob));
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumnIndex(columnName));
    }

    public void setFetchSize(int rows) throws SQLException {
        this.fetch_size = rows > 0 ? Math.min(rows, 512) : 32;
    }

    public int getFetchSize() throws SQLException {
        return this.fetch_size;
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Clob c = this.getClob(columnIndex);
        if (c == null) {
            return null;
        }
        return c.getCharacterStream();
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumnIndex(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.real_index < 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.real_index >= this.rowCount();
    }

    public boolean isFirst() throws SQLException {
        return this.real_index == 0;
    }

    public boolean isLast() throws SQLException {
        return this.real_index == this.rowCount() - 1;
    }

    public void beforeFirst() throws SQLException {
        this.real_index = -1;
    }

    public void afterLast() throws SQLException {
        this.real_index = this.rowCount();
    }

    public boolean first() throws SQLException {
        this.real_index = 0;
        this.realIndexUpdate();
        return this.real_index < this.rowCount();
    }

    public boolean last() throws SQLException {
        this.real_index = this.rowCount() - 1;
        this.realIndexUpdate();
        return this.real_index >= 0;
    }

    public int getRow() throws SQLException {
        return this.real_index + 1;
    }

    public boolean absolute(int row) throws SQLException {
        if (row > 0) {
            this.real_index = row - 1;
        } else if (row < 0) {
            this.real_index = this.rowCount() + row;
        }
        this.realIndexUpdate();
        return this.real_index >= 0 && this.real_index < this.rowCount();
    }

    public boolean relative(int rows) throws SQLException {
        this.real_index += rows;
        int row_count = this.rowCount();
        if (this.real_index < -1) {
            this.real_index = -1;
        }
        if (this.real_index > row_count) {
            this.real_index = row_count;
        }
        this.realIndexUpdate();
        return this.real_index >= 0 && this.real_index < this.rowCount();
    }

    public boolean previous() throws SQLException {
        if (this.real_index >= 0) {
            --this.real_index;
            this.realIndexUpdate();
        }
        return this.real_index >= 0;
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        throw MSQLException.unsupported();
    }

    public boolean rowInserted() throws SQLException {
        throw MSQLException.unsupported();
    }

    public boolean rowDeleted() throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateNull(String columnName) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void insertRow() throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateRow() throws SQLException {
        throw MSQLException.unsupported();
    }

    public void deleteRow() throws SQLException {
        throw MSQLException.unsupported();
    }

    public void refreshRow() throws SQLException {
        throw MSQLException.unsupported();
    }

    public void cancelRowUpdates() throws SQLException {
        throw MSQLException.unsupported();
    }

    public void moveToInsertRow() throws SQLException {
        throw MSQLException.unsupported();
    }

    public void moveToCurrentRow() throws SQLException {
        throw MSQLException.unsupported();
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.getObject(i);
    }

    public Ref getRef(int i) throws SQLException {
        throw MSQLException.unsupported();
    }

    public Blob getBlob(int i) throws SQLException {
        Object ob = this.getRawColumn(i);
        if (ob != null) {
            try {
                return this.asBlob(ob);
            }
            catch (ClassCastException e) {
                throw new SQLException("Column " + i + " is not a binary column.");
            }
        }
        return null;
    }

    public Clob getClob(int i) throws SQLException {
        Object ob = this.getRawColumn(i);
        if (ob != null) {
            try {
                return this.asClob(ob);
            }
            catch (ClassCastException e) {
                throw new SQLException("Column " + i + " is not a character column.");
            }
        }
        return null;
    }

    public Array getArray(int i) throws SQLException {
        throw MSQLException.unsupported();
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(colName);
    }

    public Ref getRef(String colName) throws SQLException {
        throw MSQLException.unsupported();
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumnIndex(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumnIndex(colName));
    }

    public Array getArray(String colName) throws SQLException {
        throw MSQLException.unsupported();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(columnName);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(columnName);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(columnName);
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw MSQLException.unsupported();
    }

    public URL getURL(String columnName) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public RowId getRowId(int columnIndex) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public RowId getRowId(String columnLabel) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public boolean isClosed() throws SQLException {
        return this.getResultID() == -1;
    }

    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public NClob getNClob(int columnIndex) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public NClob getNClob(String columnLabel) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public String getNString(int columnIndex) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public String getNString(String columnLabel) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public Object unwrap(Class iface) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        throw MSQLException.unsupported16();
    }

    public void finalize() {
        this.dispose();
    }
}

